/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.internal.ui.properties;

import com.ibm.debug.pdt.core.breakpoints.PICLBreakpoint;
import com.ibm.debug.pdt.core.breakpoints.PICLWatchBreakpoint;
import com.ibm.debug.pdt.internal.core.PICLLabels;
import com.ibm.debug.pdt.internal.core.model.Watchpoint;
import com.ibm.debug.pdt.internal.ui.properties.BreakpointPropertySourceAdapter;
import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.PropertyDescriptor;

public class WatchpointPropertySourceAdapter
extends BreakpointPropertySourceAdapter {
    private static final String LOCATION = "picl_BP.location";
    private static final String SIZE = "picl_BP.size";
    private static final String WATCHPOINT_CATEGORY_LABEL = "4 " + PICLLabels.picl_BP_watchpoint;
    private static final PropertyDescriptor[] WATCHPOINT_PROPERTY_DESCRIPTORS = new PropertyDescriptor[]{new PropertyDescriptor((Object)"picl_BP.location", PICLLabels.picl_function_location), new PropertyDescriptor((Object)"picl_BP.size", PICLLabels.picl_BP_size)};
    private static final PropertyDescriptor[] COMBINED_DESCRIPTORS;

    static {
        ArrayList<PropertyDescriptor> listBuilder = new ArrayList<PropertyDescriptor>(Arrays.asList(PROPERTY_DESCRIPTORS));
        int i = 0;
        while (i < WATCHPOINT_PROPERTY_DESCRIPTORS.length) {
            WATCHPOINT_PROPERTY_DESCRIPTORS[i].setCategory(WATCHPOINT_CATEGORY_LABEL);
            listBuilder.add(WATCHPOINT_PROPERTY_DESCRIPTORS[i]);
            ++i;
        }
        COMBINED_DESCRIPTORS = listBuilder.toArray(new PropertyDescriptor[listBuilder.size()]);
    }

    public WatchpointPropertySourceAdapter(PICLWatchBreakpoint source) {
        super((PICLBreakpoint)source);
    }

    @Override
    public IPropertyDescriptor[] getPropertyDescriptors() {
        return COMBINED_DESCRIPTORS;
    }

    @Override
    public Object getPropertyValue(Object id) {
        Object pv = super.getPropertyValue(id);
        if (pv != null) {
            return pv;
        }
        try {
            Watchpoint wp = (Watchpoint)this.fSource.getModelBreakpoint();
            if (id.equals(LOCATION)) {
                return wp.getAddress();
            }
            if (id.equals(SIZE)) {
                return wp.getByteCount();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }
}

