/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.internal.ui.properties;

import com.ibm.debug.pdt.internal.core.PICLLabels;
import com.ibm.debug.pdt.internal.core.model.Function;
import com.ibm.debug.pdt.internal.ui.properties.PropertySourceAdapter;
import java.util.ArrayList;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.PropertyDescriptor;

public class FunctionPropertySourceAdapter
extends PropertySourceAdapter {
    private static final String FUNCTION_NAME = "picl_function_function_name";
    private static final String RETURN_TYPE = "picl_function_return_type";
    private static final String LOCATION = "picl_function_location";
    private Function fSource;

    public FunctionPropertySourceAdapter(Function source) {
        this.fSource = source;
    }

    public IPropertyDescriptor[] getPropertyDescriptors() {
        if (this.fSource.haveDoneCleanup()) {
            return EMPTYDESCRIPTORS;
        }
        try {
            ArrayList<PropertyDescriptor> list = new ArrayList<PropertyDescriptor>();
            list.add(new PropertyDescriptor((Object)FUNCTION_NAME, PICLLabels.picl_function_function_name));
            if (this.fSource.getReturnType() != null) {
                list.add(new PropertyDescriptor((Object)RETURN_TYPE, PICLLabels.picl_function_return_type));
            }
            list.add(new PropertyDescriptor((Object)LOCATION, PICLLabels.picl_function_location));
            return list.toArray(new IPropertyDescriptor[list.size()]);
        }
        catch (NullPointerException nullPointerException) {
            return EMPTYDESCRIPTORS;
        }
    }

    public Object getPropertyValue(Object id) {
        try {
            if (id.equals(FUNCTION_NAME)) {
                return this.fSource.getName();
            }
            if (id.equals(RETURN_TYPE)) {
                return this.fSource.getReturnType();
            }
            if (id.equals(LOCATION)) {
                return this.fSource.getViewFile().getFileName() + ":" + this.fSource.getLocation().getLineNumber();
            }
            return "*unknown*";
        }
        catch (NullPointerException nullPointerException) {
            return null;
        }
    }
}

