/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.internal.ui.properties;

import com.ibm.debug.pdt.core.breakpoints.PICLBreakpoint;
import com.ibm.debug.pdt.internal.core.PICLLabels;
import com.ibm.debug.pdt.internal.core.model.Breakpoint;
import com.ibm.debug.pdt.internal.ui.properties.PropertySourceAdapter;
import java.util.Arrays;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.PropertyDescriptor;

public class BreakpointPropertySourceAdapter
extends PropertySourceAdapter {
    private static final String THREAD = "picl_BP.thread";
    private static final String FROM = "picl_BP.from";
    private static final String TO = "picl_BP.to";
    private static final String EVERY = "picl_BP.every";
    private static final String STATE = "picl_BP.state";
    private static final String SUSPEND_ALL = "picl_BP.suspend_all";
    private static final String COND_EXPR = "picl_location_BP.cond_exp";
    private static final String ADDRESS = "picl_address_BP.address";
    private static final String[] CATEGORY_LABELS;
    protected static final PropertyDescriptor[] PROPERTY_DESCRIPTORS;
    private static final int[] CATEGORY_MAPPING;
    protected final PICLBreakpoint fSource;

    static {
        String[] stringArray = new String[4];
        stringArray[1] = "1 " + PICLLabels.debug_element_breakpoint;
        stringArray[2] = "2 " + PICLLabels.picl_BP_conditional;
        stringArray[3] = "3 " + PICLLabels.picl_BP_frequency;
        CATEGORY_LABELS = stringArray;
        PROPERTY_DESCRIPTORS = new PropertyDescriptor[]{new PropertyDescriptor((Object)STATE, PICLLabels.picl_BP_state), new PropertyDescriptor((Object)ADDRESS, PICLLabels.picl_BP_address), new PropertyDescriptor((Object)THREAD, PICLLabels.picl_BP_thread), new PropertyDescriptor((Object)COND_EXPR, PICLLabels.picl_location_BP_cond_exp), new PropertyDescriptor((Object)SUSPEND_ALL, PICLLabels.picl_BP_suspend_all), new PropertyDescriptor((Object)FROM, PICLLabels.picl_BP_from), new PropertyDescriptor((Object)TO, PICLLabels.picl_BP_to), new PropertyDescriptor((Object)EVERY, PICLLabels.picl_BP_every)};
        CATEGORY_MAPPING = new int[]{1, 1, 2, 2, 2, 3, 3, 3};
        int i = 0;
        while (i < PROPERTY_DESCRIPTORS.length && i < CATEGORY_MAPPING.length) {
            PROPERTY_DESCRIPTORS[i].setCategory(CATEGORY_LABELS[CATEGORY_MAPPING[i]]);
            ++i;
        }
    }

    public BreakpointPropertySourceAdapter(PICLBreakpoint source) {
        this.fSource = source;
    }

    public IPropertyDescriptor[] getPropertyDescriptors() {
        return (IPropertyDescriptor[])Arrays.copyOf(PROPERTY_DESCRIPTORS, PROPERTY_DESCRIPTORS.length);
    }

    public Object getPropertyValue(Object id) {
        try {
            Breakpoint bp = this.fSource.getModelBreakpoint();
            if (id.equals(THREAD)) {
                int thrdID = bp.getThreadID();
                if (thrdID == 0) {
                    return PICLLabels.picl_BP_every;
                }
                try {
                    if (bp.getThread() != null) {
                        return bp.getThread().getName();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return thrdID;
            }
            if (id.equals(FROM)) {
                return bp.getFromVal();
            }
            if (id.equals(TO)) {
                if (bp.getToVal() == 0) {
                    return PICLLabels.picl_BP_infinity;
                }
                return bp.getToVal();
            }
            if (id.equals(EVERY)) {
                return bp.getEveryVal();
            }
            if (id.equals(STATE)) {
                if (bp.isEnabled()) {
                    return PICLLabels.picl_BP_enabled;
                }
                return PICLLabels.picl_BP_disabled;
            }
            if (id.equals(ADDRESS)) {
                return bp.getAddress();
            }
            if (id.equals(COND_EXPR)) {
                return bp.getConditionalExpression();
            }
            if (id.equals(SUSPEND_ALL)) {
                if (bp.isStopSynchronous()) {
                    return PICLLabels.picl_BP_true;
                }
                return PICLLabels.picl_BP_false;
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return null;
    }
}

