/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.internal.ui.preferences;

import com.ibm.debug.pdt.internal.ui.PICLUtils;
import com.ibm.debug.pdt.internal.ui.preferences.PreferenceUIConstants;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.AbstractPreferenceInitializer;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.resource.StringConverter;
import org.eclipse.swt.graphics.RGB;
import org.osgi.service.prefs.BackingStoreException;

public class PDTUIPreferenceInitializer
extends AbstractPreferenceInitializer {
    private static final Object fLock = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initializeDefaultPreferences() {
        this.migratePrefrences();
        IEclipsePreferences node = DefaultScope.INSTANCE.getNode("com.ibm.debug.pdt.ui");
        node.putBoolean("socket_timeout", true);
        node.putInt("socket_timeout_sec", 15);
        node.put("execution_line_colour", StringConverter.asString((RGB)new RGB(0, 255, 255)));
        node.put("preference.terminate", "terminate");
        node.put("preference.disconnect", "ProcessRelease");
        node.putBoolean("enable_bidi_arabic_shaping", false);
        node.putBoolean("enable_bidi_visual_editing", false);
        node.putBoolean("debug_info_filter", true);
        node.putBoolean("include_stack_entries", true);
        node.putInt("pref_remember_fork", -1);
        node.putBoolean("syncStop", false);
        node.putBoolean("hide_running_threads", false);
        node.putBoolean("locals_sort", true);
        node.putInt("monitor_view_sashweight_1", 70);
        node.putInt("monitor_view_sashweight_2", 30);
        node.putBoolean("monitor_view_show_detailpane", true);
        node.putBoolean("monitor_view_rendering_mode", false);
        node.putInt("monitor_view_expand_depth", 1);
        node.putInt("hover_sashweight_1", 70);
        node.putInt("hover_sashweight_2", 30);
        node.put("defaultRendering", "");
        IExtensionPoint ep = Platform.getExtensionRegistry().getExtensionPoint("com.ibm.debug.pdt.ui.debuggerpreferencedefaults");
        if (ep != null) {
            String defaultValue = null;
            IConfigurationElement[] defaults = ep.getConfigurationElements();
            boolean loadDefaults = defaults.length > 0;
            defaultValue = loadDefaults ? defaults[0].getAttribute("alwaysUseDebuggerEditorDefaultValue") : null;
            node.putBoolean("always_use_debugger_editor", defaultValue == null ? true : Boolean.valueOf(defaultValue));
            defaultValue = loadDefaults ? defaults[0].getAttribute("useDebuggerEditorWhenLargeFileDefaultValue") : null;
            node.putBoolean("use_debugger_editor_when_large_file", defaultValue == null ? false : Boolean.valueOf(defaultValue));
            defaultValue = loadDefaults ? defaults[0].getAttribute("lineNumberLimitDefaultValue") : null;
            node.putInt("line_number_limit", defaultValue == null ? 10000 : Integer.parseInt(defaultValue));
            defaultValue = loadDefaults ? defaults[0].getAttribute("loadEntireFileDefaultValue") : null;
            node.putBoolean("load_entire_file", defaultValue == null ? false : Boolean.valueOf(defaultValue));
            defaultValue = loadDefaults ? defaults[0].getAttribute("allowHoverEvaluationDefaultValue") : null;
            node.putBoolean("allow_hover_evaluation", defaultValue == null ? true : Boolean.valueOf(defaultValue));
            defaultValue = loadDefaults ? defaults[0].getAttribute("doubleClickToAddMonitorDefaultValue") : null;
            node.putBoolean("double_click_to_add_monitor", defaultValue == null ? false : Boolean.valueOf(defaultValue));
            defaultValue = loadDefaults ? defaults[0].getAttribute("doubleClickToAddMonitorDefaultValueGeneral") : null;
            node.putBoolean("double_click_to_add_monitor_general", defaultValue == null ? false : Boolean.valueOf(defaultValue));
            defaultValue = loadDefaults ? defaults[0].getAttribute("centerViewOnExecutionLineDefaultValue") : null;
            node.putBoolean("center_view_execution", defaultValue == null ? false : Boolean.valueOf(defaultValue));
            defaultValue = loadDefaults ? defaults[0].getAttribute("saveExceptionSettingsByProfileDefaultValue") : null;
            node.putBoolean("save_exceptions_by_profile", defaultValue == null ? false : Boolean.valueOf(defaultValue));
            defaultValue = loadDefaults ? defaults[0].getAttribute("daemonSwitchPerspectiveIDDefaultValue") : null;
            node.put("switch_perspective_id", defaultValue == null ? "org.eclipse.debug.ui.DebugPerspective" : defaultValue);
            defaultValue = loadDefaults ? defaults[0].getAttribute("displayValuesDefaultValue") : null;
            node.putBoolean("display_values_on_array_structs", defaultValue == null ? true : Boolean.valueOf(defaultValue));
            if (loadDefaults) {
                Object object = fLock;
                synchronized (object) {
                    defaultValue = defaults[0].getAttribute("alwaysUseDebuggerEditorShowPreference");
                    if (defaultValue != null) {
                        PreferenceUIConstants.SHOW_ALWAYSUSEDEBUGGEREDITORPREF = Boolean.valueOf(defaultValue);
                    }
                    if ((defaultValue = defaults[0].getAttribute("loadEntireFileShowPreference")) != null) {
                        PreferenceUIConstants.SHOW_LOADENTIREFILEPREF = Boolean.valueOf(defaultValue);
                    }
                    if ((defaultValue = defaults[0].getAttribute("allowHoverEvaluationShowPreference")) != null) {
                        PreferenceUIConstants.SHOW_ALLOWHOVEREVALUATIONPREF = Boolean.valueOf(defaultValue);
                    }
                    if ((defaultValue = defaults[0].getAttribute("doubleClickToAddMonitorShowPreference")) != null) {
                        PreferenceUIConstants.SHOW_DOUBLECLICKTOADDMONITORPREF = Boolean.valueOf(defaultValue);
                    }
                    if ((defaultValue = defaults[0].getAttribute("doubleClickToAddMonitorShowPreferenceGeneral")) != null) {
                        PreferenceUIConstants.SHOW_DOUBLECLICKTOADDMONITORPREF_GENERAL = Boolean.valueOf(defaultValue);
                    }
                    if ((defaultValue = defaults[0].getAttribute("centerViewOnExecutionLineShowPreference")) != null) {
                        PreferenceUIConstants.SHOW_CENTERVIEWONEXECUTIONLINEPREF = Boolean.valueOf(defaultValue);
                    }
                    if ((defaultValue = defaults[0].getAttribute("executionLineColourShowPreference")) != null) {
                        PreferenceUIConstants.SHOW_EXECUTIONLINECOLORPREF = Boolean.valueOf(defaultValue);
                    }
                    if ((defaultValue = defaults[0].getAttribute("deleteProgramProfilesShowPreference")) != null) {
                        PreferenceUIConstants.SHOW_DELETEPROGRAMPROFILESPREF = Boolean.valueOf(defaultValue);
                    }
                    if ((defaultValue = defaults[0].getAttribute("saveExceptionSettingsByProfileShowPreference")) != null) {
                        PreferenceUIConstants.SHOW_SAVEEXCEPTIONSBYPROFILEPREF = Boolean.valueOf(defaultValue);
                    }
                    if ((defaultValue = defaults[0].getAttribute("traceOptionsShowPreference")) != null) {
                        PreferenceUIConstants.SHOW_TRACEOPTIONSPREF = Boolean.valueOf(defaultValue);
                    }
                    if ((defaultValue = defaults[0].getAttribute("resetHiddenMessagesShowPreference")) != null) {
                        PreferenceUIConstants.SHOW_RESETHIDDENMESSAGESPREF = Boolean.valueOf(defaultValue);
                    }
                    if ((defaultValue = defaults[0].getAttribute("daemonSwitchPerspectiveIDShowPreference")) != null) {
                        PreferenceUIConstants.SHOW_SWITCHPERSPECTIVEIDPREF = Boolean.valueOf(defaultValue);
                    }
                    if ((defaultValue = defaults[0].getAttribute("daemonSwitchCustomPerspectiveIDShowPreference")) != null) {
                        PreferenceUIConstants.SHOW_CUSTOMSWITCHPERSPECTIVEIDPREF = Boolean.valueOf(defaultValue);
                    }
                    if ((defaultValue = defaults[0].getAttribute("displayValuesShowPreference")) != null) {
                        PreferenceUIConstants.SHOW_DISPLAYVALUESPREF = Boolean.valueOf(defaultValue);
                    }
                    if ((defaultValue = defaults[0].getAttribute("globalSearchPathShowPreference")) != null) {
                        PreferenceUIConstants.SHOW_GLOBAL_SEARCH_PATH = Boolean.valueOf(defaultValue);
                    }
                }
            }
        }
    }

    private void migratePrefrences() {
        IEclipsePreferences node = InstanceScope.INSTANCE.getNode("com.ibm.debug.pdt.ui");
        String migratedKey = "migrated.hidden_msg";
        try {
            try {
                if (!node.getBoolean(migratedKey, false)) {
                    String[] stringArray = node.keys();
                    int n = stringArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String value;
                        String key = stringArray[n2];
                        if (key.startsWith("hidden_msg/") && (value = node.get(key, null)) != null) {
                            node.put("hidden_msg." + key.substring("hidden_msg/".length()), value);
                            node.remove(key);
                        }
                        ++n2;
                    }
                }
            }
            catch (BackingStoreException e) {
                PICLUtils.logError((Exception)((Object)e));
                node.putBoolean(migratedKey, true);
            }
        }
        finally {
            node.putBoolean(migratedKey, true);
        }
    }
}

