/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.internal.ui.memory;

import com.ibm.debug.pdt.internal.core.PDTCorePlugin;
import com.ibm.debug.pdt.internal.core.PDTDebugTarget;
import com.ibm.debug.pdt.internal.ui.memory.PICLMemoryBlock;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import org.eclipse.debug.core.model.IMemoryBlock;
import org.eclipse.debug.core.model.MemoryByte;
import org.eclipse.debug.internal.ui.memory.provisional.AbstractAsyncTextRendering;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;

public class TextRendering
extends AbstractAsyncTextRendering {
    private static final int numCharsPerByte = 1;
    public static final String ASCII_RENDERING_ID = "com.ibm.debug.pdt.rendering.ascii";
    public static final String EBCDIC_RENDERING_ID = "com.ibm.debug.pdt.rendering.ebcdic";
    private static final byte REPLACEMENTCHAR_ASCII = 46;
    private static final byte REPLACEMENTCHAR_EBCDIC = 75;
    String fCdepagePref;
    private byte fReplacementByte = (byte)46;

    public TextRendering(String renderingId, String codePagePref) {
        super(renderingId);
        this.fCdepagePref = codePagePref;
        String codepage = DebugUITools.getPreferenceStore().getString(this.fCdepagePref);
        this.setCodePage(codepage);
        if (renderingId.toUpperCase().contains("EBCDIC")) {
            this.fReplacementByte = (byte)75;
        }
        DebugUITools.getPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)this);
    }

    public void dispose() {
        DebugUITools.getPreferenceStore().removePropertyChangeListener((IPropertyChangeListener)this);
        super.dispose();
    }

    public int getNumCharsPerByte() {
        return 1;
    }

    public byte[] getBytes(String renderingId, BigInteger address, MemoryByte[] currentValues, String data) {
        IMemoryBlock memBlock = this.getMemoryBlock();
        if (memBlock instanceof PICLMemoryBlock && ((PDTDebugTarget)((PICLMemoryBlock)memBlock).getDebugTarget()).getEngineSession().hostBIDIStringsAreInVisualFormat()) {
            data = PDTCorePlugin.getBIDIEngine().convertLogicalToVisual(data);
        }
        byte[] updatedBytes = super.getBytes(renderingId, address, currentValues, data);
        byte LFbyte = 0;
        try {
            LFbyte = "\n".getBytes(this.getCodePage())[0];
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        int i = 0;
        while (i < updatedBytes.length && i < currentValues.length) {
            if (updatedBytes[i] == this.fReplacementByte && Character.isISOControl(currentValues[i].getValue())) {
                updatedBytes[i] = currentValues[i].getValue();
            } else if (updatedBytes[i] == 2) {
                updatedBytes[i] = LFbyte;
            }
            ++i;
        }
        return updatedBytes;
    }

    public String getString(String renderingId, BigInteger address, MemoryByte[] data) {
        IMemoryBlock memBlock;
        MemoryByte[] copy = new MemoryByte[data.length];
        byte[] lamAlefs = new byte[data.length];
        int i = 0;
        while (i < data.length) {
            copy[i] = new MemoryByte();
            if (Character.isISOControl(data[i].getValue())) {
                copy[i].setValue(this.fReplacementByte);
            } else if (i == 0 && this.isLF(data[i].getValue())) {
                copy[i].setValue((byte)2);
            } else if (i > 0 && this.isLF(data[i].getValue()) && !this.isCR(data[i - 1].getValue())) {
                copy[i].setValue((byte)2);
            } else if (this.getCodePage().equalsIgnoreCase("CP420") && this.isLamAlef(data[i].getValue())) {
                lamAlefs[i] = data[i].getValue();
                copy[i].setValue((byte)0);
            } else {
                copy[i].setValue(data[i].getValue());
            }
            copy[i].setFlags(data[i].getFlags());
            ++i;
        }
        String str = super.getString(renderingId, address, copy);
        if (this.getCodePage().equalsIgnoreCase("CP420")) {
            StringBuffer strBuff = new StringBuffer(str);
            int i2 = 0;
            while (i2 < lamAlefs.length) {
                if (lamAlefs[i2] != 0) {
                    strBuff.replace(i2, i2 + 1, this.getLamAlef(lamAlefs[i2]));
                }
                ++i2;
            }
            str = strBuff.toString();
        }
        if ((memBlock = this.getMemoryBlock()) instanceof PICLMemoryBlock && ((PDTDebugTarget)((PICLMemoryBlock)memBlock).getDebugTarget()).getEngineSession().hostBIDIStringsAreInVisualFormat()) {
            str = PDTCorePlugin.getBIDIEngine().convertVisualToLogical(str, false);
        }
        return str;
    }

    public boolean isLamAlef(byte currentByte) {
        return currentByte == -78 || currentByte == -77 || currentByte == -76 || currentByte == -75 || currentByte == -72 || currentByte == -71;
    }

    public String getLamAlef(byte currentByte) {
        if (currentByte == -78) {
            return Character.toString('\ufef5');
        }
        if (currentByte == -77) {
            return Character.toString('\ufef6');
        }
        if (currentByte == -76) {
            return Character.toString('\ufef7');
        }
        if (currentByte == -75) {
            return Character.toString('\ufef8');
        }
        if (currentByte == -72) {
            return Character.toString('\ufefb');
        }
        if (currentByte == -71) {
            return Character.toString('\ufefc');
        }
        return " ";
    }

    public boolean isCR(byte currentByte) {
        try {
            String currentElement = new String(new byte[]{currentByte}, this.getCodePage());
            if (currentElement.equals("\r")) {
                return true;
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return false;
    }

    public boolean isLF(byte currentByte) {
        try {
            String currentElement = new String(new byte[]{currentByte}, this.getCodePage());
            if (currentElement.equals("\n")) {
                return true;
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return false;
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (event.getProperty().equals(this.fCdepagePref)) {
            String codePage = (String)event.getNewValue();
            this.setCodePage(codePage);
            if (this.isVisible()) {
                this.updateLabels();
            }
        }
        super.propertyChange(event);
    }
}

