/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.internal.ui.memory;

import com.ibm.debug.pdt.internal.ui.PICLDebugPlugin;
import com.ibm.debug.pdt.internal.ui.memory.ITextRenderingRepAdvisor;
import com.ibm.debug.pdt.internal.ui.memory.OverrideRenderingManager;
import java.util.ArrayList;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.debug.core.model.IMemoryBlock;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.memory.AbstractMemoryRenderingBindingsProvider;
import org.eclipse.debug.ui.memory.IMemoryRenderingType;

public class PDTRenderingBindingProvider
extends AbstractMemoryRenderingBindingsProvider {
    private static final String DEFAULT_ASCII = "com.ibm.debug.pdt.rendering.ascii";
    private static final String DEFAULT_EBCDIC = "com.ibm.debug.pdt.rendering.ebcdic";
    private static final String DEFAULT_HEX = "org.eclipse.debug.ui.rendering.raw_memory";

    private String[] getRenderingNames(String attributeName) {
        IConfigurationElement[] overrideBindings = PICLDebugPlugin.getOverrideMemoryRenderingBindings();
        ArrayList<String> renderings = new ArrayList<String>();
        int i = 0;
        while (i < overrideBindings.length) {
            String rendering;
            if (overrideBindings[i].getName().equals("defaultRenderings") && (rendering = overrideBindings[i].getAttribute(attributeName)) != null) {
                String[] renderingNames = rendering.split(",");
                int n = 0;
                while (n < renderingNames.length) {
                    renderings.add(OverrideRenderingManager.instance().getRenderingId(renderingNames[n]));
                    ++n;
                }
            }
            ++i;
        }
        return renderings.toArray(new String[0]);
    }

    public IMemoryRenderingType[] getRenderingTypes(IMemoryBlock block) {
        String[] renderings = this.getRenderingNames("renderingIds");
        IMemoryRenderingType[] ret = new IMemoryRenderingType[renderings.length];
        int n = 0;
        while (n < renderings.length) {
            ret[n] = DebugUITools.getMemoryRenderingManager().getRenderingType(renderings[n]);
            ++n;
        }
        return ret;
    }

    public IMemoryRenderingType[] getDefaultRenderingTypes(IMemoryBlock block) {
        IMemoryRenderingType type = DebugUITools.getMemoryRenderingManager().getRenderingType(DEFAULT_ASCII);
        ITextRenderingRepAdvisor advisor = (ITextRenderingRepAdvisor)block.getAdapter(ITextRenderingRepAdvisor.class);
        String defaultEBCDIC = OverrideRenderingManager.instance().getRenderingId(DEFAULT_EBCDIC);
        String defaultASCII = OverrideRenderingManager.instance().getRenderingId(DEFAULT_ASCII);
        String primaryRendering = OverrideRenderingManager.instance().getRenderingId(DEFAULT_HEX);
        if (advisor != null) {
            int rep = advisor.getDefaultRepresentation();
            type = rep == 1 ? DebugUITools.getMemoryRenderingManager().getRenderingType(defaultEBCDIC) : DebugUITools.getMemoryRenderingManager().getRenderingType(defaultASCII);
            return new IMemoryRenderingType[]{DebugUITools.getMemoryRenderingManager().getRenderingType(primaryRendering), type};
        }
        return new IMemoryRenderingType[]{type};
    }

    public IMemoryRenderingType getPrimaryRenderingType(IMemoryBlock block) {
        return DebugUITools.getMemoryRenderingManager().getRenderingType(OverrideRenderingManager.instance().getRenderingId(DEFAULT_HEX));
    }
}

