/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.internal.ui.memory;

import com.ibm.debug.pdt.internal.core.PDTDebugElement;
import com.ibm.debug.pdt.internal.core.PICLLabels;
import com.ibm.debug.pdt.internal.core.util.PDTCoreUtils;
import com.ibm.debug.pdt.internal.ui.PICLDebugTarget;
import com.ibm.debug.pdt.internal.ui.memory.MapStorageAction;
import com.ibm.debug.pdt.internal.ui.memory.PICLMemoryBlock;
import java.util.HashSet;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.debug.core.model.IMemoryBlock;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.memory.IMemoryRenderingManager;
import org.eclipse.debug.ui.memory.IMemoryRenderingType;
import org.eclipse.ui.texteditor.ITextEditor;

public class HexTextRenderingAction
extends MapStorageAction {
    private static HashSet<String> fgAllowedHexRenderingIds = new HashSet();
    private static HashSet<String> fgAllowedCharRenderingIds = new HashSet();

    static {
        IExtensionPoint ep = Platform.getExtensionRegistry().getExtensionPoint("com.ibm.debug.pdt.ui.defaulthexcharrenderings");
        if (ep != null) {
            IConfigurationElement[] iConfigurationElementArray = ep.getConfigurationElements();
            int n = iConfigurationElementArray.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement element = iConfigurationElementArray[n2];
                String id = element.getAttribute("id");
                if (!PDTCoreUtils.isEmpty((String)id)) {
                    if ("hex".equals(element.getAttribute("type"))) {
                        fgAllowedHexRenderingIds.add(id);
                    } else {
                        fgAllowedCharRenderingIds.add(id);
                    }
                }
                ++n2;
            }
        }
    }

    public static HexTextRenderingAction editorRenderingActionFactory(ITextEditor editor, PICLMemoryBlock memblk, int numInMenu, PICLDebugTarget debugTarget) {
        IMemoryRenderingType[] defaultRenderings = HexTextRenderingAction.getDefaultRenderings(memblk);
        return new HexTextRenderingAction(editor, HexTextRenderingAction.getHexRendering(defaultRenderings), HexTextRenderingAction.getCharRendering(defaultRenderings), numInMenu, debugTarget);
    }

    public static HexTextRenderingAction elementRenderingActionFactory(PDTDebugElement element, PICLMemoryBlock memblk, int numInMenu) {
        IMemoryRenderingType[] defaultRenderings = HexTextRenderingAction.getDefaultRenderings(memblk);
        return new HexTextRenderingAction(element, HexTextRenderingAction.getHexRendering(defaultRenderings), HexTextRenderingAction.getCharRendering(defaultRenderings), numInMenu);
    }

    private static IMemoryRenderingType[] getDefaultRenderings(PICLMemoryBlock memblk) {
        IMemoryRenderingManager renMgr = DebugUITools.getMemoryRenderingManager();
        return renMgr.getDefaultRenderingTypes((IMemoryBlock)memblk);
    }

    private static IMemoryRenderingType getHexRendering(IMemoryRenderingType[] defaultRenderings) {
        IMemoryRenderingType[] iMemoryRenderingTypeArray = defaultRenderings;
        int n = defaultRenderings.length;
        int n2 = 0;
        while (n2 < n) {
            IMemoryRenderingType rendering = iMemoryRenderingTypeArray[n2];
            if (fgAllowedHexRenderingIds.contains(rendering.getId())) {
                return rendering;
            }
            ++n2;
        }
        return defaultRenderings.length > 0 ? defaultRenderings[0] : null;
    }

    private static IMemoryRenderingType getCharRendering(IMemoryRenderingType[] defaultRenderings) {
        IMemoryRenderingType[] iMemoryRenderingTypeArray = defaultRenderings;
        int n = defaultRenderings.length;
        int n2 = 0;
        while (n2 < n) {
            IMemoryRenderingType rendering = iMemoryRenderingTypeArray[n2];
            if (fgAllowedCharRenderingIds.contains(rendering.getId())) {
                return rendering;
            }
            ++n2;
        }
        return defaultRenderings.length > 1 ? defaultRenderings[1] : null;
    }

    private HexTextRenderingAction(ITextEditor editor, IMemoryRenderingType hexType, IMemoryRenderingType charType, int numInMenu, PICLDebugTarget debugTarget) {
        super(editor, hexType, numInMenu, debugTarget);
        this.completeLocalInit(charType, numInMenu);
    }

    private HexTextRenderingAction(PDTDebugElement element, IMemoryRenderingType hexType, IMemoryRenderingType charType, int numInMenu) {
        super(element, hexType, numInMenu);
        this.completeLocalInit(charType, numInMenu);
    }

    private void completeLocalInit(IMemoryRenderingType charType, int numInMenu) {
        this.fRenderingType2 = charType;
        this.setText(numInMenu + " " + PICLLabels.HexTextRenderingAction_label);
    }
}

