/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.internal.ui.launchconfig;

import com.ibm.debug.pdt.internal.core.PICLLabels;
import com.ibm.debug.pdt.internal.ui.PICLUtils;
import com.ibm.debug.pdt.internal.ui.preferences.PreferenceUIConstants;
import com.ibm.debug.pdt.ui.launchconfig.IConfigurationConstants;
import java.util.ArrayList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IPerspectiveRegistry;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.activities.WorkbenchActivityHelper;

public class DaemonIncomingTab
extends AbstractLaunchConfigurationTab
implements IConfigurationConstants,
SelectionListener {
    Text fProgramNameField;
    Button fDebugInitializationButton;
    private Button fSwitchPerspectiveButton;
    private Label fPerspectiveLabel;
    private Combo fPerspectiveText;
    private ArrayList<String> fPerspectiveIds;

    public void createControl(Composite parent) {
        Composite tabComposite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        tabComposite.setLayout((Layout)layout);
        GridData data = new GridData(768);
        tabComposite.setLayoutData((Object)data);
        Label programLabel = new Label(tabComposite, 64);
        programLabel.setText(PICLLabels.PICLLoadLaunchConfigTab1_programNameLabel);
        data = new GridData();
        data.horizontalSpan = 2;
        programLabel.setLayoutData((Object)data);
        data = new GridData(768);
        data.widthHint = 100;
        data.horizontalSpan = 2;
        this.fProgramNameField = new Text(tabComposite, 2052);
        this.fProgramNameField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent evt) {
                DaemonIncomingTab.this.updateLaunchConfigurationDialog();
            }
        });
        this.fProgramNameField.setLayoutData((Object)data);
        this.fDebugInitializationButton = new Button(tabComposite, 32);
        this.fDebugInitializationButton.setText(PICLLabels.PICLLoadLaunchConfigTab2_debugInitButtonLabel);
        data = new GridData(768);
        data.horizontalSpan = 2;
        data.widthHint = 100;
        this.fDebugInitializationButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                DaemonIncomingTab.this.updateLaunchConfigurationDialog();
            }

            public void widgetSelected(SelectionEvent e) {
                DaemonIncomingTab.this.updateLaunchConfigurationDialog();
            }
        });
        this.fDebugInitializationButton.setLayoutData((Object)data);
        if (PreferenceUIConstants.SHOW_CUSTOMSWITCHPERSPECTIVEIDPREF) {
            Label spacer = new Label(tabComposite, 0);
            data = new GridData(768);
            data.horizontalSpan = 2;
            spacer.setLayoutData((Object)data);
            this.fSwitchPerspectiveButton = new Button(tabComposite, 32);
            this.fSwitchPerspectiveButton.setText(PICLLabels.DaemonIncomingTab_Switch_Perspectives);
            data = new GridData(768);
            data.horizontalSpan = 2;
            this.fSwitchPerspectiveButton.setLayoutData((Object)data);
            this.fSwitchPerspectiveButton.addSelectionListener((SelectionListener)this);
            this.fPerspectiveLabel = new Label(tabComposite, 0);
            this.fPerspectiveLabel.setText(PICLLabels.DaemonIncomingTab_Perspectives);
            data = new GridData();
            data.horizontalIndent = 25;
            this.fPerspectiveLabel.setLayoutData((Object)data);
            this.fPerspectiveText = new Combo(tabComposite, 2048);
            this.fPerspectiveText.addSelectionListener((SelectionListener)this);
            this.loadPerspectives();
        }
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)tabComposite, PICLUtils.getHelpResourceString("remoted_compiled_application"));
        Dialog.applyDialogFont((Control)tabComposite);
        this.setControl((Control)tabComposite);
    }

    public Image getImage() {
        return PICLUtils.getImage("PICL_ICON_DAEMON_TAB");
    }

    public String getName() {
        return PICLLabels.picl_process_program;
    }

    public boolean isValid(ILaunchConfiguration launchConfig) {
        return false;
    }

    public void initializeFrom(ILaunchConfiguration config) {
        try {
            this.fProgramNameField.setText(config.getAttribute("ProgramName", ""));
            this.fDebugInitializationButton.setSelection(config.getAttribute("DebugInitialization", false));
            if (PreferenceUIConstants.SHOW_CUSTOMSWITCHPERSPECTIVEIDPREF) {
                int idx;
                boolean isNeedToInit = true;
                String perspective = config.getAttribute("Perspective", null);
                if (perspective != null && (idx = this.fPerspectiveIds.indexOf(perspective)) > -1) {
                    this.fPerspectiveText.select(idx);
                    this.fSwitchPerspectiveButton.setSelection(true);
                    isNeedToInit = false;
                }
                if (isNeedToInit) {
                    this.fPerspectiveText.select(0);
                    this.fSwitchPerspectiveButton.setSelection(false);
                }
                this.updatePerspectiveControls();
            }
        }
        catch (CoreException e) {
            PICLUtils.logError((Exception)((Object)e));
        }
    }

    public void performApply(ILaunchConfigurationWorkingCopy config) {
        config.setAttribute("ProgramName", this.fProgramNameField.getText());
        config.setAttribute("DebugInitialization", this.fDebugInitializationButton.getSelection());
        if (PreferenceUIConstants.SHOW_CUSTOMSWITCHPERSPECTIVEIDPREF) {
            if (this.fSwitchPerspectiveButton.getSelection()) {
                config.setAttribute("Perspective", this.fPerspectiveIds.get(this.fPerspectiveText.getSelectionIndex()));
            } else {
                config.removeAttribute("Perspective");
            }
        }
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy config) {
        config.setAttribute("ProgramName", "");
    }

    public void widgetSelected(SelectionEvent e) {
        this.setDirty(true);
        this.updatePerspectiveControls();
    }

    public void widgetDefaultSelected(SelectionEvent e) {
        this.widgetSelected(e);
    }

    protected void updatePerspectiveControls() {
        this.fPerspectiveLabel.setEnabled(this.fSwitchPerspectiveButton.getSelection());
        this.fPerspectiveText.setEnabled(this.fSwitchPerspectiveButton.getSelection());
        this.updateLaunchConfigurationDialog();
    }

    private void loadPerspectives() {
        IPerspectiveRegistry registry = PlatformUI.getWorkbench().getPerspectiveRegistry();
        IPerspectiveDescriptor[] descriptors = registry.getPerspectives();
        String label = null;
        this.fPerspectiveIds = new ArrayList();
        int i = 0;
        while (i < descriptors.length) {
            if (!WorkbenchActivityHelper.filterItem((Object)descriptors[i])) {
                label = descriptors[i].getLabel();
                this.fPerspectiveText.add(label);
                this.fPerspectiveIds.add(descriptors[i].getId());
            }
            ++i;
        }
    }
}

