/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.internal.ui.launchconfig;

import com.ibm.debug.pdt.internal.core.PICLLabels;
import com.ibm.debug.pdt.internal.ui.PICLUtils;
import com.ibm.debug.pdt.internal.ui.util.DebugConsoleUtils;
import com.ibm.debug.pdt.ui.launchconfig.IConfigurationConstants;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class CommandConsoleTab
extends AbstractLaunchConfigurationTab
implements IConfigurationConstants {
    private static final String EMPTY = "";
    private Text fStartupCommands;
    private Text fCommandsHistory;

    public void createControl(Composite parent) {
        Composite tabComposite = new Composite(parent, 0);
        tabComposite.setLayout((Layout)new GridLayout(1, true));
        tabComposite.setLayoutData((Object)new GridData(1808));
        this.createStartupCommandsSection(tabComposite);
        this.createVerticalSpacer(tabComposite, 1);
        this.createCommandsHistorySection(tabComposite);
        this.createVerticalSpacer(tabComposite, 1);
        Point p = this.fStartupCommands.computeSize(-1, -1);
        GridDataFactory.fillDefaults().grab(true, true).hint(-1, p.y).applyTo((Control)this.fStartupCommands);
        GridDataFactory.fillDefaults().grab(true, true).hint(-1, p.y).applyTo((Control)this.fCommandsHistory);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)tabComposite, PICLUtils.getHelpResourceString("remoted_compiled_application_debug_console"));
        Dialog.applyDialogFont((Control)tabComposite);
        this.setControl((Control)tabComposite);
    }

    private void createStartupCommandsSection(Composite parent) {
        Group startupGroup = new Group(parent, 0);
        startupGroup.setLayout((Layout)new GridLayout(1, true));
        startupGroup.setText(PICLLabels.DebugCommandConsoleTabStartupCommands_label);
        startupGroup.setLayoutData((Object)new GridData(1808));
        this.fStartupCommands = new Text((Composite)startupGroup, 2626);
        this.fStartupCommands.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent evt) {
                CommandConsoleTab.this.updateLaunchConfigurationDialog();
            }
        });
        this.fStartupCommands.setLayoutData((Object)new GridData(1808));
        Composite buttonComposite = new Composite((Composite)startupGroup, 0);
        buttonComposite.setLayout((Layout)new GridLayout(2, true));
        buttonComposite.setLayoutData((Object)new GridData(130));
        Button fImportCommandButton = new Button(buttonComposite, 8);
        fImportCommandButton.setLayoutData((Object)new GridData(800));
        fImportCommandButton.setText(PICLLabels.DebugConsoleViewImportLabel);
        fImportCommandButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                CommandConsoleTab.this.importCommands(CommandConsoleTab.this.fStartupCommands);
            }
        });
        Button fExportCommandButton = new Button(buttonComposite, 8);
        fExportCommandButton.setLayoutData((Object)new GridData(800));
        fExportCommandButton.setText(PICLLabels.DebugConsoleViewExportLabel);
        fExportCommandButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                CommandConsoleTab.this.exportCommands(CommandConsoleTab.this.fStartupCommands);
                CommandConsoleTab.this.updateLaunchConfigurationDialog();
            }
        });
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)buttonComposite, PICLUtils.getHelpResourceString("remoted_compiled_application_debug_console"));
        Dialog.applyDialogFont((Control)buttonComposite);
    }

    private void createCommandsHistorySection(Composite parent) {
        Group startupGroup = new Group(parent, 0);
        startupGroup.setLayout((Layout)new GridLayout(1, true));
        startupGroup.setText(PICLLabels.DebugCommandConsoleTabCommandHistory_label);
        startupGroup.setLayoutData((Object)new GridData(1808));
        this.fCommandsHistory = new Text((Composite)startupGroup, 2626);
        this.fCommandsHistory.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent evt) {
                CommandConsoleTab.this.updateLaunchConfigurationDialog();
            }
        });
        GridData data = new GridData(1808);
        this.fCommandsHistory.setLayoutData((Object)data);
        Composite buttonComposite = new Composite((Composite)startupGroup, 0);
        buttonComposite.setLayout((Layout)new GridLayout(2, true));
        buttonComposite.setLayoutData((Object)new GridData(130));
        Button fImportCommandButton = new Button(buttonComposite, 8);
        fImportCommandButton.setLayoutData((Object)new GridData(800));
        fImportCommandButton.setText(PICLLabels.DebugConsoleViewImportLabel_2);
        fImportCommandButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                CommandConsoleTab.this.importCommands(CommandConsoleTab.this.fCommandsHistory);
            }
        });
        Button fExportCommandButton = new Button(buttonComposite, 8);
        fExportCommandButton.setLayoutData((Object)new GridData(800));
        fExportCommandButton.setText(PICLLabels.DebugConsoleViewExportLabel_2);
        fExportCommandButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                CommandConsoleTab.this.exportCommands(CommandConsoleTab.this.fCommandsHistory);
            }
        });
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)buttonComposite, PICLUtils.getHelpResourceString("remoted_compiled_application_debug_console"));
        Dialog.applyDialogFont((Control)buttonComposite);
    }

    void exportCommands(Text exportingCommands) {
        String fileSavePath = DebugConsoleUtils.getExportFilePath(exportingCommands.getShell());
        if (fileSavePath == null) {
            return;
        }
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(fileSavePath, false), Charset.defaultCharset());){
                String commands = exportingCommands.getText();
                String selectedCommands = exportingCommands.getSelectionText();
                commands = selectedCommands.length() != 0 ? selectedCommands : commands;
                writer.write(commands);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            PICLUtils.logError(e);
        }
    }

    void importCommands(Text commands) {
        StringBuffer importedCommands = DebugConsoleUtils.getImportedCommandsFromFile(commands.getShell());
        commands.insert(importedCommands.toString());
        this.updateLaunchConfigurationDialog();
    }

    public Image getImage() {
        return PICLUtils.getImage("PICL_ICON_CVIEW_GDB_VIEW");
    }

    public String getName() {
        return PICLLabels.DebugCommandConsoleTab_label;
    }

    public void initializeFrom(ILaunchConfiguration config) {
        String configStartupList = EMPTY;
        String configCurrentList = EMPTY;
        try {
            configStartupList = config.getAttribute("StartupCommandList", EMPTY);
            configCurrentList = config.getAttribute("CommandHistoryList", EMPTY);
        }
        catch (CoreException ce) {
            PICLUtils.logError((Exception)((Object)ce));
        }
        this.fStartupCommands.setText(EMPTY);
        this.fCommandsHistory.setText(EMPTY);
        this.fStartupCommands.append(configStartupList);
        this.fCommandsHistory.append(configCurrentList);
    }

    public void performApply(ILaunchConfigurationWorkingCopy config) {
        config.setAttribute("StartupCommandList", this.fStartupCommands.getText());
        config.setAttribute("CommandHistoryList", this.fCommandsHistory.getText());
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy config) {
        config.setAttribute("StartupCommandList", EMPTY);
        config.setAttribute("CommandHistoryList", EMPTY);
    }

    public void activated(ILaunchConfigurationWorkingCopy workingCopy) {
    }

    public void deactivated(ILaunchConfigurationWorkingCopy workingCopy) {
    }
}

