/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.internal.ui.dialogs;

import com.ibm.debug.pdt.internal.core.PDTDebugTarget;
import com.ibm.debug.pdt.internal.core.PICLLabels;
import com.ibm.debug.pdt.internal.core.model.EventBreakpoint;
import com.ibm.debug.pdt.internal.core.model.Watchpoint;
import com.ibm.debug.pdt.internal.core.util.PDTCoreUtils;
import com.ibm.debug.pdt.internal.ui.PICLUtils;
import com.ibm.debug.pdt.internal.ui.dialogs.AbstractWatchBPWizardPage;
import com.ibm.debug.pdt.internal.ui.util.DialogField;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;

public class WatchBPWizardPage
extends AbstractWatchBPWizardPage {
    private Watchpoint fExistingBP = null;
    private static final String PAGE_NAME = "WatchBPWizard.page1";
    private static final String ADDRESS = "Address";

    protected WatchBPWizardPage(String pageName, String title, ImageDescriptor titleImage, PDTDebugTarget tgt, Watchpoint editBreakpoint) {
        super(pageName, title, titleImage, tgt, (EventBreakpoint)editBreakpoint);
        this.fExistingBP = editBreakpoint;
        this.setDescription(PICLLabels.WatchBPWizard_page1_description);
    }

    @Override
    public void createControl(Composite parent) {
        int nColumns = 3;
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = nColumns;
        composite.setLayout((Layout)layout);
        this.setControl((Control)composite);
        this.createAddrOrExprFieldAsChildWidget(composite, nColumns, null);
        this.createAddAndPopulateBytesToMonitorListAsChildWidget(composite, nColumns, null);
        this.createUserLabelField(composite, nColumns);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, PICLUtils.getHelpResourceString("watch_bp_wizard"));
        this.restoreSettings();
        Dialog.applyDialogFont((Control)this.getControl());
    }

    @Override
    public void dialogFieldChanged(DialogField field) {
        this.setErrorMessage(null);
        if (this.fAddrOrExprField == null || PDTCoreUtils.isEmpty((String)this.fAddrOrExprField.getText())) {
            this.setPageComplete(false);
        } else {
            this.setPageComplete(true);
        }
    }

    public PageData getPageData() {
        return new PageData(this.getStartAddress(), this.getNumBytes(), this.getUserLabel());
    }

    public String getStartAddress() {
        return this.fAddrOrExprField.getText();
    }

    private void initUsingOldBreakpoint() {
        if (this.fExistingBP.getExpression() != null && !this.fExistingBP.getExpression().equals("")) {
            this.fAddrOrExprField.setText(this.fExistingBP.getExpression());
        } else {
            this.fAddrOrExprField.setText(this.fExistingBP.getAddress());
        }
        this.fBytesToMonitorList.setText(Integer.toString(this.fExistingBP.getByteCount()));
        if (this.fExistingBP.getUserLabel() != null) {
            this.fUserLabelField.setText(this.fExistingBP.getUserLabel());
        }
    }

    private void restoreSettings() {
        IDialogSettings section = this.getDialogSettings(PAGE_NAME);
        if (this.fEditing) {
            this.initUsingOldBreakpoint();
            return;
        }
        String addressText = PICLUtils.getAddrOrExprFromActiveEditor();
        if (PDTCoreUtils.isEmpty((String)addressText)) {
            addressText = section.get(ADDRESS);
        }
        if (addressText != null) {
            this.fAddrOrExprField.setText(addressText);
        }
    }

    @Override
    public void writeSettings() {
        this.getDialogSettings(PAGE_NAME).put(ADDRESS, this.fAddrOrExprField.getText());
    }

    static class PageData {
        final String startAddress;
        final int numBytes;
        final String userLabel;

        private PageData(String startAddress, int numBytes, String userLabel) {
            this.startAddress = startAddress;
            this.numBytes = numBytes;
            this.userLabel = userLabel;
        }
    }
}

