/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.internal.ui.dialogs;

import com.ibm.debug.pdt.internal.core.PICLLabels;
import com.ibm.debug.pdt.internal.core.PICLMessages;
import com.ibm.debug.pdt.internal.ui.PICLUtils;
import java.text.Collator;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ListDialog;

public class PDTLaunchConfigListDialog
extends ListDialog {
    public PDTLaunchConfigListDialog(Shell parent, String programName) {
        super(parent);
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.setTitle(PICLLabels.LaunchConfig_configSelect);
        this.setMessage(NLS.bind((String)PICLMessages.LaunchConfig_configMultiple, (Object)programName));
        this.setContentProvider(new IStructuredContentProvider(){
            private final Comparator<Object> comparer = new Comparator<Object>(){
                private Collator collator = Collator.getInstance();

                @Override
                public int compare(Object arg0, Object arg1) {
                    String s1 = ((ILaunchConfiguration)arg0).getName();
                    String s2 = ((ILaunchConfiguration)arg1).getName();
                    return this.collator.compare(s1, s2);
                }
            };

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public Object[] getElements(Object inputElement) {
                Object[] elements = (Object[])inputElement;
                Object[] results = new Object[elements.length];
                System.arraycopy(elements, 0, results, 0, elements.length);
                Collections.sort(Arrays.asList(results), this.comparer);
                return results;
            }
        });
        this.setLabelProvider(new ILabelProvider(){

            public Image getImage(Object element) {
                return PICLUtils.getImage("PICL_ICON_DAEMON_TAB");
            }

            public String getText(Object element) {
                return ((ILaunchConfiguration)element).getName();
            }

            public void addListener(ILabelProviderListener listener) {
            }

            public void dispose() {
            }

            public boolean isLabelProperty(Object element, String property) {
                return false;
            }

            public void removeListener(ILabelProviderListener listener) {
            }
        });
    }

    protected Control createDialogArea(Composite container) {
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)container, PICLUtils.getHelpResourceString("remoted_compiled_application_select_launch"));
        return super.createDialogArea(container);
    }

    protected Control createContents(Composite parent) {
        ScrolledComposite scrolled = new ScrolledComposite(parent, 2816);
        scrolled.setShowFocusedControl(true);
        scrolled.setExpandHorizontal(true);
        scrolled.setExpandVertical(true);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)scrolled);
        Control contents = super.createContents((Composite)scrolled);
        scrolled.setContent(contents);
        scrolled.setMinSize(contents.computeSize(-1, -1));
        return scrolled;
    }
}

