/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.internal.ui.dialogs;

import com.ibm.debug.pdt.internal.common.CommonUtils;
import com.ibm.debug.pdt.internal.core.PDTDebugTarget;
import com.ibm.debug.pdt.internal.core.PICLLabels;
import com.ibm.debug.pdt.internal.core.PICLMessages;
import com.ibm.debug.pdt.internal.core.model.DebuggeeThread;
import com.ibm.debug.pdt.internal.core.model.EngineRequestException;
import com.ibm.debug.pdt.internal.core.model.IdentifierParser;
import com.ibm.debug.pdt.internal.core.model.Location;
import com.ibm.debug.pdt.internal.core.model.ViewFile;
import com.ibm.debug.pdt.internal.ui.EngineSuppliedViewEditorInput;
import com.ibm.debug.pdt.internal.ui.PICLDebugPlugin;
import com.ibm.debug.pdt.internal.ui.PICLUtils;
import com.ibm.debug.pdt.internal.ui.dialogs.DebugStatusDialog;
import com.ibm.lpex.alef.LpexAbstractTextEditor;
import com.ibm.lpex.core.LpexDocumentLocation;
import com.ibm.lpex.core.LpexView;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.texteditor.ITextEditor;

public class MonitorExpressionDialog
extends DebugStatusDialog {
    private static final String SETTINGSSECTION = PICLDebugPlugin.getPluginID() + ".monitorExpressionDialog";
    private DebuggeeThread fThread;
    private Location fLocation = null;
    private Combo expressionInput;
    private Label fileNameLabel;
    private Label lineNumberLabel;
    private Label viewInfoLabel;
    private Label threadNameLabel;
    private static final int MAX_HISTORY = 5;
    private static ArrayList<String> exprHistory = new ArrayList(5);

    public MonitorExpressionDialog(Shell parentShell, DebuggeeThread thread) {
        super(parentShell);
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.setTitle(PICLLabels.MonitorExpressionDialog_label_title);
        this.fThread = thread;
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parentShell, PICLUtils.getHelpResourceString("monitor_expression_dialog"));
    }

    protected Control createDialogArea(Composite ancestor) {
        Composite parent = new Composite(ancestor, 0);
        parent.setLayout((Layout)new GridLayout());
        parent.setLayoutData((Object)new GridData(4, 4, true, true));
        this.expressionInput = new Combo(parent, 2048);
        GridData spec = new GridData();
        spec.grabExcessVerticalSpace = false;
        spec.grabExcessHorizontalSpace = true;
        spec.horizontalAlignment = 4;
        spec.verticalAlignment = 1;
        this.expressionInput.setLayoutData((Object)spec);
        this.expressionInput.setTextLimit(1024);
        int i = 0;
        while (i < exprHistory.size()) {
            if (exprHistory.get(i) != null) {
                this.expressionInput.add(exprHistory.get(i));
            }
            ++i;
        }
        Group evaluationGroup = new Group(parent, 32);
        evaluationGroup.setLayout((Layout)new GridLayout());
        evaluationGroup.setLayoutData((Object)new GridData(272));
        evaluationGroup.setText(PICLLabels.MonitorExpressionDialog_label_context);
        this.fileNameLabel = new Label((Composite)evaluationGroup, 0);
        this.lineNumberLabel = new Label((Composite)evaluationGroup, 0);
        this.viewInfoLabel = new Label((Composite)evaluationGroup, 0);
        this.threadNameLabel = new Label((Composite)evaluationGroup, 0);
        this.initStatusInfo();
        this.expressionInput.setFocus();
        MonitorExpressionDialog.applyDialogFont((Control)parent);
        return parent;
    }

    private void initStatusInfo() {
        int evaluationContextLine;
        ViewFile evaluationContextFile;
        String expressionText;
        block18: {
            expressionText = null;
            evaluationContextFile = null;
            evaluationContextLine = 0;
            try {
                IEditorInput editorInput;
                LpexView lpexView;
                ITextSelection textSelection;
                ITextEditor editor;
                IWorkbenchPage p = CommonUtils.getActiveWorkbenchWindow().getActivePage();
                if (p == null || (editor = PICLDebugPlugin.getTextEditor((IWorkbenchPart)p.getActiveEditor())) == null || (textSelection = (ITextSelection)editor.getSelectionProvider().getSelection()) == null || textSelection.getText() == null) break block18;
                expressionText = textSelection.getText().trim();
                if (expressionText != null && !expressionText.equals("") && expressionText.indexOf(10) > 0) {
                    expressionText = expressionText.substring(0, expressionText.indexOf(10));
                }
                evaluationContextLine = textSelection.getStartLine() + 1;
                if (editor instanceof LpexAbstractTextEditor && (lpexView = ((LpexAbstractTextEditor)editor).getLpexView()) != null) {
                    evaluationContextLine = lpexView.lineOfElement(lpexView.currentElement());
                }
                if ((editorInput = editor.getEditorInput()) instanceof EngineSuppliedViewEditorInput) {
                    evaluationContextLine = PICLUtils.getRealLineNumber(editorInput, evaluationContextLine);
                    evaluationContextFile = ((EngineSuppliedViewEditorInput)editorInput).getViewFile();
                } else {
                    PDTDebugTarget viewDbgTgt = PICLDebugPlugin.getCurrentPDTDebugTarget();
                    if (viewDbgTgt != null && viewDbgTgt.isAcceptingRequests()) {
                        evaluationContextFile = PICLUtils.getViewFile(editorInput);
                    }
                }
                IdentifierParser parser = null;
                try {
                    if (evaluationContextFile != null) {
                        parser = evaluationContextFile.getPart().getLanguage().getIdentifierParser();
                    }
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
                if (parser != null) {
                    LpexView lpexView2;
                    IDocument doc = editor.getDocumentProvider().getDocument((Object)editorInput);
                    int line = doc.getLineOfOffset(textSelection.getOffset());
                    int lineOffset = doc.getLineOffset(line);
                    String lineText = doc.get(lineOffset, doc.getLineLength(line));
                    int position = textSelection.getOffset() - lineOffset;
                    if (editor instanceof LpexAbstractTextEditor && (lpexView2 = ((LpexAbstractTextEditor)editor).getLpexView()) != null) {
                        LpexDocumentLocation cursorLoc = lpexView2.documentLocation();
                        lineText = lpexView2.elementText(cursorLoc.element);
                        position = cursorLoc.position - 1;
                    }
                    if (editorInput instanceof EngineSuppliedViewEditorInput) {
                        int prefixLength = ((EngineSuppliedViewEditorInput)editorInput).getPrefixLength();
                        parser.setPrefixLength(prefixLength);
                        parser.setViewInfoID(((EngineSuppliedViewEditorInput)editorInput).getViewInformation().getKind());
                    } else {
                        parser.setViewInfoID((short)2);
                    }
                    expressionText = parser.doLanguageSpecifics(expressionText, lineText, position);
                }
            }
            catch (Exception e) {
                PICLUtils.logError(e);
            }
        }
        try {
            if (expressionText != null && !expressionText.equals("")) {
                this.expressionInput.setText(expressionText);
            }
            this.fLocation = evaluationContextFile == null ? this.fThread.getLocation() : new Location(evaluationContextFile, evaluationContextLine);
            if (this.fLocation != null) {
                this.fileNameLabel.setText(PICLLabels.MonitorExpressionDialog_label_filename + " " + this.fLocation.getViewFile().getFileName());
                this.lineNumberLabel.setText(PICLLabels.MonitorExpressionDialog_label_linenumber + " " + Integer.toString(this.fLocation.getLineNumber()));
                this.viewInfoLabel.setText(PICLLabels.MonitorExpressionDialog_label_viewtype + " " + this.fLocation.getViewFile().getView().getViewInformation().getName());
                this.threadNameLabel.setText(PICLLabels.MonitorExpressionDialog_label_threadname + " " + this.fThread.getName());
            }
        }
        catch (Exception e) {
            PICLUtils.logError(e);
        }
    }

    protected void okPressed() {
        final String expression = this.expressionInput.getText().trim();
        if (this.fThread == null || !this.fThread.isSuspended() || this.fLocation == null) {
            PICLDebugPlugin.showMessageDialog(this.getShell(), PICLMessages.MonitorExpressionDialog_error_invalid_thread, true);
            return;
        }
        CommonUtils.showView((String)"com.ibm.debug.pdt.ui.MonitorView");
        try {
            IWorkbenchWindow workBenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
            workBenchWindow.run(true, false, new IRunnableWithProgress(){

                public void run(IProgressMonitor pm) throws InvocationTargetException, InterruptedException {
                    pm.beginTask(PICLLabels.MonitorExpressionDialog_progress_label, -1);
                    try {
                        try {
                            MonitorExpressionDialog.this.fThread.monitorExpression(MonitorExpressionDialog.this.fLocation, expression);
                        }
                        catch (EngineRequestException ere) {
                            throw new InvocationTargetException(ere);
                        }
                    }
                    finally {
                        pm.done();
                    }
                }
            });
        }
        catch (Exception e) {
            if (e.getCause() instanceof EngineRequestException) {
                PICLDebugPlugin.showMessageDialog(this.getShell(), e.getCause().getMessage(), true);
            } else {
                PICLUtils.logError(e);
            }
            return;
        }
        MonitorExpressionDialog.addExpressionHistory(expression);
        super.okPressed();
    }

    public static void addExpressionHistory(String expression) {
        if (!exprHistory.contains(expression)) {
            if (exprHistory.size() == 5) {
                exprHistory.remove(4);
            }
            exprHistory.add(0, expression);
        } else {
            int idx = exprHistory.indexOf(expression);
            if (idx != -1) {
                exprHistory.remove(idx);
                exprHistory.add(0, expression);
            }
        }
    }

    protected IDialogSettings getDialogBoundsSettings() {
        IDialogSettings settings = PICLDebugPlugin.getInstance().getDialogSettings();
        IDialogSettings section = settings.getSection(SETTINGSSECTION);
        if (section == null) {
            section = settings.addNewSection(SETTINGSSECTION);
        }
        return section;
    }
}

