/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.internal.ui.dialogs;

import com.ibm.debug.pdt.internal.core.PDTDebugTarget;
import com.ibm.debug.pdt.internal.core.PICLLabels;
import com.ibm.debug.pdt.internal.core.model.DebuggeeProcess;
import com.ibm.debug.pdt.internal.core.model.MacroBreakpoint;
import com.ibm.debug.pdt.internal.core.model.Module;
import com.ibm.debug.pdt.internal.core.model.Part;
import com.ibm.debug.pdt.internal.ui.PICLUtils;
import com.ibm.debug.pdt.internal.ui.dialogs.BreakpointWizardPage;
import java.util.LinkedList;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class MacroBreakpointWizardPage
extends BreakpointWizardPage {
    private static final String DEFAULTSEARCH = "*";
    private static final String[] EMPTYSEARCH = new String[]{"*"};
    private MacroBreakpoint fExistingBP = null;
    protected Combo fExecutableCombo = null;
    protected Combo fObjectCombo = null;
    private Button fMacroButton;
    private Combo fMacroCombo;
    private Button fMacroGroupButton;
    private Combo fMacroGroupCombo;
    private Text fUserLabelField;
    private DebuggeeProcess fProcess;
    private static boolean savedMacroSelected = true;
    private static LinkedList<String> savedMacroField = new LinkedList();
    private static String savedMacroGroupField = null;

    protected MacroBreakpointWizardPage(String pageName, String title, ImageDescriptor titleImage, PDTDebugTarget tgt, MacroBreakpoint existingBP) {
        super(pageName, title, titleImage, tgt, existingBP != null);
        this.fExistingBP = existingBP;
        this.setDescription(PICLLabels.MacroBPWizard_page1_description);
        this.fProcess = (DebuggeeProcess)tgt.getProcess();
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        this.setControl((Control)composite);
        composite.setLayout((Layout)new GridLayout());
        new Label(composite, 16384).setText(PICLLabels.EntryBPWizard_page1_executableOptional);
        this.fExecutableCombo = new Combo(composite, 4);
        this.fExecutableCombo.setLayoutData((Object)new GridData(4, 1, true, false));
        this.fExecutableCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                MacroBreakpointWizardPage.this.fObjectCombo.setItems(MacroBreakpointWizardPage.this.getParts(MacroBreakpointWizardPage.this.fExecutableCombo.getText()));
                MacroBreakpointWizardPage.this.fObjectCombo.setText(MacroBreakpointWizardPage.this.fObjectCombo.getItem(0));
                MacroBreakpointWizardPage.this.checkIfComplete();
            }
        });
        new Label(composite, 16384).setText(PICLLabels.EntryBPWizard_page1_objectOptional);
        this.fObjectCombo = new Combo(composite, 4);
        this.fObjectCombo.setLayoutData((Object)new GridData(4, 1, true, false));
        this.fObjectCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                MacroBreakpointWizardPage.this.checkIfComplete();
            }
        });
        Group macroGroup = new Group(composite, 0);
        macroGroup.setLayoutData((Object)new GridData(4, 4, true, false));
        macroGroup.setText(PICLLabels.MacroBPWizard_GroupName);
        macroGroup.setLayout((Layout)new GridLayout(2, false));
        this.fMacroButton = new Button((Composite)macroGroup, 16);
        this.fMacroButton.setLayoutData((Object)new GridData(1, 1, false, false));
        this.fMacroButton.setText(PICLLabels.MacroBPWizard_MacroRadioButton);
        this.fMacroButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                MacroBreakpointWizardPage.this.fMacroCombo.setEnabled(true);
                MacroBreakpointWizardPage.this.fMacroGroupCombo.setEnabled(false);
                MacroBreakpointWizardPage.this.checkIfComplete();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.fMacroCombo = new Combo((Composite)macroGroup, 4);
        GridData gd = new GridData(4, 1, true, false);
        this.fMacroCombo.setLayoutData((Object)gd);
        this.fMacroCombo.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                MacroBreakpointWizardPage.this.checkIfComplete();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.fMacroCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                MacroBreakpointWizardPage.this.checkIfComplete();
            }
        });
        this.fMacroGroupButton = new Button((Composite)macroGroup, 16);
        this.fMacroGroupButton.setLayoutData((Object)new GridData(1, 1, false, false));
        this.fMacroGroupButton.setText(PICLLabels.MacroBPWizard_MacroGroupRadioButton);
        this.fMacroGroupButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                MacroBreakpointWizardPage.this.fMacroCombo.setEnabled(false);
                MacroBreakpointWizardPage.this.fMacroGroupCombo.setEnabled(true);
                MacroBreakpointWizardPage.this.checkIfComplete();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.fMacroGroupCombo = new Combo((Composite)macroGroup, 4);
        gd = new GridData(4, 1, true, false);
        this.fMacroGroupCombo.setLayoutData((Object)gd);
        this.fMacroGroupCombo.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                MacroBreakpointWizardPage.this.checkIfComplete();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.fMacroGroupCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                MacroBreakpointWizardPage.this.checkIfComplete();
            }
        });
        new Label(composite, 16384).setText(PICLLabels.EntryBPWizard_page1_userLabel);
        this.fUserLabelField = new Text(composite, 2052);
        this.fUserLabelField.setLayoutData((Object)new GridData(4, 1, true, false));
        this.initializePage();
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, PICLUtils.getHelpResourceString("entry_bp_wizard"));
        Dialog.applyDialogFont((Control)composite);
    }

    private String[] getModules() {
        Module[] modules = this.fProcess.getModules(true);
        String[] moduleNames = new String[modules.length + 1];
        moduleNames[0] = DEFAULTSEARCH;
        int i = 0;
        while (i < modules.length) {
            moduleNames[i + 1] = modules[i].getName();
            ++i;
        }
        return moduleNames;
    }

    private String[] getParts(String selectedModule) {
        Module[] modules = this.fProcess.getModules(true);
        Module module = null;
        Module[] moduleArray = modules;
        int n = modules.length;
        int n2 = 0;
        while (n2 < n) {
            Module element = moduleArray[n2];
            if (element.getName().equalsIgnoreCase(selectedModule)) {
                module = element;
                break;
            }
            ++n2;
        }
        if (module == null) {
            return EMPTYSEARCH;
        }
        Part[] parts = module.getParts();
        String[] partNames = new String[parts.length + 1];
        partNames[0] = DEFAULTSEARCH;
        int i = 0;
        while (i < parts.length) {
            partNames[i + 1] = parts[i].getName();
            ++i;
        }
        return partNames;
    }

    private void initializePage() {
        this.setPageComplete(false);
        this.fMacroGroupCombo.setItems(this.fDebugTarget.getEngineSession().getMacroGroups());
        this.fExecutableCombo.setItems(this.getModules());
        if (this.fExistingBP == null) {
            this.fExecutableCombo.setText(DEFAULTSEARCH);
            this.fMacroCombo.setItems(savedMacroField.toArray(new String[savedMacroField.size()]));
            if (this.fMacroCombo.getItemCount() > 0) {
                this.fMacroCombo.setText(this.fMacroCombo.getItem(0));
            }
            if (savedMacroGroupField != null) {
                this.fMacroGroupCombo.setText(savedMacroGroupField);
            }
            if (savedMacroSelected) {
                this.fMacroButton.setSelection(true);
                this.fMacroCombo.setEnabled(true);
                this.fMacroGroupCombo.setEnabled(false);
            } else {
                this.fMacroGroupButton.setSelection(true);
                this.fMacroCombo.setEnabled(false);
                this.fMacroGroupCombo.setEnabled(true);
            }
        } else {
            this.fExecutableCombo.setText(this.fExistingBP.getModuleName());
            this.fObjectCombo.setText(this.fExistingBP.getPartName());
            String macro = this.fExistingBP.getFunctionName();
            boolean macroGroup = this.isMacroGroup(macro);
            macro = this.getRootMacroName(macro);
            this.fMacroCombo.setItems(savedMacroField.toArray(new String[savedMacroField.size()]));
            if (macroGroup) {
                this.fMacroGroupCombo.setText(macro);
                this.fMacroGroupButton.setSelection(true);
                this.fMacroCombo.setEnabled(false);
                this.fMacroGroupCombo.setEnabled(true);
            } else {
                this.fMacroCombo.setText(macro);
                this.fMacroButton.setSelection(true);
                this.fMacroCombo.setEnabled(true);
                this.fMacroGroupCombo.setEnabled(false);
            }
            String userLabel = this.fExistingBP.getUserLabel();
            if (userLabel != null) {
                this.fUserLabelField.setText(userLabel);
            }
        }
        this.checkIfComplete();
    }

    private boolean isMacroGroup(String macro) {
        return macro.indexOf("[macro group]") >= 0;
    }

    private String getRootMacroName(String macro) {
        int posn = macro.indexOf(91);
        if (posn != -1) {
            return macro.substring(0, posn).trim();
        }
        return macro;
    }

    public String getExecutableName() {
        return this.fExecutableCombo.getText();
    }

    public String getObjectName() {
        return this.fObjectCombo.getText();
    }

    private void checkIfComplete() {
        this.setErrorMessage(null);
        if (this.fMacroButton.getSelection()) {
            this.setPageComplete(this.fMacroCombo.getText().length() > 0);
        } else {
            this.setPageComplete(this.fMacroGroupCombo.getText().length() > 0);
        }
    }

    public String getMacroName() {
        if (this.fMacroButton.getSelection()) {
            return this.fMacroCombo.getText();
        }
        return this.fMacroGroupCombo.getText();
    }

    protected void saveFields() {
        String macroField = this.fMacroCombo.getText();
        if (macroField.length() != 0) {
            savedMacroField.remove(macroField);
            savedMacroField.addFirst(macroField);
        }
        if ((savedMacroGroupField = this.fMacroGroupCombo.getText()).length() == 0) {
            savedMacroGroupField = null;
        }
        savedMacroSelected = this.fMacroButton.getSelection();
    }

    public String getUserLabel() {
        return this.fUserLabelField.getText();
    }
}

