/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.internal.ui.dialogs;

import com.ibm.debug.pdt.internal.core.OptionalBreakpointData;
import com.ibm.debug.pdt.internal.core.PDTDebugTarget;
import com.ibm.debug.pdt.internal.core.PICLLabels;
import com.ibm.debug.pdt.internal.core.PICLMessages;
import com.ibm.debug.pdt.internal.core.model.Breakpoint;
import com.ibm.debug.pdt.internal.core.model.EngineRequestErrorException;
import com.ibm.debug.pdt.internal.core.model.EngineRequestException;
import com.ibm.debug.pdt.internal.core.model.MacroBreakpoint;
import com.ibm.debug.pdt.internal.ui.PICLDebugPlugin;
import com.ibm.debug.pdt.internal.ui.PICLUtils;
import com.ibm.debug.pdt.internal.ui.dialogs.BreakpointWizard;
import com.ibm.debug.pdt.internal.ui.dialogs.ConditionalBreakpointWizardPage;
import com.ibm.debug.pdt.internal.ui.dialogs.MacroBreakpointWizardPage;
import com.ibm.debug.pdt.internal.ui.util.StatusInfo;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.ui.progress.WorkbenchJob;

public class MacroBreakpointWizard
extends BreakpointWizard {
    protected static final String DIALOG = "MacroBPWizard.dialog";
    protected static final String PAGE_1 = "MacroBPWizard.page1";
    protected static final String PAGE_2 = "BreakpointWizard.optional";
    private MacroBreakpoint fExistingBP;

    public MacroBreakpointWizard(PDTDebugTarget debugTarget) {
        super(debugTarget);
        this.fEditing = false;
        this.fExistingBP = null;
        this.initializeWizard();
    }

    public MacroBreakpointWizard(PDTDebugTarget debugTarget, MacroBreakpoint breakpoint) {
        super(debugTarget);
        this.fEditing = true;
        this.fExistingBP = breakpoint;
        this.initializeWizard();
    }

    private void initializeWizard() {
        if (!this.fEditing) {
            this.setWindowTitle(PICLLabels.MacroBPWizard_create_dialog_title);
        } else {
            this.setWindowTitle(PICLLabels.MacroBPWizard_edit_dialog_title);
        }
        this.setDefaultPageImageDescriptor(PICLUtils.getImageDescriptor("PICL_ICON_BREAKPOINT_WIZARD"));
        this.setNeedsProgressMonitor(false);
        IDialogSettings dialogSettings = PICLDebugPlugin.getInstance().getDialogSettings();
        IDialogSettings section = dialogSettings.getSection(DIALOG);
        if (section == null) {
            section = dialogSettings.addNewSection(DIALOG);
        }
        this.setDialogSettings(section);
    }

    public void addPages() {
        this.fMainPageName = PICLLabels.EntryBPWizard_page1_pageName;
        this.addPage((IWizardPage)new MacroBreakpointWizardPage(this.fMainPageName, PICLLabels.EntryBPWizard_page1_title, null, this.fDebugTarget, this.fExistingBP));
        if (this.areOptionalParametersSupported()) {
            this.addPage((IWizardPage)new ConditionalBreakpointWizardPage(this.fCondPageName, PICLLabels.BreakpointWizard_optional_title, null, this.fDebugTarget, (Breakpoint)this.fExistingBP));
        }
    }

    @Override
    public boolean performFinish() {
        if (this.checkFinishButtonClicked()) {
            return false;
        }
        final MacroBreakpointWizardPage page = (MacroBreakpointWizardPage)this.getPage(this.fMainPageName);
        page.saveFields();
        final ConditionalBreakpointWizardPage condPage = this.areOptionalParametersSupported() ? (ConditionalBreakpointWizardPage)this.getPage(this.fCondPageName) : new ConditionalBreakpointWizardPage("", "", null, this.fDebugTarget, (Breakpoint)this.fExistingBP);
        final String exe = page.getExecutableName();
        final String obj = page.getObjectName();
        final String macro = page.getMacroName();
        final OptionalBreakpointData optData = condPage.getPageData();
        optData.setUserLabel(page.getUserLabel());
        Job job = new Job(PICLLabels.BreakpointWizard_jobname_CreateModify){

            protected IStatus run(IProgressMonitor monitor) {
                StatusInfo created;
                final StatusInfo processResult = created = MacroBreakpointWizard.this.processMacroBreakpoint(exe, obj, macro, optData);
                if (!page.getControl().isDisposed()) {
                    MacroBreakpointWizard.this.wbJob = new WorkbenchJob(PICLLabels.BreakpointWizard_jobname_Update){

                        public IStatus runInUIThread(IProgressMonitor wbMonitor) {
                            MacroBreakpointWizard.this.updateWizardPostProcessing(processResult, page, condPage);
                            return Status.OK_STATUS;
                        }
                    };
                    MacroBreakpointWizard.this.wbJob.setSystem(true);
                    MacroBreakpointWizard.this.wbJob.schedule();
                }
                return Status.OK_STATUS;
            }
        };
        job.setSystem(true);
        job.schedule();
        return false;
    }

    private StatusInfo processMacroBreakpoint(String moduleName, String partName, String macroName, OptionalBreakpointData optData) {
        StatusInfo status = new StatusInfo();
        if (macroName == null || macroName.equals("")) {
            status.setError(PICLMessages.EntryBPWizard_page1_entryError);
            return status;
        }
        if (this.fDebugTarget == null) {
            status.setError(PICLMessages.BreakpointWizard_targetError);
            return status;
        }
        try {
            if (this.fEditing) {
                this.fExistingBP.modifyDeferred(macroName, moduleName, partName, optData, null);
            } else {
                this.fDebugTarget.createDeferredMacroBreakpoint(moduleName, partName, macroName, optData, null);
            }
        }
        catch (EngineRequestErrorException ere) {
            status.setError(ere.getMessage());
            Breakpoint bkpt = (Breakpoint)ere.getReply().retrieveObject(4);
            if (bkpt != null) {
                try {
                    bkpt.remove();
                }
                catch (Exception exception) {}
            }
        }
        catch (EngineRequestException engineRequestException) {
            // empty catch block
        }
        return status;
    }
}

