/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.internal.ui.dialogs;

import com.ibm.debug.pdt.core.PDTDebugUtils;
import com.ibm.debug.pdt.internal.core.PDTDebugTarget;
import com.ibm.debug.pdt.internal.core.PICLLabels;
import com.ibm.debug.pdt.internal.core.model.ModuleLoadBreakpoint;
import com.ibm.debug.pdt.internal.ui.PICLUtils;
import com.ibm.debug.pdt.internal.ui.dialogs.BreakpointWizardPage;
import com.ibm.debug.pdt.internal.ui.dialogs.ISettingsWriter;
import com.ibm.debug.pdt.internal.ui.util.DialogField;
import com.ibm.debug.pdt.internal.ui.util.IDialogFieldListener;
import com.ibm.debug.pdt.internal.ui.util.StringDialogField;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;

public class LoadBPWizardPage
extends BreakpointWizardPage
implements IDialogFieldListener,
ISettingsWriter {
    private ModuleLoadBreakpoint fExistingBP = null;
    private StringDialogField dllField;
    private StringDialogField fUserLabelField;
    private Button fRunToEntryButton;
    private static final String PAGE_NAME = "LoadBPWizard.page1";
    private static IDialogSettings section;
    private static final String DLLNAME = "DLLName";

    protected LoadBPWizardPage(String pageName, String title, ImageDescriptor titleImage, ModuleLoadBreakpoint editBreakpoint) {
        super(pageName, title, titleImage, null, editBreakpoint != null);
        this.fExistingBP = editBreakpoint;
        this.setDescription(PICLLabels.LoadBPWizard_page1_description);
    }

    protected LoadBPWizardPage(String pageName, String title, ImageDescriptor titleImage, PDTDebugTarget tgt, ModuleLoadBreakpoint editBreakpoint) {
        super(pageName, title, titleImage, tgt, editBreakpoint != null);
        this.fExistingBP = editBreakpoint;
        this.setDescription(PICLLabels.LoadBPWizard_page1_description);
    }

    public String getDLLName() {
        return this.dllField.getText();
    }

    public void createControl(Composite parent) {
        int nColumns = 3;
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = nColumns;
        composite.setLayout((Layout)layout);
        this.setControl((Control)composite);
        Dialog.applyDialogFont((Control)composite);
        this.dllField = new StringDialogField();
        this.dllField.setLabelText(this.getLibraryLabel());
        this.dllField.setDialogFieldListener(this);
        this.dllField.doFillIntoGrid(composite, nColumns);
        this.fUserLabelField = new StringDialogField();
        this.fUserLabelField.setLabelText(PICLLabels.LoadBPWizard_page1_userLabel);
        this.fUserLabelField.doFillIntoGrid(composite, nColumns);
        if (this.fDebugTarget != null && this.fDebugTarget.getDebugEngine() != null && this.fDebugTarget.getDebugEngine().getEngineSession().supportsRunToEntry()) {
            GridDataFactory.swtDefaults().grab(true, false).span(nColumns, 1).applyTo((Control)new Label(composite, 0));
            this.fRunToEntryButton = new Button(composite, 32);
            this.fRunToEntryButton.setText(PICLLabels.LoadBPWizard_page1_RunToEntry);
            this.fRunToEntryButton.setSelection(true);
            GridDataFactory.swtDefaults().grab(true, false).span(nColumns, 1).applyTo((Control)this.fRunToEntryButton);
        }
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, PICLUtils.getHelpResourceString("load_bp_wizard"));
        this.restoreSettings();
    }

    @Override
    public void dialogFieldChanged(DialogField field) {
        this.setErrorMessage(null);
        if (this.dllField.getText().equals("")) {
            this.setPageComplete(false);
        } else {
            this.setPageComplete(true);
        }
    }

    private void initUsingOldBreakpoint() {
        this.dllField.setText(this.fExistingBP.getModuleName());
        if (this.fExistingBP.getUserLabel() != null) {
            this.fUserLabelField.setText(this.fExistingBP.getUserLabel());
        }
    }

    private void restoreSettings() {
        IDialogSettings dialogSettings;
        if (section == null && (section = (dialogSettings = this.getDialogSettings()).getSection(PAGE_NAME)) == null) {
            section = dialogSettings.addNewSection(PAGE_NAME);
        }
        if (this.fEditing) {
            this.initUsingOldBreakpoint();
            return;
        }
        String text = section.get(DLLNAME);
        if (text != null) {
            this.dllField.setText(text);
        }
    }

    @Override
    public void writeSettings() {
        section.put(DLLNAME, this.dllField.getText());
    }

    private String getLibraryLabel() {
        if (PDTDebugUtils.isDebugToolEngine((IDebugTarget)this.fDebugTarget) || PDTDebugUtils.iszPICLEngine((IDebugTarget)this.fDebugTarget)) {
            return PICLLabels.LoadBPWizard_page1_dllLabel_debugTool;
        }
        return PICLLabels.LoadBPWizard_page1_dllLabel;
    }

    public String getUserLabel() {
        return this.fUserLabelField.getText();
    }

    public boolean getRunToEntry() {
        return this.fRunToEntryButton != null && this.fRunToEntryButton.getSelection();
    }
}

