/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.internal.ui.dialogs;

import com.ibm.debug.pdt.internal.core.PICLLabels;
import com.ibm.debug.pdt.internal.ui.PICLDebugPlugin;
import com.ibm.debug.pdt.internal.ui.PICLDebugTarget;
import com.ibm.debug.pdt.internal.ui.PICLUtils;
import com.ibm.debug.pdt.internal.ui.dialogs.DebugTrayDialog;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class ForkDialog
extends DebugTrayDialog {
    private Button childButton;
    private Button parentButton;
    private Button bothButton;
    private Button rememberChoiceButton;
    private int result = -1;
    private PICLDebugTarget debugTarget;
    public static final int FORK_PREF_NOT_SET = -1;
    public static final int FOLLOW_PARENT = 0;
    public static final int FOLLOW_CHILD = 1;
    public static final int FOLLOW_BOTH = 2;
    public static final int ALWAYS_FOLLOW_PARENT = 3;
    public static final int ALWAYS_FOLLOW_CHILD = 4;
    public static final int ALWAYS_FOLLOW_BOTH = 5;

    public ForkDialog(Shell shell, PICLDebugTarget target) {
        super(shell);
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.debugTarget = target;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(PICLLabels.ForkDialog_title);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)shell, PICLUtils.getHelpResourceString("fork_dialog"));
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = this.convertVerticalDLUsToPixels(7);
        layout.marginWidth = this.convertHorizontalDLUsToPixels(7);
        layout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
        layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(1808));
        composite.setFont(parent.getFont());
        Label l = new Label(composite, 0);
        l.setText(PICLLabels.ForkDialog_message);
        l = new Label(composite, 0);
        l.setText(PICLLabels.ForkDialog_instruction);
        this.parentButton = new Button(composite, 16);
        this.parentButton.setText(PICLLabels.ForkDialog_parentRadioButton);
        this.childButton = new Button(composite, 16);
        this.childButton.setText(PICLLabels.ForkDialog_childRadioButton);
        if (this.debugTarget.supportsForkFollowBoth()) {
            this.bothButton = new Button(composite, 16);
            this.bothButton.setText(PICLLabels.ForkDialog_bothRadioButton);
        }
        int result = PICLDebugPlugin.getPrefRememberFork();
        switch (result) {
            case 1: {
                this.childButton.setSelection(true);
                break;
            }
            case 2: {
                if (this.bothButton == null) break;
                this.bothButton.setSelection(true);
                break;
            }
            default: {
                this.parentButton.setSelection(true);
            }
        }
        if (this.debugTarget.supportsRememberForkChoice()) {
            this.rememberChoiceButton = new Button(composite, 32);
            this.rememberChoiceButton.setText(PICLLabels.ForkDialog_rememberChoiceButton);
        }
        return composite;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
    }

    protected void okPressed() {
        if (this.rememberChoiceButton != null && this.rememberChoiceButton.getSelection()) {
            if (this.parentButton.getSelection()) {
                this.result = 3;
            } else if (this.childButton.getSelection()) {
                this.result = 4;
            } else if (this.bothButton.getSelection()) {
                this.result = 5;
            }
        } else if (this.parentButton.getSelection()) {
            this.result = 0;
        } else if (this.childButton.getSelection()) {
            this.result = 1;
        } else if (this.bothButton.getSelection()) {
            this.result = 2;
        }
        this.debugTarget.setForkDialogAnswer(this.result);
        super.okPressed();
    }

    protected void handleShellCloseEvent() {
    }

    public int getResult() {
        return this.result;
    }

    @Override
    protected Control createContents(Composite parent) {
        Control composite = super.createContents(parent);
        Dialog.applyDialogFont((Control)composite);
        return composite;
    }
}

