/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.internal.ui.dialogs;

import com.ibm.debug.pdt.core.PDTDebugUtils;
import com.ibm.debug.pdt.internal.core.PDTDebugElement;
import com.ibm.debug.pdt.internal.core.PICLLabels;
import com.ibm.debug.pdt.internal.core.PICLMessages;
import com.ibm.debug.pdt.internal.core.PICLModule;
import com.ibm.debug.pdt.internal.core.PICLModuleParent;
import com.ibm.debug.pdt.internal.core.model.Function;
import com.ibm.debug.pdt.internal.core.model.Location;
import com.ibm.debug.pdt.internal.core.model.Part;
import com.ibm.debug.pdt.internal.core.model.ViewFile;
import com.ibm.debug.pdt.internal.ui.EngineSuppliedViewEditorInput;
import com.ibm.debug.pdt.internal.ui.PDTModelPresentation;
import com.ibm.debug.pdt.internal.ui.PICLDebugPlugin;
import com.ibm.debug.pdt.internal.ui.PICLDebugTarget;
import com.ibm.debug.pdt.internal.ui.PICLUtils;
import com.ibm.debug.pdt.internal.ui.dialogs.DebugStatusDialog;
import com.ibm.debug.pdt.internal.ui.editor.DebuggerEditor;
import com.ibm.debug.pdt.internal.ui.sourcelocator.PDTSourceNotFoundEditorInput;
import java.util.ArrayList;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class FindFunctionDialog
extends DebugStatusDialog {
    private static final String SETTINGSSECTION = PICLDebugPlugin.getPluginID() + ".findFunctionDialog";
    private Combo expressionInput;
    private Button caseSensitiveButton;
    private Button debugInfoButton;
    private DebuggerEditor fEditor;
    private static final int MAX_HISTORY = 5;
    private static ArrayList<String> exprHistory = new ArrayList(5);

    public FindFunctionDialog(DebuggerEditor editor) {
        super(editor.getEditorSite().getShell());
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.fEditor = editor;
        if (this.isiSeries(this.fEditor.getEditorInput())) {
            this.setTitle(PICLLabels.FindFunctionDialog_title4);
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.getParentShell(), PICLUtils.getHelpResourceString("find_procedure_dialog"));
        } else {
            this.setTitle(PICLLabels.FindFunctionDialog_title1);
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.getParentShell(), PICLUtils.getHelpResourceString("find_function_dialog"));
        }
    }

    protected Control createDialogArea(Composite ancestor) {
        Composite parent = new Composite(ancestor, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        GridData spec = new GridData();
        spec.grabExcessVerticalSpace = true;
        spec.grabExcessHorizontalSpace = true;
        spec.horizontalAlignment = 4;
        spec.verticalAlignment = 4;
        spec.widthHint = 350;
        parent.setLayout((Layout)layout);
        parent.setLayoutData((Object)spec);
        Label expressionInputLabel = new Label(parent, 0);
        this.expressionInput = new Combo(parent, 2048);
        spec = new GridData(768);
        spec.horizontalSpan = 2;
        this.expressionInput.setLayoutData((Object)spec);
        this.caseSensitiveButton = new Button(parent, 32);
        this.caseSensitiveButton.setText(PICLLabels.FindTextDialog_case);
        spec = new GridData(768);
        spec.horizontalSpan = 2;
        this.caseSensitiveButton.setLayoutData((Object)spec);
        this.debugInfoButton = new Button(parent, 32);
        this.debugInfoButton.setText(PICLLabels.FindFunctionDialog_debuginfo);
        this.debugInfoButton.setSelection(true);
        spec = new GridData(768);
        spec.horizontalSpan = 2;
        this.debugInfoButton.setLayoutData((Object)spec);
        int i = 0;
        while (i < exprHistory.size()) {
            if (exprHistory.get(i) != null) {
                this.expressionInput.add(exprHistory.get(i));
            }
            ++i;
        }
        String editorText = null;
        ITextSelection textSelection = (ITextSelection)this.fEditor.getSelectionProvider().getSelection();
        if (textSelection != null && textSelection.getText() != null && (editorText = textSelection.getText().trim()) != null && !editorText.equals("") && editorText.indexOf(10) > 0) {
            editorText = editorText.substring(0, editorText.indexOf(10));
        }
        if (editorText != null) {
            this.expressionInput.setText(editorText);
        }
        this.expressionInput.setFocus();
        if (this.isiSeries(this.fEditor.getEditorInput())) {
            expressionInputLabel.setText(PICLLabels.FindFunctionDialog_text4);
        } else {
            expressionInputLabel.setText(PICLLabels.FindFunctionDialog_text1);
        }
        FindFunctionDialog.applyDialogFont((Control)parent);
        return parent;
    }

    public Location getFunctionLocation(String functionName, ViewFile viewFile, boolean caseSensitive) {
        Location functionLocation = null;
        Function[] functions = null;
        try {
            functions = viewFile.getFunctions();
            int i = 0;
            while (i < functions.length) {
                if (functions[i] != null) {
                    Function function = functions[i];
                    if (this.caseSensitiveButton != null && this.caseSensitiveButton.getSelection()) {
                        if (functionName.equals(function.getName())) {
                            functionLocation = function.getLocation();
                        }
                    } else if (functionName.equalsIgnoreCase(function.getName())) {
                        functionLocation = function.getLocation();
                    }
                }
                ++i;
            }
        }
        catch (Exception e) {
            PICLUtils.logError(e);
            return null;
        }
        return functionLocation;
    }

    public Function searchAllModulesForFunction(String functionName, boolean caseSensitive, boolean debugInfoOnly) {
        IEditorInput input = this.fEditor.getEditorInput();
        if (!(input instanceof EngineSuppliedViewEditorInput)) {
            if (PICLDebugPlugin.fPDT) {
                PICLUtils.logString((Object)this, "DebuggerEditor: trying to use debug Find Text dialog on a non-EngineSuppliedView");
            }
            return null;
        }
        try {
            PDTDebugElement[] modules;
            PICLDebugTarget dbgtgt = ((EngineSuppliedViewEditorInput)input).getPICLDebugTarget();
            PICLModuleParent moduleParent = dbgtgt.getModuleParent();
            PDTDebugElement[] pDTDebugElementArray = modules = moduleParent.getChildren();
            int n = modules.length;
            int n2 = 0;
            while (n2 < n) {
                PDTDebugElement module = pDTDebugElementArray[n2];
                if (module instanceof PICLModule) {
                    PDTDebugElement[] parts;
                    PDTDebugElement[] pDTDebugElementArray2 = parts = module.getChildren();
                    int n3 = parts.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        PDTDebugElement part = pDTDebugElementArray2[n4];
                        if (part instanceof Part) {
                            Part aPart = (Part)part;
                            if (!debugInfoOnly || aPart.isDebuggable()) {
                                Function[] functions;
                                Function[] functionArray = functions = aPart.getFunctions();
                                int n5 = functions.length;
                                int n6 = 0;
                                while (n6 < n5) {
                                    Function function = functionArray[n6];
                                    if (caseSensitive ? functionName.equals(function.getName()) : functionName.equalsIgnoreCase(function.getName())) {
                                        return function;
                                    }
                                    ++n6;
                                }
                            }
                        }
                        ++n4;
                    }
                }
                ++n2;
            }
        }
        catch (Exception e) {
            PICLUtils.logError(e);
        }
        return null;
    }

    private void openSourceNotFoundEditor(PDTSourceNotFoundEditorInput SNFInput, String editorID) {
        IWorkbenchWindow dwindow = this.fEditor.getEditorSite().getWorkbenchWindow();
        if (dwindow == null) {
            return;
        }
        IWorkbenchPage page = dwindow.getActivePage();
        if (page == null) {
            return;
        }
        try {
            page.openEditor((IEditorInput)SNFInput, editorID);
        }
        catch (Exception e) {
            PICLUtils.logError(e);
        }
    }

    protected void okPressed() {
        Function function;
        String expression = this.expressionInput.getText();
        FindFunctionDialog.addExpressionHistory(expression);
        IEditorInput input = this.fEditor.getEditorInput();
        if (!(input instanceof EngineSuppliedViewEditorInput)) {
            if (PICLDebugPlugin.fPDT) {
                PICLUtils.logString((Object)this, "DebuggerEditor: trying to use debug Find Text dialog on a non-EngineSuppliedView");
            }
            return;
        }
        Location functionLocation = null;
        ViewFile viewFile = ((EngineSuppliedViewEditorInput)input).getViewFile();
        functionLocation = this.getFunctionLocation(expression, viewFile, this.caseSensitiveButton.getSelection());
        if (functionLocation == null && (function = this.searchAllModulesForFunction(expression, this.caseSensitiveButton.getSelection(), this.debugInfoButton.getSelection())) != null) {
            try {
                PDTModelPresentation modelPresentation = new PDTModelPresentation();
                IEditorInput newEditorInput = modelPresentation.getEditorInput(function);
                if (newEditorInput instanceof PDTSourceNotFoundEditorInput) {
                    this.openSourceNotFoundEditor((PDTSourceNotFoundEditorInput)newEditorInput, modelPresentation.getEditorId(newEditorInput, null));
                    super.okPressed();
                    return;
                }
                this.fEditor.setInput(newEditorInput);
                functionLocation = function.getLocation();
            }
            catch (Exception e) {
                PICLUtils.logError(e);
            }
        }
        if (functionLocation == null) {
            if (this.isiSeries(input)) {
                this.updateStatus((IStatus)new Status(1, PICLDebugPlugin.getPluginID(), 0, PICLMessages.FindFunctionDialog_error4, null));
            } else {
                this.updateStatus((IStatus)new Status(1, PICLDebugPlugin.getPluginID(), 0, PICLMessages.FindFunctionDialog_error1, null));
            }
        } else {
            this.fEditor.gotoLine(functionLocation.getLineNumber(), false);
            super.okPressed();
        }
    }

    public static void addExpressionHistory(String expression) {
        if (!exprHistory.contains(expression)) {
            if (exprHistory.size() == 5) {
                exprHistory.remove(4);
            }
            exprHistory.add(0, expression);
        } else {
            int idx = exprHistory.indexOf(expression);
            if (idx != -1) {
                exprHistory.remove(idx);
                exprHistory.add(0, expression);
            }
        }
    }

    private boolean isiSeries(IEditorInput ei) {
        PICLDebugTarget dbgtgt;
        return ei instanceof EngineSuppliedViewEditorInput && PDTDebugUtils.isiSeriesEngine((IDebugTarget)(dbgtgt = ((EngineSuppliedViewEditorInput)ei).getPICLDebugTarget()));
    }

    protected IDialogSettings getDialogBoundsSettings() {
        IDialogSettings settings = PICLDebugPlugin.getInstance().getDialogSettings();
        IDialogSettings section = settings.getSection(SETTINGSSECTION);
        if (section == null) {
            section = settings.addNewSection(SETTINGSSECTION);
        }
        return section;
    }
}

