/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.internal.ui.dialogs;

import com.ibm.debug.pdt.internal.core.PDTDebugTarget;
import com.ibm.debug.pdt.internal.core.PICLLabels;
import com.ibm.debug.pdt.internal.core.model.DebuggeeProcess;
import com.ibm.debug.pdt.internal.core.model.Part;
import com.ibm.debug.pdt.internal.core.model.View;
import com.ibm.debug.pdt.internal.core.model.ViewFile;
import com.ibm.debug.pdt.internal.core.model.ViewInformation;
import com.ibm.debug.pdt.internal.core.util.FileListItem;
import com.ibm.debug.pdt.internal.epdc.EPDC_EngineSession;
import com.ibm.debug.pdt.internal.ui.PDTModelPresentation;
import com.ibm.debug.pdt.internal.ui.PICLDebugPlugin;
import com.ibm.debug.pdt.internal.ui.PICLUtils;
import com.ibm.debug.pdt.internal.ui.dialogs.DebugTrayDialog;
import com.ibm.debug.pdt.internal.ui.util.FileFilterList;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.ProgressMonitorPart;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.IProgressService;
import org.eclipse.ui.progress.UIJob;

public class FileFilterDialog
extends DebugTrayDialog {
    protected FileFilterList fFileFilterControl;
    private static final String SETTINGSSECTION = PICLDebugPlugin.getPluginID() + ".fileFilterDialog";
    private Button fCaseButton;
    protected Label fMatches;
    private Button fFilterBaseButton;
    private Button fFilterFullButton;
    private ProgressMonitorPart fProgressPart;
    private final PDTDebugTarget fTarget;
    private boolean fFilterOnBaseName = true;
    private final IWorkbenchPage fWorkbenchPage;

    public FileFilterDialog(Shell parentShell, PDTDebugTarget target, IWorkbenchPage page) {
        super(parentShell);
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.fTarget = target;
        this.fWorkbenchPage = page;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(PICLLabels.FileFilterDialog_title);
    }

    protected Control createDialogArea(Composite ancestor) {
        Composite topHalf = new Composite(ancestor, 0);
        GridLayout layout = new GridLayout();
        topHalf.setLayout((Layout)layout);
        topHalf.setLayoutData((Object)new GridData(768));
        Group filterOn = new Group(topHalf, 0);
        layout = new GridLayout();
        filterOn.setLayout((Layout)layout);
        filterOn.setLayoutData((Object)new GridData(768));
        filterOn.setText(PICLLabels.FileFilterDialog_filterOn);
        this.fFilterBaseButton = new Button((Composite)filterOn, 16);
        this.fFilterBaseButton.setText(PICLLabels.FileFilterDialog_filterBaseButton);
        this.fFilterBaseButton.setLayoutData((Object)new GridData(4, 1, true, false));
        this.fFilterBaseButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                FileFilterDialog.this.fFilterOnBaseName = true;
                FileFilterDialog.this.fFileFilterControl.filter(true);
            }
        });
        this.fFilterFullButton = new Button((Composite)filterOn, 16);
        this.fFilterFullButton.setText(PICLLabels.FileFilterDialog_filterFullButton);
        this.fFilterFullButton.setLayoutData((Object)new GridData(4, 1, true, false));
        this.fFilterFullButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                FileFilterDialog.this.fFilterOnBaseName = false;
                FileFilterDialog.this.fFileFilterControl.filter(true);
            }
        });
        this.fFilterBaseButton.setSelection(true);
        Composite checkMatches = new Composite(topHalf, 0);
        layout = new GridLayout();
        layout.numColumns = 2;
        layout.makeColumnsEqualWidth = true;
        checkMatches.setLayout((Layout)layout);
        checkMatches.setLayoutData((Object)new GridData(768));
        this.fCaseButton = new Button(checkMatches, 32);
        this.fCaseButton.setText(PICLLabels.EntryBPWizard_page1_caseLabel);
        this.fCaseButton.setLayoutData((Object)new GridData());
        this.fCaseButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                FileFilterDialog.this.fFileFilterControl.setIgnoreCase(!FileFilterDialog.this.fCaseButton.getSelection());
            }
        });
        this.fMatches = new Label(checkMatches, 0);
        this.fMatches.setLayoutData((Object)new GridData(4, 1, true, false));
        this.updateListCount(0);
        this.fFileFilterControl = new FileFilterList(this, true);
        this.fFileFilterControl.addWidgets(ancestor);
        Composite composite = new Composite(ancestor, 0);
        layout = new GridLayout();
        layout.numColumns = 1;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(768));
        layout = new GridLayout();
        layout.numColumns = 1;
        this.fProgressPart = new ProgressMonitorPart(composite, (Layout)layout, false);
        this.fProgressPart.setLayoutData((Object)new GridData(768));
        this.fFileFilterControl.initializeFiles();
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.getShell(), PICLUtils.getHelpResourceString("file_filter_dialog"));
        Dialog.applyDialogFont((Control)ancestor);
        UIJob uij = new UIJob("Fill File names"){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                FileFilterDialog.this.fillFileNames();
                return Status.OK_STATUS;
            }
        };
        uij.schedule();
        return ancestor;
    }

    public void processDialog() {
        this.okPressed();
    }

    protected void okPressed() {
        FileListItem item = this.fFileFilterControl.getSelectedItem();
        if (item == null) {
            super.okPressed();
            return;
        }
        String origFile = item.getFullName();
        DebuggeeProcess process = (DebuggeeProcess)this.fTarget.getProcess();
        ViewInformation vi = this.fTarget.getDebugEngine().getSourceViewInformation();
        if (vi == null) {
            super.okPressed();
            return;
        }
        int partId = item.getPartId();
        Part part = process.getPart(partId);
        View v = part.getView(vi);
        ViewFile[] viewfiles = v.getViewFiles();
        int i = 0;
        while (i < viewfiles.length) {
            ViewFile vf = viewfiles[i];
            if (vf.getBaseFileName().equals(origFile) || vf.getFileName().equals(origFile)) {
                PDTModelPresentation modelPresentation = new PDTModelPresentation();
                IEditorInput editorInput = modelPresentation.getEditorInput(vf);
                if (editorInput == null) break;
                try {
                    this.fWorkbenchPage.openEditor(editorInput, modelPresentation.getEditorId(editorInput, vf));
                    break;
                }
                catch (PartInitException partInitException) {
                    // empty catch block
                }
            }
            ++i;
        }
        super.okPressed();
    }

    protected IDialogSettings getDialogBoundsSettings() {
        IDialogSettings settings = PICLDebugPlugin.getInstance().getDialogSettings();
        IDialogSettings section = settings.getSection(SETTINGSSECTION);
        if (section == null) {
            section = settings.addNewSection(SETTINGSSECTION);
        }
        return section;
    }

    public void fillFileNames() {
        this.fProgressPart.beginTask(PICLLabels.FileFilterDialog_loading_file_list, -1);
        this.fFileFilterControl.setFilterEntryEnabled(false);
        final DebuggeeProcess process = (DebuggeeProcess)this.fTarget.getProcess();
        IProgressService service = (IProgressService)PlatformUI.getWorkbench().getService(IProgressService.class);
        EPDC_EngineSession engineSession = process.getDebugEngine().getEngineSession();
        int timeout = engineSession.getConnectionTimeout();
        int newTimeout = 0;
        engineSession.setConnectionTimeout(newTimeout);
        try {
            service.busyCursorWhile(new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) {
                    FileListItem[] files = process.getFileNamesList();
                    FileFilterDialog.this.fFileFilterControl.setElements(files);
                }
            });
        }
        catch (InvocationTargetException invocationTargetException) {
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        engineSession.setConnectionTimeout(timeout);
        this.fFileFilterControl.setFilter("", true);
        this.fFileFilterControl.setFilterEntryEnabled(true);
        this.fFileFilterControl.setFocus();
        this.fProgressPart.done();
    }

    public void updateListCount(int count) {
        this.fMatches.setText(PICLLabels.FileFilterDialog_matches + " " + count);
    }

    public boolean filterOnBaseName() {
        return this.fFilterOnBaseName;
    }
}

