/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.internal.ui.dialogs;

import com.ibm.debug.pdt.internal.core.PDTDebugTarget;
import com.ibm.debug.pdt.internal.core.PICLLabels;
import com.ibm.debug.pdt.internal.core.PICLMessages;
import com.ibm.debug.pdt.internal.core.model.DebuggeeProcess;
import com.ibm.debug.pdt.internal.core.model.DebuggeeThread;
import com.ibm.debug.pdt.internal.core.model.EngineRequestException;
import com.ibm.debug.pdt.internal.epdc.ProcessStopInfo;
import com.ibm.debug.pdt.internal.ui.PICLDebugPlugin;
import com.ibm.debug.pdt.internal.ui.PICLUtils;
import com.ibm.debug.pdt.internal.ui.dialogs.DebugTrayDialog;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.DebugException;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class ExceptionDialog
extends DebugTrayDialog {
    private Button fStepButton;
    private Button fRunButton;
    private Button fRetryButton;
    private PDTDebugTarget fDebugTarget;
    private ProcessStopInfo fStopInfo;
    private final DebuggeeThread fThread;
    public static final int STEP_EXCEPTION = 0;
    public static final int RUN_EXCEPTION = 1;
    public static final int RETRY_EXCEPTION = 2;
    private static final String SETTINGSSECTION = PICLDebugPlugin.getPluginID() + ".exceptionDialog";

    public ExceptionDialog(Shell shell, PDTDebugTarget target, ProcessStopInfo stopInfo, DebuggeeThread thread) {
        super(shell);
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.fDebugTarget = target;
        this.fStopInfo = stopInfo;
        this.fThread = thread;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(PICLLabels.EventDialog_title);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)shell, PICLUtils.getHelpResourceString("exception_dialog"));
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = this.convertVerticalDLUsToPixels(7);
        layout.marginWidth = this.convertHorizontalDLUsToPixels(7);
        layout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
        layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        composite.setFont(parent.getFont());
        short reason = this.fStopInfo.getReason();
        String message = this.fStopInfo.getExceptionMsg();
        DebuggeeProcess process = (DebuggeeProcess)this.fDebugTarget.getProcess();
        Label l = new Label(composite, 0);
        l.setText(PICLLabels.EventDialog_message);
        l = new Label(composite, 0);
        l.setText(message != null ? message : PICLMessages.InternalError);
        boolean excpRun = this.fDebugTarget.supportsExceptionRun();
        boolean excpStep = this.fDebugTarget.supportsExceptionStep();
        boolean excpExamine = this.fDebugTarget.supportsExceptionExamine();
        if (excpRun || excpStep || excpExamine) {
            l = new Label(composite, 0);
            l.setText(PICLLabels.EventDialog_instruction);
            if (excpStep && (reason == 5 || reason == 7)) {
                this.fStepButton = new Button(composite, 16);
                this.fStepButton.setText(PICLLabels.EventDialog_stepRadioButton);
            }
            if (excpRun) {
                this.fRunButton = new Button(composite, 16);
                this.fRunButton.setText(PICLLabels.EventDialog_runRadioButton);
            }
            if (excpExamine && (reason == 5 || reason == 6)) {
                this.fRetryButton = new Button(composite, 16);
                if (this.fDebugTarget.getEngineSession().isAIX()) {
                    this.fRetryButton.setText(PICLLabels.EventDialog_retryRadioButton);
                } else {
                    this.fRetryButton.setText(PICLLabels.EventDialog_retryRadioButton2);
                }
            }
        }
        l = new Label(composite, 0);
        l.setText(NLS.bind((String)PICLLabels.picl_process_label, (Object)process.getProcessID(), (Object)process.getQualifiedName()));
        l = new Label(composite, 0);
        try {
            l.setText(PICLLabels.Thread_Name + ": " + this.fThread.getName());
        }
        catch (DebugException debugException) {
            // empty catch block
        }
        return composite;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
    }

    protected void okPressed() {
        int result = this.fStepButton != null && this.fStepButton.getSelection() ? 0 : (this.fRetryButton != null && this.fRetryButton.getSelection() ? 2 : 1);
        super.okPressed();
        this.handleException(result);
    }

    private void handleException(final int result) {
        Job excJob = new Job(PICLLabels.Job_HandleDebuggeeException){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    if (ExceptionDialog.this.fThread.isTerminated()) {
                        return Status.OK_STATUS;
                    }
                    switch (result) {
                        case 0: {
                            ExceptionDialog.this.fThread.stepException();
                            break;
                        }
                        case 1: {
                            ExceptionDialog.this.fThread.runException();
                            break;
                        }
                        case 2: {
                            ExceptionDialog.this.fThread.ignoreException();
                            break;
                        }
                    }
                }
                catch (EngineRequestException e) {
                    PICLDebugPlugin.showMessageDialog(null, ExceptionDialog.this.fDebugTarget, e, true);
                    return new Status(4, PICLDebugPlugin.getPluginID(), 0, e.getMessage(), (Throwable)e);
                }
                return Status.OK_STATUS;
            }
        };
        excJob.setSystem(false);
        excJob.schedule();
    }

    protected void handleShellCloseEvent() {
    }

    @Override
    protected Control createContents(Composite parent) {
        Control composite = super.createContents(parent);
        Dialog.applyDialogFont((Control)composite);
        return composite;
    }

    protected int getDialogBoundsStrategy() {
        return 1;
    }

    protected IDialogSettings getDialogBoundsSettings() {
        IDialogSettings settings = PICLDebugPlugin.getInstance().getDialogSettings();
        IDialogSettings section = settings.getSection(SETTINGSSECTION);
        if (section == null) {
            section = settings.addNewSection(SETTINGSSECTION);
        }
        return section;
    }
}

