/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.internal.ui.dialogs;

import com.ibm.debug.pdt.internal.core.PICLLabels;
import com.ibm.debug.pdt.internal.core.model.EngineRequestException;
import com.ibm.debug.pdt.internal.core.util.PDTCoreUtils;
import com.ibm.debug.pdt.internal.ui.PICLDebugTarget;
import com.ibm.debug.pdt.internal.ui.dialogs.DebugTrayDialog;
import com.ibm.debug.xmlui.api.XUIAttribute;
import com.ibm.debug.xmlui.api.XUIAttributeList;
import com.ibm.debug.xmlui.ui.XUIBuilder;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.HashMap;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

public class EventDialog
extends DebugTrayDialog {
    private PICLDebugTarget fDebugTarget;
    private int fThreadId;
    private short fEventType;
    private XUIBuilder fBuilder;
    private String fXML;

    public EventDialog(Shell shell, PICLDebugTarget target, short type, String XML, int thread) {
        super(shell);
        this.fDebugTarget = target;
        this.fEventType = type;
        this.fXML = XML;
        this.fThreadId = thread;
    }

    public Control createDialogArea(Composite parent) {
        try {
            this.fBuilder = new XUIBuilder((InputStream)new ByteArrayInputStream(this.fXML.getBytes()));
            this.fBuilder.createContents(parent);
            String name = this.fBuilder.getModel().getName();
            if (name != null && !name.isEmpty()) {
                this.getShell().setText(name);
            }
        }
        catch (Exception e) {
            PDTCoreUtils.logError((Exception)e);
        }
        return parent;
    }

    @Override
    protected Control createContents(Composite parent) {
        Control composite = super.createContents(parent);
        Dialog.applyDialogFont((Control)composite);
        return composite;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(PICLLabels.EngineEventDialog_title);
    }

    protected void okPressed() {
        XUIAttributeList xmlAttributes = this.fBuilder.getAttributes();
        HashMap<String, String> attributes = new HashMap<String, String>();
        int i = 0;
        while (i < xmlAttributes.size()) {
            XUIAttribute xmlAttribute = xmlAttributes.getAttribute(i);
            attributes.put(xmlAttribute.getName(), xmlAttribute.getValue());
            ++i;
        }
        try {
            this.fDebugTarget.sendEventAttributes(this.fEventType, attributes, this.fThreadId);
        }
        catch (EngineRequestException e) {
            MessageDialog.openWarning((Shell)this.getShell(), (String)PICLLabels.MessageDialog_title_Warning, (String)e.getMessage());
        }
        super.okPressed();
    }

    protected void cancelPressed() {
        this.okPressed();
    }
}

