/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.internal.ui.dialogs;

import com.ibm.debug.pdt.internal.core.OptionalBreakpointData;
import com.ibm.debug.pdt.internal.core.PDTDebugTarget;
import com.ibm.debug.pdt.internal.core.PICLLabels;
import com.ibm.debug.pdt.internal.core.PICLMessages;
import com.ibm.debug.pdt.internal.core.model.Breakpoint;
import com.ibm.debug.pdt.internal.core.model.DebuggeeProcess;
import com.ibm.debug.pdt.internal.core.model.EngineRequestException;
import com.ibm.debug.pdt.internal.core.model.EntryBreakpoint;
import com.ibm.debug.pdt.internal.core.model.Function;
import com.ibm.debug.pdt.internal.ui.PICLDebugPlugin;
import com.ibm.debug.pdt.internal.ui.PICLUtils;
import com.ibm.debug.pdt.internal.ui.dialogs.BreakpointWizard;
import com.ibm.debug.pdt.internal.ui.dialogs.ConditionalBreakpointWizardPage;
import com.ibm.debug.pdt.internal.ui.dialogs.EntrySelectBPWizardPage;
import com.ibm.debug.pdt.internal.ui.util.StatusInfo;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.ui.progress.WorkbenchJob;

public class EntrySelectBPWizard
extends BreakpointWizard {
    protected static final String DIALOG = "EntrySelectBPWizard.dialog";
    protected static final String PAGE_1 = "EntrySelectBPWizard.page1";
    protected static final String PAGE_2 = "BreakpointWizard.optional";
    private final EntryBreakpoint existingBP;
    private String fMainPageName;
    private String fCondPageName;

    public EntrySelectBPWizard(PDTDebugTarget debugTarget) {
        super(debugTarget);
        this.existingBP = null;
        this.fEditing = false;
        this.initializeWizard();
    }

    public EntrySelectBPWizard(PDTDebugTarget debugTarget, EntryBreakpoint breakpoint) {
        super(debugTarget);
        this.fEditing = true;
        this.existingBP = breakpoint;
        this.initializeWizard();
    }

    private void initializeWizard() {
        if (!this.fEditing) {
            this.setWindowTitle(PICLLabels.EntryBPWizard_dialog_title);
        } else {
            this.setWindowTitle(PICLLabels.EntryBPWizard_dialog_title2);
        }
        this.setDefaultPageImageDescriptor(PICLUtils.getImageDescriptor("PICL_ICON_BREAKPOINT_WIZARD"));
        this.setNeedsProgressMonitor(true);
        IDialogSettings dialogSettings = PICLDebugPlugin.getInstance().getDialogSettings();
        IDialogSettings section = dialogSettings.getSection(DIALOG);
        if (section == null) {
            section = dialogSettings.addNewSection(DIALOG);
        }
        this.setDialogSettings(section);
    }

    public void addPages() {
        this.fMainPageName = PICLLabels.EntryBPWizard_page1_pageName;
        String title = PICLLabels.EntryBPWizard_page1_title;
        WizardPage wizardPage = new EntrySelectBPWizardPage(this.fMainPageName, title, null, this.fDebugTarget, this.existingBP);
        this.addPage((IWizardPage)wizardPage);
        this.fCondPageName = PICLLabels.BreakpointWizard_optional_pageName;
        wizardPage = new ConditionalBreakpointWizardPage(this.fCondPageName, PICLLabels.BreakpointWizard_optional_title, null, this.fDebugTarget, (Breakpoint)this.existingBP);
        if (this.areOptionalParametersSupported()) {
            this.addPage((IWizardPage)wizardPage);
        }
    }

    @Override
    public boolean performFinish() {
        if (this.checkFinishButtonClicked()) {
            return false;
        }
        EntrySelectBPWizardPage page = (EntrySelectBPWizardPage)this.getPage(this.fMainPageName);
        ConditionalBreakpointWizardPage condPage = this.areOptionalParametersSupported() ? (ConditionalBreakpointWizardPage)this.getPage(this.fCondPageName) : new ConditionalBreakpointWizardPage("", "", null, this.fDebugTarget, (Breakpoint)this.existingBP);
        OptionalBreakpointData optData = condPage.getPageData();
        boolean checkFunctionSuccess = page.checkFunction();
        String originalName = page.getSelectedFunctionOriginalName();
        if (!checkFunctionSuccess) {
            this.showPage(page);
            this.resetAlreadyClicked();
            return false;
        }
        this.processBreakpoint(originalName, true, optData);
        return false;
    }

    private StatusInfo processBreakpoint(final String originalName, final boolean caseSensitive, final OptionalBreakpointData optData) {
        StatusInfo status = new StatusInfo();
        if (this.fDebugTarget == null) {
            status.setError(PICLMessages.BreakpointWizard_targetError);
            return status;
        }
        if (!this.getPage(this.fMainPageName).getControl().isDisposed()) {
            this.wbJob = new WorkbenchJob("Install BP"){

                public IStatus runInUIThread(IProgressMonitor monitor) {
                    try {
                        EntrySelectBPWizard.this.getContainer().run(true, false, new IRunnableWithProgress(){

                            public void run(IProgressMonitor monitor) {
                                monitor.beginTask(PICLLabels.EntrySelectBPWizard_page1_installing_breakpoint, -1);
                                Function[] fns = ((DebuggeeProcess)(this).EntrySelectBPWizard.this.fDebugTarget.getProcess()).getFunctions(originalName, caseSensitive);
                                Function func = null;
                                if (fns.length > 0) {
                                    func = fns[0];
                                }
                                if (func != null) {
                                    try {
                                        (this).EntrySelectBPWizard.this.fDebugTarget.createEntryBreakpoint(true, func, caseSensitive, optData);
                                    }
                                    catch (EngineRequestException engineRequestException) {
                                        // empty catch block
                                    }
                                }
                                monitor.done();
                            }
                        });
                        ((WizardDialog)EntrySelectBPWizard.this.getContainer()).close();
                    }
                    catch (InvocationTargetException invocationTargetException) {
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    return new Status(0, "com.ibm.debug.idebug.pdt", 0, "no message", null);
                }
            };
            this.wbJob.schedule();
        }
        return status;
    }
}

