/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.internal.ui.dialogs;

import com.ibm.debug.pdt.core.PDTDebugUtils;
import com.ibm.debug.pdt.internal.core.PDTDebugTarget;
import com.ibm.debug.pdt.internal.core.PICLLabels;
import com.ibm.debug.pdt.internal.core.PICLMessages;
import com.ibm.debug.pdt.internal.core.model.DebuggeeProcess;
import com.ibm.debug.pdt.internal.core.model.EntryBreakpoint;
import com.ibm.debug.pdt.internal.core.model.Function;
import com.ibm.debug.pdt.internal.core.model.Part;
import com.ibm.debug.pdt.internal.core.model.ViewFile;
import com.ibm.debug.pdt.internal.ui.PICLUtils;
import com.ibm.debug.pdt.internal.ui.dialogs.BreakpointWizardPage;
import com.ibm.debug.pdt.internal.ui.dialogs.ISettingsWriter;
import com.ibm.debug.pdt.internal.ui.dialogs.OverloadedDialog;
import com.ibm.debug.pdt.internal.ui.util.FieldTextAssist;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Vector;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.fieldassist.ComboContentAdapter;
import org.eclipse.jface.fieldassist.IControlContentAdapter;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class EntryBPWizardPage
extends BreakpointWizardPage
implements ISettingsWriter {
    private EntryBreakpoint fExistingBP = null;
    private Function fSelectedFunction = null;
    private String fSelectedFunctionName = null;
    protected Combo fExecutableField = null;
    protected Label fExecutableLabel = null;
    protected Combo fObjectField = null;
    protected Label fObjectLabel = null;
    protected Combo fFunctionField = null;
    private Button fCaseButton;
    protected Button fDeferButton;
    protected Button fFilterDebugButton;
    private Text fUserLabelField = null;
    private Label fUserLabelLabel = null;
    private FieldTextAssist fAssistExecutable;
    private FieldTextAssist fAssistObject;
    private FieldTextAssist fAssistFunction;
    private static final String PAGE_NAME = "EntryBPWizard.page1";
    private static final String DEFER = "defer";
    private static final String FILTER = "filter";
    private boolean fSupportsDeferred = false;

    protected EntryBPWizardPage(String pageName, String title, ImageDescriptor titleImage, PDTDebugTarget tgt, EntryBreakpoint editBreakpoint) {
        super(pageName, title, titleImage, tgt, editBreakpoint != null);
        this.fExistingBP = editBreakpoint;
        if (PDTDebugUtils.isiSeriesEngine((IDebugTarget)this.fDebugTarget)) {
            this.setDescription(PICLLabels.EntryBPWizard_page1_description_400);
        } else {
            this.setDescription(PICLLabels.EntryBPWizard_page1_description);
        }
        this.fSupportsDeferred = tgt.supportsDeferredBreakpoints();
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        composite.setLayout((Layout)layout);
        this.setControl((Control)composite);
        if (this.fSupportsDeferred) {
            this.fDeferButton = new Button(composite, 32);
            this.fDeferButton.setText(PICLLabels.EntryBPWizard_page1_deferLabel);
            this.fDeferButton.addSelectionListener(new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent e) {
                }

                public void widgetSelected(SelectionEvent e) {
                    if (EntryBPWizardPage.this.fDeferButton.getSelection()) {
                        EntryBPWizardPage.this.fFilterDebugButton.setEnabled(false);
                        String temp = EntryBPWizardPage.this.fExecutableField.getText();
                        EntryBPWizardPage.this.fExecutableField.removeAll();
                        EntryBPWizardPage.this.fExecutableField.setText(temp);
                        EntryBPWizardPage.this.fExecutableLabel.setText(EntryBPWizardPage.this.getExecutableLabel());
                        temp = EntryBPWizardPage.this.fObjectField.getText();
                        EntryBPWizardPage.this.fObjectField.removeAll();
                        EntryBPWizardPage.this.fObjectField.setText(temp);
                        EntryBPWizardPage.this.fObjectLabel.setText(EntryBPWizardPage.this.getObjectLabel());
                        temp = EntryBPWizardPage.this.fFunctionField.getText();
                        EntryBPWizardPage.this.fFunctionField.removeAll();
                        EntryBPWizardPage.this.fFunctionField.setText(temp);
                    } else {
                        EntryBPWizardPage.this.fExecutableLabel.setText(EntryBPWizardPage.this.getExecutableLabel());
                        EntryBPWizardPage.this.fFilterDebugButton.setEnabled(true);
                    }
                    EntryBPWizardPage.this.checkIfComplete();
                }
            });
        }
        this.fFilterDebugButton = new Button(composite, 32);
        this.fFilterDebugButton.setText(PICLLabels.EntryBPWizard_page1_debugInfoLabel);
        this.fExecutableLabel = new Label(composite, 16384);
        this.fExecutableLabel.setText(this.getExecutableLabel());
        this.fExecutableField = new Combo(composite, 4);
        GridData gd = new GridData(768);
        gd.grabExcessHorizontalSpace = true;
        this.fExecutableField.setLayoutData((Object)gd);
        this.fAssistExecutable = new FieldTextAssist((Control)this.fExecutableField, (IControlContentAdapter)new ComboContentAdapter(), this.filter(this.fExecutableField.getItems(), this.getExecutableName()));
        this.fExecutableField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                EntryBPWizardPage.this.fAssistExecutable.setProposals(EntryBPWizardPage.this.filter(EntryBPWizardPage.this.fExecutableField.getItems(), EntryBPWizardPage.this.getExecutableName()));
                EntryBPWizardPage.this.checkIfComplete();
            }
        });
        this.fExecutableField.addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent e) {
            }

            public void focusGained(FocusEvent e) {
                if (!EntryBPWizardPage.this.isDeferred()) {
                    String currentText = EntryBPWizardPage.this.getExecutableName();
                    EntryBPWizardPage.this.verifyExecutable(currentText);
                    EntryBPWizardPage.this.fAssistExecutable.setProposals(EntryBPWizardPage.this.filter(EntryBPWizardPage.this.fExecutableField.getItems(), currentText));
                }
            }
        });
        this.fObjectLabel = new Label(composite, 16384);
        this.fObjectLabel.setText(this.getObjectLabel());
        this.fObjectField = new Combo(composite, 4);
        gd = new GridData(768);
        gd.grabExcessHorizontalSpace = true;
        this.fObjectField.setLayoutData((Object)gd);
        this.fAssistObject = new FieldTextAssist((Control)this.fObjectField, (IControlContentAdapter)new ComboContentAdapter(), this.filter(this.fObjectField.getItems(), this.getObjectName()));
        this.fObjectField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                EntryBPWizardPage.this.fAssistObject.setProposals(EntryBPWizardPage.this.filter(EntryBPWizardPage.this.fObjectField.getItems(), EntryBPWizardPage.this.getObjectName()));
                EntryBPWizardPage.this.checkIfComplete();
            }
        });
        this.fObjectField.addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent e) {
            }

            public void focusGained(FocusEvent e) {
                if (!EntryBPWizardPage.this.isDeferred()) {
                    String currentText = EntryBPWizardPage.this.getObjectName();
                    EntryBPWizardPage.this.verifyObject(currentText);
                    EntryBPWizardPage.this.fAssistObject.setProposals(EntryBPWizardPage.this.filter(EntryBPWizardPage.this.fObjectField.getItems(), currentText));
                }
            }
        });
        Label l = new Label(composite, 16384);
        if (PDTDebugUtils.isiSeriesEngine((IDebugTarget)this.fDebugTarget)) {
            l.setText(PICLLabels.EntryBPWizard_page1_entry_400);
        } else {
            l.setText(PICLLabels.EntryBPWizard_page1_entry);
        }
        this.fFunctionField = new Combo(composite, 4);
        gd = new GridData(768);
        gd.grabExcessHorizontalSpace = true;
        this.fFunctionField.setLayoutData((Object)gd);
        this.fAssistFunction = new FieldTextAssist((Control)this.fFunctionField, (IControlContentAdapter)new ComboContentAdapter(), this.filter(this.fFunctionField.getItems(), this.getFunctionName()));
        this.fFunctionField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                EntryBPWizardPage.this.fAssistFunction.setProposals(EntryBPWizardPage.this.filter(EntryBPWizardPage.this.fFunctionField.getItems(), EntryBPWizardPage.this.getFunctionName()));
                EntryBPWizardPage.this.checkIfComplete();
            }
        });
        this.fFunctionField.addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent e) {
            }

            public void focusGained(FocusEvent e) {
                if (!EntryBPWizardPage.this.isDeferred()) {
                    String currentText = EntryBPWizardPage.this.getFunctionName();
                    EntryBPWizardPage.this.verifyFunction(currentText);
                    EntryBPWizardPage.this.fAssistFunction.setProposals(EntryBPWizardPage.this.filter(EntryBPWizardPage.this.fFunctionField.getItems(), currentText));
                }
            }
        });
        this.fCaseButton = new Button(composite, 32);
        this.fCaseButton.setText(PICLLabels.EntryBPWizard_page1_caseLabel);
        gd = new GridData();
        gd.horizontalIndent = 5;
        this.fCaseButton.setLayoutData((Object)gd);
        this.fUserLabelLabel = new Label(composite, 16384);
        this.fUserLabelLabel.setText(PICLLabels.EntryBPWizard_page1_userLabel);
        this.fUserLabelField = new Text(composite, 2052);
        gd = new GridData(768);
        gd.grabExcessHorizontalSpace = true;
        this.fUserLabelField.setLayoutData((Object)gd);
        this.initializePage(this.fExistingBP == null);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, PICLUtils.getHelpResourceString("entry_bp_wizard"));
        Dialog.applyDialogFont((Control)composite);
    }

    private boolean verifyExecutable(String execName) {
        if (execName.length() == 0) {
            this.fillExecutables(this.fExecutableField, this.isFilterOnDebug());
            ViewFile vf = this.getViewFile();
            if (vf != null) {
                this.fExecutableField.setText(vf.getPart().getModule().getName());
                return true;
            }
            return false;
        }
        this.fillExecutables(this.fExecutableField, this.isFilterOnDebug());
        this.fExecutableField.setText(execName);
        String[] filteredList = this.filter(this.fExecutableField.getItems(), execName);
        return filteredList.length > 0;
    }

    private boolean verifyObject(String objName) {
        this.fObjectField.removeAll();
        String execName = this.getExecutableName();
        if (execName.length() == 0) {
            this.fillObjects(this.fObjectField, this.isFilterOnDebug(), execName);
            int n = 0;
            while (n < this.fExecutableField.getItemCount()) {
                this.fillObjects(this.fObjectField, this.isFilterOnDebug(), this.fExecutableField.getItem(n));
                ++n;
            }
        } else {
            this.fillObjects(this.fObjectField, this.isFilterOnDebug(), execName);
        }
        this.fObjectField.setText(objName);
        String[] filteredList = this.filter(this.fObjectField.getItems(), objName);
        return filteredList.length > 0;
    }

    private boolean verifyFunction(String functionName) {
        this.fFunctionField.removeAll();
        String objName = this.getObjectName();
        if (objName.length() == 0) {
            int n = 0;
            while (n < this.fObjectField.getItemCount()) {
                this.fillFunctions(this.fObjectField.getItem(n));
                ++n;
            }
        } else {
            this.fillFunctions(objName);
        }
        this.fFunctionField.setText(functionName);
        String[] filteredList = this.filter(this.fFunctionField.getItems(), functionName);
        return filteredList.length > 0;
    }

    private void initializePage(boolean createBkp) {
        this.setPageComplete(false);
        if (createBkp) {
            String moduleName;
            ViewFile vf = this.getViewFile();
            if (vf != null && (moduleName = vf.getPart().getModule().getName()) != null) {
                Part part = vf.getPart();
                String partName = part.getName();
                Object[] functions = part.getFunctions();
                Arrays.sort(functions);
                this.fExecutableField.setText(moduleName);
                this.fObjectField.setText(partName);
                if (functions.length > 0) {
                    this.fFunctionField.setText(functions[0].getLabel());
                } else {
                    this.fFunctionField.setText("");
                }
            }
            if (this.getSettings() == null) {
                this.fFilterDebugButton.setSelection(true);
            } else {
                this.fFilterDebugButton.setSelection(this.getSettings().getBoolean(FILTER));
            }
        } else {
            if (this.fDeferButton != null) {
                this.fDeferButton.setSelection(this.fExistingBP.isDeferred());
            }
            if (this.fExistingBP.isDeferred()) {
                String text = this.fExistingBP.getModuleName();
                if (text != null) {
                    this.fExecutableField.setText(text);
                }
                if ((text = this.fExistingBP.getPartName()) != null) {
                    this.fObjectField.setText(text);
                }
                if ((text = this.fExistingBP.getFunctionName()) != null) {
                    this.fFunctionField.setText(text);
                }
            } else {
                this.fExecutableField.setText(this.fExistingBP.getPart().getModule().getName());
                this.fObjectField.setText(this.fExistingBP.getPart().getName());
                this.fFunctionField.setText(this.fExistingBP.getFunctionName());
            }
            this.fExecutableLabel.setText(this.getExecutableLabel());
            if (this.fExistingBP.getPart() != null) {
                this.fFilterDebugButton.setSelection(this.fExistingBP.getPart().isDebuggable());
            } else {
                this.fFilterDebugButton.setSelection(false);
            }
            String userLabel = this.fExistingBP.getUserLabel();
            if (userLabel != null) {
                this.fUserLabelField.setText(userLabel);
            }
        }
        if (this.isDeferred()) {
            this.fFilterDebugButton.setEnabled(false);
        }
        this.checkIfComplete();
    }

    public String getExecutableName() {
        return this.fExecutableField.getText().trim();
    }

    public String getObjectName() {
        return this.fObjectField.getText().trim();
    }

    public String getSelectedFunctionName() {
        return this.fSelectedFunctionName;
    }

    public String getFunctionName() {
        return this.fFunctionField.getText().trim();
    }

    public Function getFunction() {
        return this.fSelectedFunction;
    }

    public boolean isDeferred() {
        if (this.fSupportsDeferred && this.fDeferButton != null) {
            return this.fDeferButton.getSelection();
        }
        return false;
    }

    protected boolean isFilterOnDebug() {
        return this.fFilterDebugButton.getSelection();
    }

    public boolean isCaseSensitive() {
        return this.fCaseButton.getSelection();
    }

    @Override
    public void writeSettings() {
        IDialogSettings settings = this.getSettings();
        if (settings == null) {
            this.getDialogSettings().addNewSection(PAGE_NAME);
        }
        settings = this.getSettings();
        if (this.fDeferButton != null) {
            settings.put(DEFER, this.fDeferButton.getSelection());
        }
        settings.put(FILTER, this.fFilterDebugButton.getSelection());
    }

    protected void fillFunctions(String chosenPart) {
        DebuggeeProcess process = (DebuggeeProcess)this.fDebugTarget.getProcess();
        Part[] parts = process.getParts();
        Part part = null;
        int i = 0;
        while (i < parts.length) {
            if (parts[i].getName().equalsIgnoreCase(chosenPart)) {
                part = parts[i];
                break;
            }
            ++i;
        }
        if (part == null) {
            if (this.fFunctionField != null) {
                this.fFunctionField.removeAll();
            }
            return;
        }
        Object[] fns = part.getFunctions();
        if (fns.length == 0) {
            this.fFunctionField.removeAll();
            return;
        }
        Arrays.sort(fns);
        int i2 = 0;
        while (i2 < fns.length) {
            this.fFunctionField.add(fns[i2].getName());
            ++i2;
        }
    }

    private IDialogSettings getSettings() {
        IDialogSettings ds = this.getDialogSettings();
        if (ds == null) {
            return null;
        }
        return ds.getSection(PAGE_NAME);
    }

    protected String getExecutableLabel() {
        if (PDTDebugUtils.isiSeriesEngine((IDebugTarget)this.fDebugTarget)) {
            if (this.isDeferred()) {
                return PICLLabels.EntryBPWizard_page1_executable_400;
            }
            return PICLLabels.EntryBPWizard_page1_executableOptional_400;
        }
        if (PDTDebugUtils.isDebugToolEngine((IDebugTarget)this.fDebugTarget) || PDTDebugUtils.iszPICLEngine((IDebugTarget)this.fDebugTarget)) {
            if (this.isDeferred()) {
                return PICLLabels.EntryBPWizard_page1_executableOptional_debugTool;
            }
            return PICLLabels.EntryBPWizard_page1_executable_debugTool;
        }
        if (this.isDeferred()) {
            return PICLLabels.EntryBPWizard_page1_executable;
        }
        return PICLLabels.EntryBPWizard_page1_executableOptional;
    }

    protected String getObjectLabel() {
        if (PDTDebugUtils.isiSeriesEngine((IDebugTarget)this.fDebugTarget)) {
            return PICLLabels.EntryBPWizard_page1_object_400;
        }
        if (PDTDebugUtils.isDebugToolEngine((IDebugTarget)this.fDebugTarget) || PDTDebugUtils.iszPICLEngine((IDebugTarget)this.fDebugTarget)) {
            return PICLLabels.EntryBPWizard_page1_object_debugTool;
        }
        return PICLLabels.EntryBPWizard_page1_object;
    }

    protected void checkIfComplete() {
        this.setErrorMessage(null);
        if (this.getFunctionName().equals("")) {
            this.setPageComplete(false);
        } else if (this.isDeferred() && this.getExecutableName().equals("")) {
            this.setPageComplete(false);
        } else {
            this.setPageComplete(true);
        }
    }

    boolean checkFunction() {
        this.setErrorMessage(null);
        String functionName = this.getFunctionName();
        if (this.isDeferred()) {
            this.fSelectedFunctionName = functionName;
            return true;
        }
        String module = this.getExecutableName();
        String part = this.getObjectName();
        Part[] parts = ((DebuggeeProcess)this.fDebugTarget.getProcess()).getParts();
        Part matchingPart = null;
        Part[] partArray = parts;
        int n = parts.length;
        int n2 = 0;
        while (n2 < n) {
            Part p = partArray[n2];
            if (p.getName().equals(part) && p.getModule().getName().equals(module)) {
                matchingPart = p;
                break;
            }
            ++n2;
        }
        Function[] fns = matchingPart == null ? ((DebuggeeProcess)this.fDebugTarget.getProcess()).getFunctions(functionName, this.fCaseButton.getSelection()) : ((DebuggeeProcess)this.fDebugTarget.getProcess()).getFunctions(functionName, matchingPart.getId(), this.fCaseButton.getSelection());
        Vector<Function> functions = new Vector<Function>();
        if (fns != null) {
            int n3 = 0;
            while (n3 < fns.length) {
                block13: {
                    try {
                        if (!fns[n3].getViewFile().getPart().getName().equals(this.getObjectName()) && !this.getObjectName().equals("")) break block13;
                        functions.add(fns[n3]);
                    }
                    catch (Exception e) {
                        break;
                    }
                }
                ++n3;
            }
        }
        if (this.getExecutableName().length() > 0 && !this.verifyExecutable(this.getExecutableName())) {
            this.fExecutableField.setFocus();
            this.setErrorMessage(PICLMessages.picl_engine_request_breakpoint_entry_function_not_found);
            return false;
        }
        if (this.getObjectName().length() > 0 && !this.verifyObject(this.getObjectName())) {
            this.fObjectField.setFocus();
            this.setErrorMessage(PICLMessages.picl_engine_request_breakpoint_entry_function_not_found);
            return false;
        }
        if (functions.size() == 0) {
            this.fFunctionField.setFocus();
            this.setErrorMessage(PICLMessages.picl_engine_request_breakpoint_entry_function_not_found);
            return false;
        }
        if (functions.size() == 1) {
            this.fSelectedFunction = (Function)functions.firstElement();
            return true;
        }
        Function[] fnArray = new Function[functions.size()];
        Iterator fnIter = functions.iterator();
        int i = 0;
        while (fnIter.hasNext()) {
            fnArray[i++] = (Function)fnIter.next();
        }
        OverloadedDialog overload = new OverloadedDialog(this.getShell(), fnArray);
        overload.setBlockOnOpen(true);
        overload.open();
        Function rtnFn = overload.getChoice();
        if (rtnFn != null) {
            this.fFunctionField.setText(rtnFn.getName());
            this.fObjectField.setText(rtnFn.getViewFile().getPart().getName());
            this.fSelectedFunction = rtnFn;
            return true;
        }
        return false;
    }

    public String getUserLabel() {
        return this.fUserLabelField.getText().trim();
    }
}

