/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.internal.ui.dialogs;

import com.ibm.debug.pdt.internal.core.OptionalBreakpointData;
import com.ibm.debug.pdt.internal.core.PDTDebugTarget;
import com.ibm.debug.pdt.internal.core.PICLLabels;
import com.ibm.debug.pdt.internal.core.PICLMessages;
import com.ibm.debug.pdt.internal.core.model.Breakpoint;
import com.ibm.debug.pdt.internal.core.model.EngineRequestErrorException;
import com.ibm.debug.pdt.internal.core.model.EngineRequestException;
import com.ibm.debug.pdt.internal.core.model.EntryBreakpoint;
import com.ibm.debug.pdt.internal.core.model.Function;
import com.ibm.debug.pdt.internal.core.util.PDTCoreUtils;
import com.ibm.debug.pdt.internal.ui.PICLDebugPlugin;
import com.ibm.debug.pdt.internal.ui.PICLUtils;
import com.ibm.debug.pdt.internal.ui.dialogs.BreakpointWizard;
import com.ibm.debug.pdt.internal.ui.dialogs.ConditionalBreakpointWizardPage;
import com.ibm.debug.pdt.internal.ui.dialogs.EntryBPWizardPage;
import com.ibm.debug.pdt.internal.ui.util.StatusInfo;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.ui.progress.WorkbenchJob;

public class EntryBPWizard
extends BreakpointWizard {
    protected static final String DIALOG = "EntryBPWizard.dialog";
    protected static final String PAGE_1 = "EntryBPWizard.page1";
    protected static final String PAGE_2 = "BreakpointWizard.optional";
    private final EntryBreakpoint existingBP;

    public EntryBPWizard(PDTDebugTarget debugTarget) {
        super(debugTarget);
        this.existingBP = null;
        this.fEditing = false;
        this.initializeWizard();
    }

    public EntryBPWizard(PDTDebugTarget debugTarget, EntryBreakpoint breakpoint) {
        super(debugTarget);
        this.fEditing = true;
        this.existingBP = breakpoint;
        this.initializeWizard();
    }

    private void initializeWizard() {
        if (!this.fEditing) {
            this.setWindowTitle(PICLLabels.EntryBPWizard_dialog_title);
        } else {
            this.setWindowTitle(PICLLabels.EntryBPWizard_dialog_title2);
        }
        this.setDefaultPageImageDescriptor(PICLUtils.getImageDescriptor("PICL_ICON_BREAKPOINT_WIZARD"));
        this.setNeedsProgressMonitor(false);
        IDialogSettings dialogSettings = PICLDebugPlugin.getInstance().getDialogSettings();
        IDialogSettings section = dialogSettings.getSection(DIALOG);
        if (section == null) {
            section = dialogSettings.addNewSection(DIALOG);
        }
        this.setDialogSettings(section);
    }

    public void addPages() {
        this.fMainPageName = PICLLabels.EntryBPWizard_page1_pageName;
        this.addPage((IWizardPage)new EntryBPWizardPage(this.fMainPageName, PICLLabels.EntryBPWizard_page1_title, null, this.fDebugTarget, this.existingBP));
        if (this.areOptionalParametersSupported()) {
            this.addPage((IWizardPage)new ConditionalBreakpointWizardPage(this.fCondPageName, PICLLabels.BreakpointWizard_optional_title, null, this.fDebugTarget, (Breakpoint)this.existingBP));
        }
    }

    @Override
    public boolean performFinish() {
        if (this.checkFinishButtonClicked()) {
            return false;
        }
        final EntryBPWizardPage page = (EntryBPWizardPage)this.getPage(this.fMainPageName);
        final ConditionalBreakpointWizardPage condPage = this.areOptionalParametersSupported() ? (ConditionalBreakpointWizardPage)this.getPage(this.fCondPageName) : new ConditionalBreakpointWizardPage("", "", null, this.fDebugTarget, (Breakpoint)this.existingBP);
        final boolean deferred = page.isDeferred();
        final boolean caseSensitive = page.isCaseSensitive();
        final String exe = page.getExecutableName();
        final String obj = page.getObjectName();
        final OptionalBreakpointData optData = condPage.getPageData();
        optData.setUserLabel(page.getUserLabel());
        boolean checkFunctionSuccess = page.checkFunction();
        final Function func = page.getFunction();
        final String funcName = page.getSelectedFunctionName();
        if (!deferred && !checkFunctionSuccess) {
            this.showPage(page);
            this.resetAlreadyClicked();
            return false;
        }
        Job job = new Job(PICLLabels.BreakpointWizard_jobname_CreateModify){

            protected IStatus run(IProgressMonitor monitor) {
                StatusInfo created = null;
                created = deferred ? EntryBPWizard.this.processDeferredBreakpoint(exe, obj, funcName, caseSensitive, optData) : EntryBPWizard.this.processBreakpoint(func, caseSensitive, optData);
                final StatusInfo processResult = created;
                if (!page.getControl().isDisposed()) {
                    EntryBPWizard.this.wbJob = new WorkbenchJob(PICLLabels.BreakpointWizard_jobname_Update){

                        public IStatus runInUIThread(IProgressMonitor wbMonitor) {
                            EntryBPWizard.this.updateWizardPostProcessing(processResult, page, condPage);
                            return Status.OK_STATUS;
                        }
                    };
                    EntryBPWizard.this.wbJob.setSystem(true);
                    EntryBPWizard.this.wbJob.schedule();
                }
                return Status.OK_STATUS;
            }
        };
        job.setSystem(true);
        job.schedule();
        return false;
    }

    private StatusInfo processBreakpoint(Function func, boolean caseSensitive, OptionalBreakpointData optData) {
        StatusInfo status = new StatusInfo();
        if (this.fDebugTarget == null) {
            status.setError(PICLMessages.BreakpointWizard_targetError);
            return status;
        }
        try {
            if (this.fEditing) {
                if (this.existingBP.isDeferred()) {
                    this.fDebugTarget.createEntryBreakpoint(true, func, caseSensitive, optData);
                    this.existingBP.remove();
                } else {
                    this.existingBP.modify(func, caseSensitive, optData);
                }
            } else {
                this.fDebugTarget.createEntryBreakpoint(true, func, caseSensitive, optData);
            }
        }
        catch (EngineRequestErrorException ere) {
            status.setError(ere.getMessage());
        }
        catch (EngineRequestException engineRequestException) {
            // empty catch block
        }
        return status;
    }

    private StatusInfo processDeferredBreakpoint(String moduleName, String partName, String entryName, boolean caseSensitive, OptionalBreakpointData optData) {
        StatusInfo status = new StatusInfo();
        if (PDTCoreUtils.isEmpty((String)entryName)) {
            status.setError(PICLMessages.EntryBPWizard_page1_entryError);
            return status;
        }
        if (this.fDebugTarget == null) {
            status.setError(PICLMessages.BreakpointWizard_targetError);
            return status;
        }
        try {
            if (!this.fEditing) {
                this.fDebugTarget.createDeferredEntryBreakpoint(true, moduleName, partName, entryName, caseSensitive, optData, null);
            } else if (!this.existingBP.isDeferred()) {
                this.fDebugTarget.createDeferredEntryBreakpoint(true, moduleName, partName, entryName, caseSensitive, optData, null);
                this.existingBP.remove();
            } else {
                this.existingBP.modifyDeferred(entryName, moduleName, partName, caseSensitive, optData);
            }
        }
        catch (EngineRequestErrorException ere) {
            status.setError(ere.getMessage());
        }
        catch (EngineRequestException engineRequestException) {
            // empty catch block
        }
        return status;
    }
}

