/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.internal.ui.dialogs;

import com.ibm.debug.pdt.internal.core.PICLLabels;
import com.ibm.debug.pdt.internal.ui.GeneralStringItem;
import com.ibm.debug.pdt.internal.ui.PICLDebugPlugin;
import com.ibm.debug.pdt.internal.ui.PICLUtils;
import com.ibm.debug.pdt.internal.ui.dialogs.DebugTrayDialog;
import com.ibm.debug.pdt.internal.ui.util.CheckedList;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class DisambiguateMonitorsDialog
extends DebugTrayDialog {
    protected CheckedList fMonitorListControl;
    private GeneralStringItem[] fMonitorList;
    private Button fCheckAllButton;
    private Button fUncheckAllButton;
    private String[] fMonitorDescriptions;
    private boolean[] fSelectedMonitorArray;
    private static final String SETTINGSSECTION = PICLDebugPlugin.getPluginID() + ".disambiguateMonitorDialog";

    public DisambiguateMonitorsDialog(Shell parentShell, String[] monitorDescriptions) {
        super(parentShell);
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.fMonitorDescriptions = monitorDescriptions;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(PICLLabels.AmbiguousMonitorDialog_title);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)shell, PICLUtils.getHelpResourceString("ambiguous_monitor_dialog"));
    }

    protected Control createDialogArea(Composite ancestor) {
        Label l = new Label(ancestor, 0);
        l.setText(PICLLabels.AmbiguousMonitorDialog_label);
        GridData gd = new GridData(4, 4, true, true);
        gd.widthHint = this.convertWidthInCharsToPixels(65);
        gd.heightHint = this.convertHeightInCharsToPixels(20);
        this.fMonitorListControl = new CheckedList(ancestor, true, false);
        this.fMonitorListControl.setLayoutData(gd);
        this.initializeMonitorList();
        Composite buttonParent = new Composite(ancestor, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        buttonParent.setLayout((Layout)layout);
        this.fCheckAllButton = new Button(buttonParent, 8);
        this.fCheckAllButton.setText(PICLLabels.AmbiguousMonitorDialog_checkAllButton);
        this.fCheckAllButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                DisambiguateMonitorsDialog.this.fMonitorListControl.checkAll();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.fUncheckAllButton = new Button(buttonParent, 8);
        this.fUncheckAllButton.setText(PICLLabels.AmbiguousMonitorDialog_uncheckAllButton);
        this.fUncheckAllButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                DisambiguateMonitorsDialog.this.fMonitorListControl.uncheckAll();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.fMonitorListControl.selectFilterText();
        Dialog.applyDialogFont((Control)ancestor);
        return ancestor;
    }

    private boolean initializeMonitorList() {
        this.fMonitorList = new GeneralStringItem[this.fMonitorDescriptions.length];
        int i = 0;
        while (i < this.fMonitorDescriptions.length) {
            this.fMonitorList[i] = new GeneralStringItem(this.fMonitorDescriptions[i]);
            ++i;
        }
        this.fMonitorListControl.setElements(this.fMonitorList);
        this.fMonitorListControl.setFilter("*", true);
        return true;
    }

    protected void okPressed() {
        this.fSelectedMonitorArray = new boolean[this.fMonitorList.length];
        int i = 0;
        while (i < this.fMonitorList.length) {
            this.fSelectedMonitorArray[i] = this.fMonitorList[i].isEnabled();
            ++i;
        }
        super.okPressed();
    }

    protected void cancelPressed() {
        this.fSelectedMonitorArray = new boolean[this.fMonitorList.length];
        super.cancelPressed();
    }

    protected IDialogSettings getDialogBoundsSettings() {
        IDialogSettings settings = PICLDebugPlugin.getInstance().getDialogSettings();
        IDialogSettings section = settings.getSection(SETTINGSSECTION);
        if (section == null) {
            section = settings.addNewSection(SETTINGSSECTION);
        }
        return section;
    }

    public boolean[] getSelectedMonitors() {
        return this.fSelectedMonitorArray;
    }
}

