/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.internal.ui.dialogs;

import com.ibm.debug.pdt.internal.core.PICLLabels;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IPreferencesService;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.osgi.service.prefs.BackingStoreException;

public class CommunicationPrefFields
extends FieldEditor {
    private static final int NUM_CONTROLS = 1;
    private Group fCommunicationGroup;
    protected Button fTimeoutRadio;
    protected Text fSocketTimeoutText;
    private Button fInfiniteRadio;
    private Button fTraceEPDC;
    private Label fTraceFileLabel;
    private Text fTraceFileName;
    protected String fTraceFileDir;
    private Button fTraceBrowse;

    public CommunicationPrefFields(Composite parent) {
        super("socket_timeout", PICLLabels.PICLDebugPreferencePage_CommunicationGroup, parent);
    }

    protected void adjustForNumColumns(int numColumns) {
        ((GridData)this.fCommunicationGroup.getLayoutData()).horizontalSpan = numColumns;
    }

    protected void doFillIntoGrid(Composite parent, int numColumns) {
        this.fCommunicationGroup = new Group(parent, 0);
        GridData gd = new GridData(768);
        gd.horizontalSpan = numColumns;
        this.fCommunicationGroup.setLayoutData((Object)gd);
        this.fCommunicationGroup.setText(PICLLabels.PICLDebugPreferencePage_CommunicationGroup);
        GridLayout commGroupGridLayout = new GridLayout();
        commGroupGridLayout.numColumns = 3;
        this.fCommunicationGroup.setLayout((Layout)commGroupGridLayout);
        this.fTimeoutRadio = new Button((Composite)this.fCommunicationGroup, 16400);
        this.fTimeoutRadio.setText(PICLLabels.PICLDebugPreferencePage_SocketTimeout_Timeout);
        this.fTimeoutRadio.setLayoutData((Object)new GridData(32));
        this.fSocketTimeoutText = new Text((Composite)this.fCommunicationGroup, 2052);
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.fSocketTimeoutText.setLayoutData((Object)gd);
        this.fSocketTimeoutText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CommunicationPrefFields.this.clearErrorMessage();
                ((PreferencePage)CommunicationPrefFields.this.getPage()).setValid(true);
                int timeout = 0;
                try {
                    timeout = Integer.parseInt(CommunicationPrefFields.this.fSocketTimeoutText.getText());
                    if (timeout <= 0) {
                        CommunicationPrefFields.this.showErrorMessage(PICLLabels.PICLDebugPreferencePage_SocketTimeout_InvalidTimeoutValue);
                        ((PreferencePage)CommunicationPrefFields.this.getPage()).setValid(false);
                    }
                }
                catch (NumberFormatException nfe) {
                    CommunicationPrefFields.this.showErrorMessage(PICLLabels.PICLDebugPreferencePage_SocketTimeout_InvalidTimeoutValue);
                    ((PreferencePage)CommunicationPrefFields.this.getPage()).setValid(false);
                }
            }
        });
        this.fTimeoutRadio.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                CommunicationPrefFields.this.fSocketTimeoutText.setEnabled(CommunicationPrefFields.this.fTimeoutRadio.getSelection());
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.fInfiniteRadio = new Button((Composite)this.fCommunicationGroup, 16400);
        this.fInfiniteRadio.setText(PICLLabels.PICLDebugPreferencePage_SocketTimeout_Infinite);
        gd = new GridData(768);
        gd.horizontalSpan = 3;
        this.fInfiniteRadio.setLayoutData((Object)gd);
        this.fInfiniteRadio.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                CommunicationPrefFields.this.fSocketTimeoutText.setEnabled(CommunicationPrefFields.this.fTimeoutRadio.getSelection());
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.fTraceEPDC = new Button((Composite)this.fCommunicationGroup, 32);
        this.fTraceEPDC.setText(PICLLabels.PICLDebugPreferencePage_TraceEngineConnection);
        gd = new GridData(768);
        gd.horizontalSpan = 3;
        this.fTraceEPDC.setLayoutData((Object)gd);
        this.fTraceEPDC.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                CommunicationPrefFields.this.setFieldEnablement();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.fTraceFileLabel = new Label((Composite)this.fCommunicationGroup, 0);
        this.fTraceFileLabel.setText(PICLLabels.PICLDebugPreferencePage_TraceFileName);
        gd = new GridData(128);
        this.fTraceFileLabel.setLayoutData((Object)gd);
        this.fTraceFileName = new Text((Composite)this.fCommunicationGroup, 2052);
        gd = new GridData(768);
        gd.horizontalSpan = 1;
        this.fTraceFileName.setLayoutData((Object)gd);
        this.fTraceBrowse = new Button((Composite)this.fCommunicationGroup, 8);
        this.fTraceBrowse.setText(PICLLabels.PICLDebugPreferencePage_TraceFileBrowse);
        gd = new GridData(32);
        this.fTraceBrowse.setLayoutData((Object)gd);
        this.fTraceBrowse.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                DirectoryDialog dd = new DirectoryDialog(CommunicationPrefFields.this.getPage().getShell());
                dd.setFilterPath(CommunicationPrefFields.this.fTraceFileDir);
                String newDir = dd.open();
                if (newDir != null) {
                    CommunicationPrefFields.this.fTraceFileDir = newDir;
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    protected void doLoad() {
        IPreferenceStore store = this.getPreferenceStore();
        this.fTimeoutRadio.setSelection(store.getBoolean("socket_timeout"));
        int timeout = store.getInt("socket_timeout_sec");
        this.fSocketTimeoutText.setText(String.valueOf(timeout));
        IPreferencesService prefService = Platform.getPreferencesService();
        this.fTraceEPDC.setSelection(prefService.getBoolean("com.ibm.debug.pdt.core", "trace_EPDC", false, null));
        this.fTraceFileName.setText(prefService.getString("com.ibm.debug.pdt.core", "trace_file_name", "epdcDump", null));
        this.fTraceFileDir = prefService.getString("com.ibm.debug.pdt.core", "trace_file_dir", "", null);
        this.setFieldEnablement();
    }

    protected void doLoadDefault() {
        IPreferenceStore store = this.getPreferenceStore();
        this.fTimeoutRadio.setSelection(store.getDefaultBoolean("socket_timeout"));
        int timeout = store.getDefaultInt("socket_timeout_sec");
        this.fSocketTimeoutText.setText(String.valueOf(timeout));
        IPreferencesService prefService = Platform.getPreferencesService();
        prefService.setDefaultLookupOrder("com.ibm.debug.pdt.core", null, new String[]{"default"});
        this.fTraceEPDC.setSelection(prefService.getBoolean("com.ibm.debug.pdt.core", "trace_EPDC", false, null));
        this.fTraceFileName.setText(prefService.getString("com.ibm.debug.pdt.core", "trace_file_name", "epdcDump", null));
        this.fTraceFileDir = prefService.getString("com.ibm.debug.pdt.core", "trace_file_dir", "", null);
        prefService.setDefaultLookupOrder("com.ibm.debug.pdt.core", null, null);
        this.setFieldEnablement();
    }

    protected void doStore() {
        IPreferenceStore store = this.getPreferenceStore();
        store.setValue("socket_timeout", this.fTimeoutRadio.getSelection());
        try {
            int timeout = Integer.parseInt(this.fSocketTimeoutText.getText());
            store.setValue("socket_timeout_sec", timeout);
        }
        catch (Exception timeout) {
            // empty catch block
        }
        IEclipsePreferences pref = InstanceScope.INSTANCE.getNode("com.ibm.debug.pdt.core");
        pref.putBoolean("trace_EPDC", this.fTraceEPDC.getSelection());
        pref.put("trace_file_name", this.fTraceFileName.getText());
        pref.put("trace_file_dir", this.fTraceFileDir);
        try {
            pref.flush();
        }
        catch (BackingStoreException backingStoreException) {
            // empty catch block
        }
    }

    public int getNumberOfControls() {
        return 1;
    }

    public void store() {
        if (this.getPreferenceStore() == null) {
            return;
        }
        if (this.presentsDefaultValue()) {
            IPreferenceStore store = this.getPreferenceStore();
            store.setToDefault("socket_timeout");
            store.setToDefault("socket_timeout_sec");
            IEclipsePreferences pref = InstanceScope.INSTANCE.getNode("com.ibm.debug.pdt.core");
            pref.remove("trace_EPDC");
            pref.remove("trace_file_name");
            pref.remove("trace_file_dir");
            try {
                pref.flush();
            }
            catch (BackingStoreException backingStoreException) {}
        } else {
            this.doStore();
        }
    }

    private void setFieldEnablement() {
        if (this.fTraceEPDC.getSelection()) {
            this.fTraceFileLabel.setEnabled(true);
            this.fTraceFileName.setEnabled(true);
            this.fTraceBrowse.setEnabled(true);
        } else {
            this.fTraceFileLabel.setEnabled(false);
            this.fTraceFileName.setEnabled(false);
            this.fTraceBrowse.setEnabled(false);
        }
        if (this.fTimeoutRadio.getSelection()) {
            this.fInfiniteRadio.setSelection(false);
            this.fSocketTimeoutText.setEnabled(true);
        } else {
            this.fInfiniteRadio.setSelection(true);
            this.fSocketTimeoutText.setEnabled(false);
        }
    }
}

