/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.internal.ui.dialogs;

import com.ibm.debug.pdt.internal.common.CommonUtils;
import com.ibm.debug.pdt.internal.core.PICLLabels;
import com.ibm.debug.pdt.internal.core.model.EngineRequestException;
import com.ibm.debug.pdt.internal.core.model.Part;
import com.ibm.debug.pdt.internal.core.model.ViewFile;
import com.ibm.debug.pdt.internal.core.sourcelocator.PDTLookupResult;
import com.ibm.debug.pdt.internal.ui.EngineSuppliedViewEditorInput;
import com.ibm.debug.pdt.internal.ui.PICLDebugPlugin;
import com.ibm.debug.pdt.internal.ui.PICLUtils;
import com.ibm.debug.pdt.internal.ui.dialogs.DebugStatusDialog;
import com.ibm.debug.pdt.internal.ui.dialogs.ISettingsWriter;
import com.ibm.debug.pdt.rsecommon.IBrowseDialogDelegate;
import com.ibm.debug.pdt.rsecommon.RSECommonPlugin;
import java.io.File;
import org.eclipse.debug.core.sourcelookup.containers.LocalFileStorage;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;

public class ChangeTextFileDialog
extends DebugStatusDialog
implements ISettingsWriter {
    private static final String SETTINGSSECTION = PICLDebugPlugin.getPluginID() + ".changeTextFileDialog";
    protected static final String NEW_TEXT_FILE_NAME = "new_text_file_name";
    protected static final int MAX_HISTORY_ENTRIES = 5;
    protected Combo fNewTextFileCombo;
    private Button fBrowseButton;
    private Label fMsgLabel;
    protected EngineSuppliedViewEditorInput fESV;
    private IBrowseDialogDelegate fRemoteBrowseDialog = null;

    public ChangeTextFileDialog(Shell parent, EngineSuppliedViewEditorInput esv) {
        super(parent);
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.fESV = esv;
        this.setStatusLineAboveButtons(false);
        this.setTitle(PICLLabels.ChangeTextFileDialog_label_title);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, PICLUtils.getHelpResourceString("change_text_file_dialog"));
    }

    protected void okPressed() {
        String fileNamePathText = this.fNewTextFileCombo.getText().trim();
        boolean success = false;
        if (this.fESV != null && fileNamePathText != null && this.fESV.supportsFileSwitch()) {
            try {
                success = this.fESV.getViewFile().overrideFileName(fileNamePathText);
            }
            catch (EngineRequestException engineRequestException) {
                // empty catch block
            }
        }
        if (success) {
            this.fESV.getViewFile().clearLookupOverride();
        } else {
            File localFile = new File(fileNamePathText);
            if (localFile.exists() && localFile.isFile()) {
                LocalFileStorage localFileStorage = new LocalFileStorage(localFile);
                ViewFile vf = this.fESV.getViewFile();
                PDTLookupResult lookupResult = new PDTLookupResult(vf.getDebugTarget(), vf, this.fESV.getContext(), (Object)localFileStorage);
                vf.setLookupOverride(lookupResult);
            } else {
                this.fNewTextFileCombo.setFocus();
                return;
            }
        }
        this.writeSettings();
        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        PICLUtils.resetEditor(this.fESV.getContext(), page, 0);
        super.okPressed();
    }

    protected Control createDialogArea(Composite parent) {
        String[] history;
        Composite comp = new Composite(parent, 0);
        comp.setLayout((Layout)new GridLayout(3, false));
        comp.setLayoutData((Object)new GridData(4, 4, true, true));
        if (this.fESV != null && this.fESV.getPICLDebugTarget().is390()) {
            try {
                Part parentPart = this.fESV.getViewFile().getPart();
                String partName = parentPart.getName();
                Label additionalMsgLabel = new Label(comp, 0);
                additionalMsgLabel.setText(PICLLabels.ChangeTextFileDialog_msgobj390);
                additionalMsgLabel.setLayoutData((Object)new GridData(1, 1, true, false, 3, 1));
                Label additionalMsgText = new Label(comp, 131072);
                if (partName != null) {
                    additionalMsgText.setText(partName);
                }
                additionalMsgText.setLayoutData((Object)new GridData(1, 1, true, false, 3, 1));
            }
            catch (Exception parentPart) {
                // empty catch block
            }
        }
        this.fMsgLabel = new Label(comp, 0);
        this.fMsgLabel.setText(PICLLabels.ChangeTextFileDialog_msg);
        this.fMsgLabel.setLayoutData((Object)new GridData(1, 0, true, false, 3, 1));
        this.fNewTextFileCombo = new Combo(comp, 4);
        this.fNewTextFileCombo.setLayoutData((Object)new GridData(4, 1, true, false, 2, 1));
        IDialogSettings settings = this.getDialogSettings();
        if (settings != null && (history = settings.getArray(NEW_TEXT_FILE_NAME)) != null) {
            int i = 0;
            while (i < history.length) {
                this.fNewTextFileCombo.add(history[i]);
                ++i;
            }
        }
        if (this.fESV != null && this.fESV.getViewFile() != null && this.fESV.getViewFile().getFileName() != null) {
            this.fNewTextFileCombo.setText(this.fESV.getViewFile().getFileName());
        } else if (this.fESV != null && this.fESV.getViewFile() != null && this.fESV.getViewFile().getBaseFileName() != null) {
            this.fNewTextFileCombo.setText(this.fESV.getViewFile().getBaseFileName());
        }
        this.fNewTextFileCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                try {
                    if (ChangeTextFileDialog.this.fNewTextFileCombo.getText() == null || ChangeTextFileDialog.this.fNewTextFileCombo.getText().trim().equals("")) {
                        ChangeTextFileDialog.this.getButton(0).setEnabled(false);
                    } else {
                        ChangeTextFileDialog.this.getButton(0).setEnabled(true);
                    }
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
            }
        });
        this.fNewTextFileCombo.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                if (ChangeTextFileDialog.this.fNewTextFileCombo.getText() == null || ChangeTextFileDialog.this.fNewTextFileCombo.getText().trim().equals("")) {
                    ChangeTextFileDialog.this.getButton(0).setEnabled(false);
                } else {
                    ChangeTextFileDialog.this.getButton(0).setEnabled(true);
                }
            }
        });
        this.fBrowseButton = new Button(comp, 8);
        this.fBrowseButton.setText(PICLLabels.browse);
        this.fBrowseButton.setLayoutData((Object)new GridData(131072, 1, false, false));
        this.fBrowseButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                if (ChangeTextFileDialog.this.fRemoteBrowseDialog == null) {
                    ChangeTextFileDialog.this.fRemoteBrowseDialog = RSECommonPlugin.getRemoteBrowseDialog();
                }
                if (ChangeTextFileDialog.this.fRemoteBrowseDialog != null) {
                    String fullPath;
                    if (ChangeTextFileDialog.this.fRemoteBrowseDialog.open(false, null) != 1 && (fullPath = ChangeTextFileDialog.this.fRemoteBrowseDialog.getTempFileForSelection()) != null) {
                        ChangeTextFileDialog.this.fNewTextFileCombo.setText(fullPath);
                    }
                } else {
                    String fullPath;
                    FileDialog fileDialog = new FileDialog(CommonUtils.getShell());
                    if (ChangeTextFileDialog.this.fESV != null && ChangeTextFileDialog.this.fESV.getViewFile() != null) {
                        fileDialog.setFileName(ChangeTextFileDialog.this.fESV.getViewFile().getBaseFileName());
                    }
                    if ((fullPath = fileDialog.open()) != null) {
                        ChangeTextFileDialog.this.fNewTextFileCombo.setText(fullPath);
                    }
                }
            }
        });
        ChangeTextFileDialog.applyDialogFont((Control)comp);
        return comp;
    }

    @Override
    public void writeSettings() {
        IDialogSettings settings = this.getDialogSettings();
        String[] newArray = null;
        int index = this.fNewTextFileCombo.indexOf(this.fNewTextFileCombo.getText());
        if (index == -1) {
            if (this.fNewTextFileCombo.getItemCount() == 5) {
                newArray = new String[this.fNewTextFileCombo.getItemCount()];
                newArray[0] = this.fNewTextFileCombo.getText();
                int i = 0;
                while (i < this.fNewTextFileCombo.getItemCount() - 1) {
                    newArray[i + 1] = this.fNewTextFileCombo.getItem(i);
                    ++i;
                }
            } else {
                newArray = new String[this.fNewTextFileCombo.getItemCount() + 1];
                newArray[0] = this.fNewTextFileCombo.getText();
                int i = 0;
                while (i < this.fNewTextFileCombo.getItemCount()) {
                    newArray[i + 1] = this.fNewTextFileCombo.getItem(i);
                    ++i;
                }
            }
        } else {
            newArray = new String[this.fNewTextFileCombo.getItemCount()];
            newArray[0] = this.fNewTextFileCombo.getItem(index);
            int i = 0;
            while (i < this.fNewTextFileCombo.getItemCount()) {
                if (i < index) {
                    newArray[i + 1] = this.fNewTextFileCombo.getItem(i);
                } else if (i > index) {
                    newArray[i] = this.fNewTextFileCombo.getItem(i);
                }
                ++i;
            }
        }
        settings.put(NEW_TEXT_FILE_NAME, newArray);
    }

    private IDialogSettings getDialogSettings() {
        return this.getDialogBoundsSettings();
    }

    protected IDialogSettings getDialogBoundsSettings() {
        IDialogSettings settings = PICLDebugPlugin.getInstance().getDialogSettings();
        IDialogSettings section = settings.getSection(SETTINGSSECTION);
        if (section == null) {
            section = settings.addNewSection(SETTINGSSECTION);
        }
        return section;
    }
}

