/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.internal.ui.dialogs;

import com.ibm.debug.pdt.internal.core.PICLLabels;
import com.ibm.debug.pdt.internal.core.PICLMessages;
import com.ibm.debug.pdt.internal.core.model.AddressBreakpoint;
import com.ibm.debug.pdt.internal.core.model.AddressRangeBreakpoint;
import com.ibm.debug.pdt.internal.ui.PICLUtils;
import com.ibm.debug.pdt.internal.ui.dialogs.BreakpointWizardPage;
import com.ibm.debug.pdt.internal.ui.dialogs.ISettingsWriter;
import com.ibm.debug.pdt.internal.ui.util.DialogField;
import com.ibm.debug.pdt.internal.ui.util.IDialogFieldListener;
import com.ibm.debug.pdt.internal.ui.util.StringDialogField;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;

public class AddressBPWizardPage
extends BreakpointWizardPage
implements IDialogFieldListener,
ISettingsWriter {
    private StringDialogField addressField;
    private StringDialogField endAddressField;
    private StringDialogField fUserLabelField;
    private AddressBreakpoint fExistingBP = null;
    private boolean fIsRange;
    private static final String PAGE_NAME = "AddressBPWizard.page1";
    private static IDialogSettings section;
    private static final String ADDRESS = "Address";
    private static final String ADDRESS_RANGE_START = "AddressRangeStart";
    private static final String ADDRESS_RANGE_END = "AddressRangeEnd";

    protected AddressBPWizardPage(String pageName, String title, ImageDescriptor titleImage, AddressBreakpoint breakpoint, boolean isRange) {
        super(pageName, title, titleImage, null, breakpoint != null);
        this.fExistingBP = breakpoint;
        this.fIsRange = isRange || breakpoint instanceof AddressRangeBreakpoint;
        this.setDescription(isRange ? PICLLabels.AddressBPWizard_page1_description_range : PICLLabels.AddressBPWizard_page1_description);
    }

    private void initUsingOldBreakpoint() {
        if (this.fIsRange) {
            this.addressField.setText(this.clean(((AddressRangeBreakpoint)this.fExistingBP).getAddressStart()));
            this.endAddressField.setText(this.clean(((AddressRangeBreakpoint)this.fExistingBP).getAddressEnd()));
        } else {
            this.addressField.setText(this.fExistingBP.getAddress());
        }
        if (this.fExistingBP.getUserLabel() != null) {
            this.fUserLabelField.setText(this.fExistingBP.getUserLabel());
        }
    }

    private String clean(String address) {
        int idx;
        if (this.fExistingBP.getDebugEngine().getEngineSession().iszTPFengine() && address != null && (idx = address.indexOf(58)) > 0) {
            return address.substring(0, idx);
        }
        return address;
    }

    private void restoreSettings() {
        IDialogSettings dialogSettings;
        if (section == null && (section = (dialogSettings = this.getDialogSettings()).getSection(PAGE_NAME)) == null) {
            section = dialogSettings.addNewSection(PAGE_NAME);
        }
        if (this.fEditing) {
            this.initUsingOldBreakpoint();
            return;
        }
        if (this.fIsRange) {
            text = section.get(ADDRESS_RANGE_START);
            if (text != null) {
                this.addressField.setText(text);
            }
            if ((text = section.get(ADDRESS_RANGE_END)) != null) {
                this.endAddressField.setText(text);
            }
        } else {
            text = section.get(ADDRESS);
            if (text != null) {
                this.addressField.setText(text);
            }
        }
    }

    public void createControl(Composite parent) {
        int nColumns = 3;
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = nColumns;
        composite.setLayout((Layout)layout);
        this.setControl((Control)composite);
        this.addressField = new StringDialogField();
        String startLabel = this.fIsRange ? PICLLabels.AddressBPWizard_page1_start_addressLabel : PICLLabels.AddressBPWizard_page1_addressLabel;
        this.addressField.setLabelText(startLabel);
        this.addressField.setDialogFieldListener(this);
        this.addressField.doFillIntoGrid(composite, nColumns);
        if (this.fIsRange) {
            this.endAddressField = new StringDialogField();
            this.endAddressField.setLabelText(PICLLabels.AddressBPWizard_page1_end_addressLabel);
            this.endAddressField.setDialogFieldListener(this);
            this.endAddressField.doFillIntoGrid(composite, nColumns);
        }
        this.fUserLabelField = new StringDialogField();
        this.fUserLabelField.setLabelText(PICLLabels.AddressBPWizard_page1_userLabel);
        this.fUserLabelField.doFillIntoGrid(composite, nColumns);
        String helpID = this.fIsRange ? "address_range_bp_wizard" : "address_bp_wizard";
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, PICLUtils.getHelpResourceString(helpID));
        Dialog.applyDialogFont((Control)composite);
        this.restoreSettings();
    }

    @Override
    public void dialogFieldChanged(DialogField field) {
        this.setErrorMessage(null);
        if (this.fIsRange) {
            boolean endValid;
            boolean startHasInvalidChar = this.addressField != null && this.addressField.getText().contains(";");
            boolean endHasInvalidChar = this.endAddressField != null && this.endAddressField.getText().contains(";");
            boolean startValid = this.addressField != null && !this.addressField.getText().trim().isEmpty() && !startHasInvalidChar;
            boolean bl = endValid = this.endAddressField != null && !this.endAddressField.getText().trim().isEmpty() && !endHasInvalidChar;
            if (startHasInvalidChar || endHasInvalidChar) {
                this.setErrorMessage(NLS.bind((String)PICLMessages.CRRDG3258, (Object)";"));
            }
            this.setPageComplete(startValid && endValid);
        } else if (this.addressField.getText().equals("")) {
            this.setPageComplete(false);
        } else {
            this.setPageComplete(true);
        }
    }

    public String getAddress() {
        if (this.fIsRange) {
            return this.addressField.getText() + ";" + this.endAddressField.getText();
        }
        return this.addressField.getText();
    }

    @Override
    public void writeSettings() {
        if (this.fIsRange) {
            section.put(ADDRESS_RANGE_START, this.addressField.getText());
            section.put(ADDRESS_RANGE_END, this.endAddressField.getText());
        } else {
            section.put(ADDRESS, this.addressField.getText());
        }
    }

    public String getUserLabel() {
        return this.fUserLabelField.getText();
    }
}

