/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.internal.ui.dialogs;

import com.ibm.debug.pdt.core.PDTDebugUtils;
import com.ibm.debug.pdt.internal.core.PDTDebugTarget;
import com.ibm.debug.pdt.internal.core.PICLLabels;
import com.ibm.debug.pdt.internal.core.model.EventBreakpoint;
import com.ibm.debug.pdt.internal.epdc.EStdView;
import com.ibm.debug.pdt.internal.ui.PICLUtils;
import com.ibm.debug.pdt.internal.ui.dialogs.BreakpointWizardPage;
import com.ibm.debug.pdt.internal.ui.dialogs.ISettingsWriter;
import com.ibm.debug.pdt.internal.ui.util.IDialogFieldListener;
import com.ibm.debug.pdt.internal.ui.util.StringCombo;
import com.ibm.debug.pdt.internal.ui.util.StringDialogField;
import java.util.Vector;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;

public abstract class AbstractWatchBPWizardPage
extends BreakpointWizardPage
implements IDialogFieldListener,
ISettingsWriter {
    protected StringCombo fBytesToMonitorList;
    private boolean fMonitor0_128Bytes = false;
    private boolean fMonitor1Byte = false;
    private boolean fMonitor2Bytes = false;
    private boolean fMonitor4Bytes = false;
    private boolean fMonitor8Bytes = false;
    private boolean fMonitorAuto = false;
    private String fAutoMonitorString = null;
    private String[] fDefaultBytesToMonitor;
    protected StringDialogField fAddrOrExprField;
    protected StringDialogField fUserLabelField;

    public abstract void createControl(Composite var1);

    @Override
    public abstract void writeSettings();

    public AbstractWatchBPWizardPage(String pageName, String title, ImageDescriptor titleImage, PDTDebugTarget tgt, EventBreakpoint edit) {
        super(pageName, title, titleImage, tgt, edit != null);
        this.setMonitorCapabilities(tgt);
    }

    private void setMonitorCapabilities(PDTDebugTarget tgt) {
        this.fMonitor0_128Bytes = tgt.supportsAddrBkpMonitor_0_128Bytes();
        this.fMonitor1Byte = tgt.supportsAddrBkpMonitor_1Bytes();
        this.fMonitor2Bytes = tgt.supportsAddrBkpMonitor_2Bytes();
        this.fMonitor4Bytes = tgt.supportsAddrBkpMonitor_4Bytes();
        this.fMonitor8Bytes = tgt.supportsAddrBkpMonitor_8Bytes();
        this.fMonitorAuto = tgt.supportsAddrBkpMonitor_Auto();
        if (this.fMonitorAuto) {
            this.fAutoMonitorString = PICLLabels.picl_watch_BP_auto;
        }
        this.setDefaultBytesToMonitor();
    }

    private void setDefaultBytesToMonitor() {
        Vector<String> elements = new Vector<String>();
        if (this.fMonitorAuto) {
            elements.add(this.fAutoMonitorString);
        }
        if (this.fMonitor0_128Bytes) {
            int i = 1;
            if (this.fDebugTarget != null && PDTDebugUtils.isiSeriesEngine((IDebugTarget)this.fDebugTarget)) {
                i = 0;
            }
            while (i < 129) {
                elements.add(String.valueOf(i));
                ++i;
            }
        } else {
            if (this.fMonitor1Byte) {
                elements.add("1");
            }
            if (this.fMonitor2Bytes) {
                elements.add("2");
            }
            if (this.fMonitor4Bytes) {
                elements.add("4");
            }
            if (this.fMonitor8Bytes) {
                elements.add("8");
            }
        }
        this.fDefaultBytesToMonitor = elements.toArray(new String[elements.size()]);
    }

    protected String[] getDefaultBytesToMonitor() {
        return this.fDefaultBytesToMonitor;
    }

    protected void createAddrOrExprFieldAsChildWidget(Composite parent, int columns, String alternateLabel) {
        String label = alternateLabel == null ? PICLLabels.WatchBPWizard_page1_addressLabel : alternateLabel;
        this.fAddrOrExprField = this.putNewStringDialogFieldInComposite(label, parent, columns, true);
    }

    protected StringDialogField putNewStringDialogFieldInComposite(String title, Composite composite, int nColumns, boolean putInOneRow) {
        StringDialogField field = new StringDialogField(putInOneRow);
        field.setLabelText(title);
        field.setDialogFieldListener(this);
        field.doFillIntoGrid(composite, nColumns);
        return field;
    }

    protected void createAddAndPopulateBytesToMonitorListAsChildWidget(Composite parent, int columns, String alternateLabel) {
        String label = alternateLabel == null ? PICLLabels.WatchBPWizard_page1_byteLabel : alternateLabel;
        this.fBytesToMonitorList = this.putNewStringComboInComposite(label, parent, columns, false, false);
        this.populateByteList(this.fDefaultBytesToMonitor, -1);
    }

    protected StringCombo putNewStringComboInComposite(String title, Composite composite, int nColumns, boolean putInOneRow, boolean makeComboEditable) {
        StringCombo cb = new StringCombo(putInOneRow);
        cb.setLabelText(title);
        cb.setDialogFieldListener(this);
        cb.doFillIntoGrid(composite, nColumns, makeComboEditable);
        return cb;
    }

    protected void populateByteList(String[] bytesToMonitor, int indexOfDefault) {
        this.fBytesToMonitorList.setItems(bytesToMonitor);
        if (indexOfDefault < 0 || bytesToMonitor.length <= indexOfDefault) {
            this.setByteListDefault(bytesToMonitor);
        } else {
            this.fBytesToMonitorList.setTextWithoutUpdate(bytesToMonitor[indexOfDefault]);
        }
    }

    private void setByteListDefault(String[] bytesToMonitor) {
        if (this.fMonitorAuto) {
            this.fBytesToMonitorList.setTextWithoutUpdate(this.fAutoMonitorString);
        } else if (this.fMonitor0_128Bytes) {
            if (this.fDebugTarget != null && PDTDebugUtils.isiSeriesEngine((IDebugTarget)this.fDebugTarget)) {
                this.fBytesToMonitorList.setTextWithoutUpdate(bytesToMonitor[0]);
            } else {
                this.fBytesToMonitorList.setTextWithoutUpdate("4");
            }
        } else {
            this.fBytesToMonitorList.setTextWithoutUpdate(bytesToMonitor[bytesToMonitor.length - 1]);
        }
    }

    public int getNumBytes() {
        String value = this.fBytesToMonitorList.getText();
        if (this.fMonitorAuto && value.equals(this.fAutoMonitorString)) {
            return -1;
        }
        try {
            return Integer.parseInt(this.fBytesToMonitorList.getText());
        }
        catch (NumberFormatException e) {
            return -99;
        }
    }

    EStdView getEStdView() {
        return PICLUtils.getEStdViewForActiveEditor(this.fDebugTarget);
    }

    protected IDialogSettings getDialogSettings(String pageName) {
        IDialogSettings section = this.getDialogSettings().getSection(pageName);
        if (section == null) {
            section = this.getDialogSettings().addNewSection(pageName);
        }
        return section;
    }

    protected Composite putNewCompositeWithGridLayoutInParent(Composite parent, int columns) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = columns;
        composite.setLayout((Layout)layout);
        return composite;
    }

    protected void createUserLabelField(Composite parent, int columns) {
        this.fUserLabelField = this.putNewStringDialogFieldInComposite(PICLLabels.WatchBPWizard_page1_userLabel, parent, columns, true);
    }

    public String getUserLabel() {
        return this.fUserLabelField.getText();
    }
}

