/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.internal.ui.actions;

import com.ibm.debug.pdt.core.PDTDebugUtils;
import com.ibm.debug.pdt.core.breakpoints.PICLBaseBreakpoint;
import com.ibm.debug.pdt.core.breakpoints.PICLStopAtAllFunctionEntryBreakpoint;
import com.ibm.debug.pdt.internal.core.PDTDebugTarget;
import com.ibm.debug.pdt.internal.core.PICLLabels;
import com.ibm.debug.pdt.internal.ui.PICLDebugPlugin;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.jface.action.Action;

public class SpecialBreakpointActionDelegate
extends Action {
    public SpecialBreakpointActionDelegate(PDTDebugTarget target, boolean enabled) {
        this.initialize(target, enabled);
    }

    public void run() {
        final PDTDebugTarget dbgtgt = PICLDebugPlugin.getCurrentPDTDebugTarget();
        if (dbgtgt != null && dbgtgt.isAcceptingRequests() && dbgtgt.supportsEntryAutoSet()) {
            new Job("Set stop at all entry breakpoint"){

                protected IStatus run(IProgressMonitor monitor) {
                    PICLStopAtAllFunctionEntryBreakpoint bkp = PICLStopAtAllFunctionEntryBreakpoint.findBreakpoint((PDTDebugTarget)dbgtgt);
                    try {
                        if (bkp == null) {
                            IWorkspaceRoot resource = ResourcesPlugin.getWorkspace().getRoot();
                            new PICLStopAtAllFunctionEntryBreakpoint((IResource)resource, dbgtgt, true);
                        } else if (!bkp.isEnabled()) {
                            bkp.setEnabled(true);
                        } else {
                            bkp.delete();
                        }
                    }
                    catch (CoreException coreException) {
                        // empty catch block
                    }
                    return Status.OK_STATUS;
                }
            }.schedule();
        }
    }

    private void initialize(PDTDebugTarget target, boolean enabled) {
        this.setChecked((PICLBaseBreakpoint)PICLStopAtAllFunctionEntryBreakpoint.findBreakpoint((PDTDebugTarget)target));
        if (PDTDebugUtils.isiSeriesEngine((IDebugTarget)target) || target.isCOBOL() || target.isFORTRAN()) {
            this.setText(PICLLabels.StopAtAllEntryPointsAction_entry_label);
        } else {
            this.setText(PICLLabels.StopAtAllEntryPointsAction_label);
        }
        this.setId("com.ibm.debug.pdt.internal.ui.actions.SpecialBreakpointActionDelegate");
        this.setEnabled(enabled);
    }

    private void setChecked(PICLBaseBreakpoint breakpoint) {
        try {
            this.setChecked(breakpoint != null && breakpoint.isEnabled());
        }
        catch (CoreException e) {
            this.setChecked(false);
        }
    }
}

