/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.internal.ui.actions;

import com.ibm.debug.pdt.internal.common.CommonUtils;
import com.ibm.debug.pdt.internal.core.PDTDebugElement;
import com.ibm.debug.pdt.internal.core.PDTDebugTarget;
import com.ibm.debug.pdt.internal.core.PICLLabels;
import com.ibm.debug.pdt.internal.ui.PICLDebugTarget;
import com.ibm.debug.pdt.internal.ui.PICLUtils;
import com.ibm.debug.pdt.internal.ui.dialogs.FileFilterDialog;
import com.ibm.debug.pdt.internal.ui.views.ModulesView;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;

public class ShowFileFilterAction
extends Action
implements ISelectionListener {
    private ModulesView fModulesView;

    public ShowFileFilterAction(ModulesView mview) {
        super(PICLLabels.ShowFileFilterAction_label);
        this.setHoverImageDescriptor(PICLUtils.getImageDescriptor("PICL_ICON_CLCL_MONITOR_EXPRESSION"));
        this.setDisabledImageDescriptor(PICLUtils.getImageDescriptor("PICL_ICON_DLCL_MONITOR_EXPRESSION"));
        this.setImageDescriptor(PICLUtils.getImageDescriptor("PICL_ICON_ELCL_MONITOR_EXPRESSION"));
        this.setToolTipText(PICLLabels.ShowFileFilterAction_tooltip);
        this.setId("ShowFileFilterAction.");
        this.fModulesView = mview;
        IWorkbenchWindow window = mview.getViewSite().getWorkbenchWindow();
        window.getSelectionService().addSelectionListener("org.eclipse.debug.ui.DebugView", (ISelectionListener)this);
        PDTDebugTarget pdtarget = this.fModulesView.getCurrentDebugTarget();
        this.setEnabled(false);
        if (pdtarget != null && !pdtarget.isTerminated() && pdtarget.supportsGetList()) {
            this.setEnabled(true);
        }
        this.setActionDefinitionId("com.ibm.debug.pdt.ui.showFileFilterAction");
    }

    public void run() {
        IWorkbenchWindow dwindow = this.fModulesView.getViewSite().getWorkbenchWindow();
        if (dwindow == null) {
            return;
        }
        IWorkbenchPage page = dwindow.getActivePage();
        if (page == null) {
            return;
        }
        FileFilterDialog dialog = new FileFilterDialog(CommonUtils.getShell(), this.fModulesView.getCurrentDebugTarget(), page);
        dialog.open();
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        IDebugTarget dt;
        this.setEnabled(false);
        PICLDebugTarget piclDebugTarget = null;
        Object element = null;
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection strSelection = (IStructuredSelection)selection;
            element = strSelection.getFirstElement();
        } else {
            element = selection;
        }
        if (element instanceof PDTDebugElement) {
            piclDebugTarget = (PICLDebugTarget)((PDTDebugElement)element).getDebugTarget();
        } else if (element instanceof ILaunch && (dt = ((ILaunch)element).getDebugTarget()) instanceof PICLDebugTarget) {
            piclDebugTarget = (PICLDebugTarget)dt;
        }
        if (piclDebugTarget != null && !piclDebugTarget.isTerminated() && piclDebugTarget.supportsGetList()) {
            this.setEnabled(true);
        }
    }
}

