/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.internal.ui.actions;

import com.ibm.debug.pdt.internal.core.OptionalBreakpointData;
import com.ibm.debug.pdt.internal.core.PICLLabels;
import com.ibm.debug.pdt.internal.core.model.EngineRequestException;
import com.ibm.debug.pdt.internal.core.model.Function;
import com.ibm.debug.pdt.internal.ui.PICLDebugPlugin;
import com.ibm.debug.pdt.internal.ui.PICLUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.ui.PlatformUI;

public class SetFunctionBreakpointAction
extends Action {
    private TreeViewer fTreeViewer;

    public SetFunctionBreakpointAction(TreeViewer treeViewer) {
        super(PICLLabels.SetFunctionBreakpointAction_label_entry);
        this.fTreeViewer = treeViewer;
        this.setImageDescriptor(PICLUtils.getImageDescriptor("PICL_ICON_ACTIVE_BREAKPOINT"));
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, PICLUtils.getHelpResourceString("add_function_breakpoint_action"));
    }

    public void run() {
        final StructuredSelection sel = (StructuredSelection)this.fTreeViewer.getSelection();
        Job job = new Job("SetFunctionBreakpointAction"){

            protected IStatus run(IProgressMonitor monitor) {
                if (sel != StructuredSelection.EMPTY && sel.size() == 1 && sel.getFirstElement() instanceof Function) {
                    Function function = (Function)sel.getFirstElement();
                    SetFunctionBreakpointAction.this.setEntryBreakpoint(function);
                }
                return Status.OK_STATUS;
            }
        };
        job.setSystem(true);
        job.schedule();
    }

    private void setEntryBreakpoint(Function fnc) {
        try {
            fnc.setBreakpoint(true, true, new OptionalBreakpointData(fnc.getEngineSession()));
        }
        catch (EngineRequestException e) {
            PICLDebugPlugin.showMessageDialog(null, e.getMessage(), false);
        }
    }

    public void updateHelp() {
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, PICLUtils.getHelpResourceString("add_function_breakpoint_action"));
    }
}

