/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.internal.ui.actions;

import com.ibm.debug.pdt.internal.core.PDTDebugTarget;
import com.ibm.debug.pdt.internal.core.model.EngineRequestException;
import com.ibm.debug.pdt.internal.core.model.ExprNodeBase;
import com.ibm.debug.pdt.internal.core.model.ExpressionBase;
import com.ibm.debug.pdt.internal.core.model.Language;
import com.ibm.debug.pdt.internal.core.model.Representation;
import com.ibm.debug.pdt.internal.core.model.Type;
import com.ibm.debug.pdt.internal.ui.PICLDebugPlugin;
import com.ibm.debug.pdt.internal.ui.actions.ChangeRepresentationAction;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.eclipse.debug.ui.AbstractDebugView;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;

public class SetDefaultRepresentationDelegate
implements IObjectActionDelegate {
    private IMenuManager fMenuManager = null;
    private ExprNodeBase fCurrentElement;

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
        AbstractDebugView adv;
        List managers;
        this.fMenuManager = null;
        if (targetPart instanceof AbstractDebugView && (managers = (adv = (AbstractDebugView)targetPart).getContextMenuManagers()) != null && !managers.isEmpty()) {
            Iterator iter = managers.iterator();
            while (iter.hasNext() && this.fMenuManager == null) {
                this.fMenuManager = ((IMenuManager)iter.next()).findMenuUsingPath("com.ibm.debug.pdt.ui.actions.ChangeRepresentation.menu");
            }
        }
    }

    public void run(IAction action) {
        int languageID = this.fCurrentElement.getLanguageID();
        int typeIndex = this.fCurrentElement.getTypeIndex();
        if (languageID != 0) {
            PDTDebugTarget dt = (PDTDebugTarget)this.fCurrentElement.getDebugTarget();
            Language lang = dt.getDebugEngine().getLanguageInfo(languageID);
            if (lang == null) {
                return;
            }
            Type type = lang.getType(typeIndex);
            if (type == null) {
                return;
            }
            try {
                type.setDefaultRepresentation(this.fCurrentElement.getCurrentRepresentation());
            }
            catch (EngineRequestException e) {
                PICLDebugPlugin.showMessageDialog(null, e.getMessage(), true);
            }
        } else {
            return;
        }
    }

    private boolean variableSupportsRepresentation(ExprNodeBase var, Representation rep) {
        Representation[] varReps = var.getRepresentations();
        int i = 0;
        while (i < varReps.length) {
            if (varReps[i] == rep) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void selectionChanged(IAction action, ISelection selection) {
        action.setEnabled(false);
        if (!(selection instanceof IStructuredSelection)) {
            return;
        }
        IStructuredSelection selectedVar = (IStructuredSelection)selection;
        if (selectedVar.isEmpty()) {
            return;
        }
        Vector<Object> allVars = new Vector<Object>(25);
        HashSet<Object> commonReps = new HashSet<Object>(10);
        if (selectedVar.size() == 1) {
            int languageID;
            Object sel = selectedVar.getFirstElement();
            if (!(sel instanceof ExprNodeBase)) {
                return;
            }
            ExprNodeBase var = (ExprNodeBase)sel;
            ExpressionBase expressionBase = var.getExpression();
            if (expressionBase.isDeferred() || !expressionBase.isEnabled()) {
                return;
            }
            Representation[] currentReps = var.getRepresentations();
            if (currentReps.length == 0) {
                return;
            }
            i = 0;
            while (i < currentReps.length) {
                commonReps.add(currentReps[i]);
                ++i;
            }
            allVars.add(var);
            if (currentReps.length > 1 && (languageID = expressionBase.getRootNode().getLanguageID()) != 0) {
                action.setEnabled(true);
                this.fCurrentElement = var;
            }
        } else {
            Representation[] allRepresentations = null;
            for (Object sel : selectedVar) {
                if (!(sel instanceof ExprNodeBase)) {
                    return;
                }
                ExprNodeBase var = (ExprNodeBase)sel;
                if (!var.getExpression().isEnabled() || var.getExpression().isDeferred()) {
                    return;
                }
                allVars.add(sel);
                if (allRepresentations != null || (allRepresentations = var.getDebugEngine().getRepresentations()).length > 0) continue;
                return;
            }
            if (allRepresentations == null) {
                return;
            }
            i = 0;
            while (i < allRepresentations.length) {
                boolean supportedByAllVars = true;
                int j = 0;
                while (j < allVars.size()) {
                    if (!this.variableSupportsRepresentation((ExprNodeBase)allVars.elementAt(j), (Representation)allRepresentations[i])) {
                        supportedByAllVars = false;
                        break;
                    }
                    ++j;
                }
                if (supportedByAllVars) {
                    commonReps.add(allRepresentations[i]);
                }
                ++i;
            }
        }
        int mnemonicIndex = 0;
        for (Representation representation : commonReps) {
            ExprNodeBase var;
            ChangeRepresentationAction repAction = new ChangeRepresentationAction(allVars.toArray(), representation, mnemonicIndex);
            if (allVars.size() == 1 && (var = (ExprNodeBase)allVars.get(0)).getCurrentRepresentation().equals((Object)representation)) {
                repAction.setChecked(true);
            }
            if (this.fMenuManager != null) {
                this.fMenuManager.insertBefore("changeRepresentation", (IAction)repAction);
            }
            ++mnemonicIndex;
        }
    }
}

