/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.internal.ui.actions;

import com.ibm.debug.pdt.internal.core.PICLLabels;
import com.ibm.debug.pdt.internal.ui.PICLUtils;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.printing.PrintDialog;
import org.eclipse.swt.printing.Printer;
import org.eclipse.swt.printing.PrinterData;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.PlatformUI;

public class PrintTreeViewAction
extends Action {
    protected StructuredViewer fViewer;
    protected String printJobTitle;

    public PrintTreeViewAction(StructuredViewer viewer, String pJobTitle) {
        super(PICLLabels.PrintViewAction_label);
        this.setToolTipText(PICLLabels.PrintViewAction_tooltip);
        this.fViewer = viewer;
        this.printJobTitle = pJobTitle;
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, PICLUtils.getHelpResourceString("print_view_action"));
    }

    private int printTree(TreeItem[] itemList, int treeDepth, int lineNum, GC printGC, Printer printer) {
        if (itemList.length == 0) {
            return lineNum;
        }
        int i = 0;
        while (i < itemList.length) {
            if (!itemList[i].getText().equals("")) {
                if (20 + ++lineNum * printGC.getFontMetrics().getHeight() > printer.getClientArea().height) {
                    lineNum = 0;
                    printer.endPage();
                    printer.startPage();
                }
                printGC.drawString(itemList[i].getText(), 10 + (int)((double)(2 * treeDepth) * printGC.getFontMetrics().getAverageCharacterWidth()), 10 + lineNum * printGC.getFontMetrics().getHeight());
                lineNum = this.printTree(itemList[i].getItems(), treeDepth + 1, lineNum, printGC, printer);
            }
            ++i;
        }
        return lineNum;
    }

    public void run() {
        PrintDialog printDialog = new PrintDialog(this.fViewer.getControl().getDisplay().getActiveShell());
        PrinterData printerData = printDialog.open();
        if (printerData == null) {
            this.setChecked(false);
            return;
        }
        Printer printer = new Printer(printerData);
        GC gc = new GC((Drawable)printer);
        TreeItem[] treeItems = ((Tree)this.fViewer.getControl()).getItems();
        printer.startJob(this.printJobTitle);
        printer.startPage();
        this.printTree(treeItems, 0, 0, gc, printer);
        printer.endPage();
        printer.endJob();
        gc.dispose();
        printer.dispose();
        this.setChecked(false);
    }

    public void setChecked(boolean value) {
        super.setChecked(value);
    }
}

