/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.internal.ui.actions;

import com.ibm.debug.pdt.internal.common.CommonUtils;
import com.ibm.debug.pdt.internal.core.PDTDebugTarget;
import com.ibm.debug.pdt.internal.core.PICLLabels;
import com.ibm.debug.pdt.internal.core.model.DebuggeeThread;
import com.ibm.debug.pdt.internal.ui.PICLDebugPlugin;
import com.ibm.debug.pdt.internal.ui.PICLUtils;
import com.ibm.debug.pdt.internal.ui.dialogs.MonitorExpressionDialog;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.contexts.DebugContextEvent;
import org.eclipse.debug.ui.contexts.IDebugContextListener;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class MonitorExpressionAction
extends Action
implements IDebugContextListener {
    protected static final String PREFIX = "MonitorExpressionAction.";
    private DebuggeeThread fThread = null;

    public MonitorExpressionAction(boolean defaultIsStorageMonitor, IWorkbenchWindow window) {
        super(PICLLabels.MonitorExpressionAction_label);
        this.setToolTipText(PICLLabels.MonitorExpressionAction_tooltip);
        DebugUITools.getDebugContextManager().addDebugContextListener((IDebugContextListener)this);
        ISelection selection = window.getSelectionService().getSelection("org.eclipse.debug.ui.DebugView");
        this.setEnabled(this.checkValidSelection(selection));
        this.setActionDefinitionId("com.ibm.debug.pdt.ui.monitorExpressionAction");
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, PICLUtils.getHelpResourceString("monitor_expression_action"));
    }

    public void run() {
        if (this.fThread == null || !this.fThread.isSuspended()) {
            return;
        }
        MonitorExpressionDialog dialog = new MonitorExpressionDialog(CommonUtils.getShell(), this.fThread);
        dialog.open();
    }

    public void debugContextChanged(DebugContextEvent event) {
        ISelection selection = event.getContext();
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, PICLUtils.getHelpResourceString("monitor_expression_action"));
        this.fThread = null;
        this.setEnabled(this.checkValidSelection(selection));
    }

    private boolean checkValidSelection(ISelection selection) {
        this.fThread = PICLDebugPlugin.getThread(selection);
        if (this.fThread == null || !this.fThread.isSuspended() || !(this.fThread.getDebugTarget() instanceof PDTDebugTarget)) {
            return false;
        }
        return ((PDTDebugTarget)this.fThread.getDebugTarget()).supportsMonitoringExpressions();
    }
}

