/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.internal.ui.actions;

import com.ibm.debug.pdt.core.breakpoints.GenericLineBreakpoint;
import com.ibm.debug.pdt.core.breakpoints.PICLBreakpoint;
import com.ibm.debug.pdt.core.breakpoints.PICLSourceLineBreakpoint;
import com.ibm.debug.pdt.internal.core.PDTDebugTarget;
import com.ibm.debug.pdt.internal.core.PICLLabels;
import com.ibm.debug.pdt.internal.core.model.AddressBreakpoint;
import com.ibm.debug.pdt.internal.core.model.Breakpoint;
import com.ibm.debug.pdt.internal.core.model.EntryBreakpoint;
import com.ibm.debug.pdt.internal.core.model.LineBreakpoint;
import com.ibm.debug.pdt.internal.core.model.MacroBreakpoint;
import com.ibm.debug.pdt.internal.ui.PICLUtils;
import com.ibm.debug.pdt.internal.ui.actions.EditorBreakpointAction;
import com.ibm.debug.pdt.internal.ui.dialogs.AddressBPWizard;
import com.ibm.debug.pdt.internal.ui.dialogs.BreakpointWizard;
import com.ibm.debug.pdt.internal.ui.dialogs.DebugWizardDialog;
import com.ibm.debug.pdt.internal.ui.dialogs.EntryBPWizard;
import com.ibm.debug.pdt.internal.ui.dialogs.GenericLineBPWizard;
import com.ibm.debug.pdt.internal.ui.dialogs.LineBPWizard;
import com.ibm.debug.pdt.internal.ui.dialogs.MacroBreakpointWizard;
import com.ibm.debug.pdt.internal.ui.dialogs.SourceLineBPWizard;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IMarker;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.text.source.IVerticalRulerInfo;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.IUpdate;

public class EditorEditBreakpointAction
extends EditorBreakpointAction
implements IUpdate {
    public EditorEditBreakpointAction(ITextEditor editor, IVerticalRulerInfo rulerInfo, String initialLabel, boolean setAsRulerAction) {
        super(editor, rulerInfo, initialLabel, setAsRulerAction, false);
        this.setText(PICLLabels.EditBreakpointAction_label);
    }

    @Override
    public void update() {
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, PICLUtils.getHelpResourceString("edit_breakpoint_action"));
        List<IMarker> allBreakpoints = this.getMarkers();
        if (allBreakpoints == null || allBreakpoints.isEmpty()) {
            this.setEnabled(false);
            return;
        }
        boolean canEdit = false;
        Iterator<IMarker> iter = allBreakpoints.iterator();
        IBreakpoint iBP = null;
        IMarker marker = null;
        while (iter.hasNext()) {
            marker = iter.next();
            iBP = this.getBreakpointManager().getBreakpoint(marker);
            if (iBP instanceof PICLBreakpoint) {
                PDTDebugTarget dbgtgt = ((PICLBreakpoint)iBP).getDebugTarget();
                if (dbgtgt == null || !dbgtgt.supportsModifyingBreakpoints() || ((PICLBreakpoint)iBP).isReadOnly()) continue;
                canEdit = true;
                break;
            }
            if (!(iBP instanceof PICLSourceLineBreakpoint) && !(iBP instanceof GenericLineBreakpoint)) continue;
            canEdit = true;
            break;
        }
        this.setEnabled(canEdit);
    }

    @Override
    public boolean showAction() {
        return !this.getMarkers().isEmpty();
    }

    @Override
    public void run() {
        List<IMarker> allBreakpoints = this.getMarkers();
        if (allBreakpoints == null || allBreakpoints.isEmpty()) {
            return;
        }
        Iterator<IMarker> iter = allBreakpoints.iterator();
        IBreakpoint iBP = null;
        IMarker marker = null;
        while (iter.hasNext()) {
            marker = iter.next();
            iBP = this.getBreakpointManager().getBreakpoint(marker);
            PDTDebugTarget dbgtgt = null;
            Breakpoint modelBP = null;
            if (iBP instanceof PICLBreakpoint) {
                dbgtgt = ((PICLBreakpoint)iBP).getDebugTarget();
                if (dbgtgt == null || !dbgtgt.supportsModifyingBreakpoints() || ((PICLBreakpoint)iBP).isReadOnly()) continue;
                modelBP = ((PICLBreakpoint)iBP).getModelBreakpoint();
            }
            BreakpointWizard wizard = null;
            if (iBP instanceof PICLSourceLineBreakpoint) {
                wizard = new SourceLineBPWizard((GenericLineBreakpoint)((PICLSourceLineBreakpoint)iBP));
            } else if (iBP instanceof GenericLineBreakpoint) {
                wizard = new GenericLineBPWizard((GenericLineBreakpoint)iBP);
            } else if (modelBP instanceof LineBreakpoint) {
                wizard = new LineBPWizard(dbgtgt, (LineBreakpoint)modelBP);
            } else if (modelBP instanceof AddressBreakpoint) {
                wizard = new AddressBPWizard(dbgtgt, (AddressBreakpoint)modelBP);
            } else if (modelBP instanceof MacroBreakpoint) {
                wizard = new MacroBreakpointWizard(dbgtgt, (MacroBreakpoint)modelBP);
            } else if (modelBP instanceof EntryBreakpoint) {
                wizard = new EntryBPWizard(dbgtgt, (EntryBreakpoint)modelBP);
            }
            if (wizard == null) continue;
            Shell shell = PlatformUI.getWorkbench().getDisplay().getActiveShell();
            DebugWizardDialog dialog = new DebugWizardDialog(shell, (IWizard)wizard);
            dialog.create();
            dialog.open();
        }
    }
}

