/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.internal.ui.actions;

import com.ibm.debug.pdt.internal.core.PICLLabels;
import com.ibm.debug.pdt.internal.core.model.ExprNodeBase;
import com.ibm.debug.pdt.internal.ui.PICLDebugPlugin;
import com.ibm.debug.pdt.internal.ui.PICLUtils;
import com.ibm.debug.pdt.rsecommon.IInlineVariableTreeEditor;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IValueModification;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.SelectionProviderAction;

public class EditValueAction
extends SelectionProviderAction {
    public static final int LONG_VALUE_LENGTH = 25;
    protected Tree fTree;

    public EditValueAction(Viewer viewer) {
        super((ISelectionProvider)viewer, PICLLabels.EditValueAction_menuItem);
        this.fTree = ((TreeViewer)viewer).getTree();
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, PICLUtils.getHelpResourceString("edit_value_action"));
    }

    public void run() {
        IVariable variable = this.getVariable(this.getStructuredSelection());
        if (variable == null) {
            return;
        }
        String valueString = "";
        try {
            valueString = variable.getValue().getValueString();
        }
        catch (DebugException debugException) {
            // empty catch block
        }
        if (variable instanceof ExprNodeBase && valueString.length() > 25) {
            Dialog dialog = PICLDebugPlugin.getEditWidgetFactory().getVariableEditDialog(this.fTree.getShell(), variable);
            dialog.open();
        } else {
            try {
                IInlineVariableTreeEditor inlineEditor = PICLDebugPlugin.getEditWidgetFactory().getInlineVariableTreeEditor();
                inlineEditor.editVariable(this.fTree, variable);
            }
            catch (Exception e) {
                PICLUtils.logError(e);
            }
        }
    }

    public void selectionChanged(IStructuredSelection sel) {
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, PICLUtils.getHelpResourceString("edit_value_action"));
        this.setEnabled(this.getVariable(sel) != null);
    }

    private IVariable getVariable(IStructuredSelection selection) {
        IValueModification varMod;
        if (selection == null || selection.size() > 1) {
            return null;
        }
        Object element = selection.getFirstElement();
        if (element instanceof IValueModification && (varMod = (IValueModification)element).supportsValueModification()) {
            return (IVariable)varMod;
        }
        return null;
    }
}

