/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.internal.ui.actions;

import com.ibm.debug.pdt.internal.core.PICLLabels;
import com.ibm.debug.pdt.internal.core.PICLMessages;
import com.ibm.debug.pdt.internal.ui.PICLUtils;
import com.ibm.debug.pdt.internal.ui.actions.DebugConsoleViewAction;
import com.ibm.debug.pdt.internal.ui.views.DebugConsoleView;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import org.eclipse.jface.action.IAction;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class DebugConsoleViewExportCommandHistoryAction
extends DebugConsoleViewAction {
    public DebugConsoleViewExportCommandHistoryAction(DebugConsoleView aView) {
        super(aView, PICLLabels.DebugConsoleViewExportCommandHistoryAction_label);
        this.setToolTipText(PICLLabels.DebugConsoleViewExportCommandHistoryAction_tooltip);
        this.setImageDescriptor(PICLUtils.getImageDescriptor("PICL_ICON_ELCL_DEBUGCONSOLE_EXPORT_HISTORY"));
        this.setDisabledImageDescriptor(PICLUtils.getImageDescriptor("PICL_ICON_DLCL_DEBUGCONSOLE_EXPORT_HISTORY"));
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, PICLUtils.getHelpResourceString("export_command_action"));
    }

    public void run() {
        this.getDebugConsoleView().exportCommandHistory();
    }

    public void doExport(Shell parent, String commandHistory) {
        String fSavePath;
        MessageBox mb;
        if (commandHistory == null || commandHistory.length() == 0) {
            return;
        }
        FileDialog fSaveDialog = new FileDialog(parent, 8192);
        do {
            if ((fSavePath = fSaveDialog.open()) == null) {
                return;
            }
            File file = new File(fSavePath);
            if (!file.exists()) break;
            mb = new MessageBox(fSaveDialog.getParent(), 200);
            mb.setMessage(NLS.bind((String)PICLMessages.DebugConsoleViewOverwritePrompt, (Object)fSavePath));
            mb.setText(PICLLabels.DebugConsoleViewExportMBTitle);
        } while (mb.open() != 64);
        try {
            Throwable throwable = null;
            Object var6_8 = null;
            try (FileWriter writer = new FileWriter(fSavePath, false);){
                writer.write(commandHistory);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

