/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.internal.ui.actions;

import com.ibm.debug.pdt.internal.common.CommonUtils;
import com.ibm.debug.pdt.internal.core.PICLLabels;
import com.ibm.debug.pdt.internal.ui.EngineSuppliedViewEditorInput;
import com.ibm.debug.pdt.internal.ui.PICLUtils;
import com.ibm.debug.pdt.internal.ui.dialogs.ChangeTextFileDialog;
import com.ibm.debug.pdt.internal.ui.editor.DebuggerEditor;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.IUpdate;

public class ChangeTextFileAction
extends Action
implements IUpdate {
    private ITextEditor fEditor = null;
    private IAction fDelegatedAction = null;

    public ChangeTextFileAction(IAction action, ITextEditor editor) {
        super(PICLLabels.ChangeTextFileAction_label);
        this.fDelegatedAction = action;
        this.fEditor = editor;
        if (this.fDelegatedAction != null) {
            this.fDelegatedAction.setText(this.getText());
            this.fDelegatedAction.setEnabled(this.isEnabled());
        }
        this.update();
    }

    public void run() {
        ChangeTextFileDialog dialog = null;
        if (this.fEditor != null && this.fEditor.getEditorInput() instanceof EngineSuppliedViewEditorInput) {
            dialog = new ChangeTextFileDialog(CommonUtils.getShell(), (EngineSuppliedViewEditorInput)this.fEditor.getEditorInput());
        }
        int dialogResult = 1;
        if (dialog != null) {
            dialogResult = dialog.open();
        }
        if (dialogResult == 0 && this.fEditor instanceof DebuggerEditor) {
            try {
                final DebuggerEditor dbgEditor = (DebuggerEditor)this.fEditor;
                final IMarker[] locationMarker = new IMarker[1];
                ResourcesPlugin.getWorkspace().run(new IWorkspaceRunnable(){

                    public void run(IProgressMonitor monitor) throws CoreException {
                        locationMarker[0] = ResourcesPlugin.getWorkspace().getRoot().createMarker("com.ibm.debug.pdt.PICLLocationMarker");
                        locationMarker[0].setAttribute("lineNumber", dbgEditor.getCurrentExecutionPointLineNumber());
                    }
                }, null, 1, null);
                dbgEditor.gotoMarker(locationMarker[0]);
            }
            catch (CoreException coreException) {
                // empty catch block
            }
        }
    }

    public void update() {
        String helpID = PICLUtils.getHelpResourceString("change_text_file_action");
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, helpID);
        if (this.fDelegatedAction != null) {
            PlatformUI.getWorkbench().getHelpSystem().setHelp(this.fDelegatedAction, helpID);
        }
    }
}

