/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.internal.ui.actions;

import com.ibm.debug.pdt.internal.common.CommonUtils;
import com.ibm.debug.pdt.internal.core.PICLMessages;
import com.ibm.debug.pdt.internal.core.PICLRegister;
import com.ibm.debug.pdt.internal.core.model.DebuggeeThread;
import com.ibm.debug.pdt.internal.core.model.EngineRequestException;
import com.ibm.debug.pdt.internal.core.model.Location;
import com.ibm.debug.pdt.internal.ui.PICLDebugPlugin;
import com.ibm.debug.pdt.internal.ui.PICLUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IRegister;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;

public class AddRegisterMonitorActionDelegate
implements IObjectActionDelegate {
    ISelection fCurrentSelection;
    Display fDisplay = null;

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
        try {
            this.fDisplay = targetPart.getSite().getWorkbenchWindow().getWorkbench().getDisplay();
        }
        catch (NullPointerException npe) {
            this.fDisplay = null;
        }
    }

    public void run(IAction arg0) {
        Job monitorRegisterJob = new Job("Monitor Register"){

            protected IStatus run(IProgressMonitor monitor) {
                if (AddRegisterMonitorActionDelegate.this.fCurrentSelection instanceof IStructuredSelection) {
                    boolean atLeastOneSuccess = false;
                    for (Object selection : (IStructuredSelection)AddRegisterMonitorActionDelegate.this.fCurrentSelection) {
                        if (!(selection instanceof PICLRegister) || !AddRegisterMonitorActionDelegate.this.monitorRegister((IRegister)((PICLRegister)selection), (DebuggeeThread)((PICLRegister)selection).getThread())) continue;
                        atLeastOneSuccess = true;
                    }
                    if (atLeastOneSuccess && AddRegisterMonitorActionDelegate.this.fDisplay != null) {
                        AddRegisterMonitorActionDelegate.this.fDisplay.asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                CommonUtils.showView((String)"com.ibm.debug.pdt.ui.MonitorView");
                            }
                        });
                    }
                }
                return Status.OK_STATUS;
            }
        };
        monitorRegisterJob.schedule();
    }

    private boolean monitorRegister(IRegister register, DebuggeeThread threadContext) {
        String expression = "";
        try {
            expression = register.getName();
        }
        catch (DebugException e) {
            PICLDebugPlugin.showMessageDialog(null, PICLMessages.AddRegisterMonitorAction_error_invalid_name, true);
            return false;
        }
        Location location = threadContext.getLocation();
        try {
            threadContext.monitorExpression(location, expression);
            return true;
        }
        catch (EngineRequestException e) {
            PICLDebugPlugin.showMessageDialog(null, e.getMessage(), true);
            return false;
        }
    }

    public void selectionChanged(IAction proxyAction, ISelection selection) {
        this.fCurrentSelection = selection;
        if (this.fCurrentSelection instanceof IStructuredSelection && ((IStructuredSelection)this.fCurrentSelection).size() == 1) {
            Object register = ((IStructuredSelection)this.fCurrentSelection).getFirstElement();
            if (register instanceof IRegister) {
                proxyAction.setEnabled(true);
                PlatformUI.getWorkbench().getHelpSystem().setHelp(proxyAction, PICLUtils.getHelpResourceString("add_register_monitor_action"));
            }
        } else {
            proxyAction.setEnabled(false);
        }
    }
}

