/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.internal.ui.actions;

import com.ibm.debug.pdt.internal.common.CommonUtils;
import com.ibm.debug.pdt.internal.core.PDTDebugTarget;
import com.ibm.debug.pdt.internal.core.PICLLabels;
import com.ibm.debug.pdt.internal.ui.PICLDebugPlugin;
import com.ibm.debug.pdt.internal.ui.PICLUtils;
import com.ibm.debug.pdt.internal.ui.dialogs.BreakpointWizard;
import com.ibm.debug.pdt.internal.ui.dialogs.DebugWizardDialog;
import com.ibm.debug.pdt.internal.ui.dialogs.EnhancedWatchBPWizard;
import com.ibm.debug.pdt.internal.ui.dialogs.WatchBPWizard;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.texteditor.IUpdate;

public class AddEditorWatchBreakpointAction
extends Action
implements IUpdate {
    public AddEditorWatchBreakpointAction() {
        super(PICLLabels.AddWatchBreakpointAction_label);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, PICLUtils.getHelpResourceString("add_watch_breakpoint_action"));
    }

    public void run() {
        PDTDebugTarget tgt = PICLDebugPlugin.getCurrentPDTDebugTarget();
        if (tgt == null || tgt.isTerminated()) {
            return;
        }
        if (tgt.supportsEnhancedWatchpointBreakpoints()) {
            EnhancedWatchBPWizard wizard = new EnhancedWatchBPWizard(tgt);
            this.runWizard(wizard);
        } else {
            WatchBPWizard wizard = new WatchBPWizard(tgt);
            this.runWizard(wizard);
        }
    }

    private void runWizard(BreakpointWizard wizard) {
        if (wizard == null) {
            return;
        }
        DebugWizardDialog dialog = new DebugWizardDialog(CommonUtils.getShell(), (IWizard)wizard);
        dialog.create();
        dialog.open();
    }

    public void update() {
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, PICLUtils.getHelpResourceString("add_watch_breakpoint_action"));
    }
}

