/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.internal.ui;

import com.ibm.debug.daemon.CoreDaemon;
import com.ibm.debug.daemon.IDaemonDebugTarget2;
import com.ibm.debug.pdt.core.IProcessListSupplier;
import com.ibm.debug.pdt.core.ISourceBreakpointAdapter;
import com.ibm.debug.pdt.core.ProcessDetail;
import com.ibm.debug.pdt.core.ProcessList;
import com.ibm.debug.pdt.core.breakpoints.PICLBaseBreakpoint;
import com.ibm.debug.pdt.core.breakpoints.PICLBreakpoint;
import com.ibm.debug.pdt.core.breakpoints.PICLStopAtAllFunctionEntryBreakpoint;
import com.ibm.debug.pdt.core.breakpoints.PICLZeroAddressBreakpoint;
import com.ibm.debug.pdt.internal.common.CommonUtils;
import com.ibm.debug.pdt.internal.core.EngineParameters;
import com.ibm.debug.pdt.internal.core.OptionalBreakpointData;
import com.ibm.debug.pdt.internal.core.PDTCorePlugin;
import com.ibm.debug.pdt.internal.core.PDTDebugTarget;
import com.ibm.debug.pdt.internal.core.PICLLabels;
import com.ibm.debug.pdt.internal.core.PICLMessages;
import com.ibm.debug.pdt.internal.core.launch.PICLAbstractStartupInfo;
import com.ibm.debug.pdt.internal.core.model.DebuggeePrepareOptions;
import com.ibm.debug.pdt.internal.core.model.DebuggeeProcess;
import com.ibm.debug.pdt.internal.core.model.DebuggeeStartupOptions;
import com.ibm.debug.pdt.internal.core.model.DebuggeeThread;
import com.ibm.debug.pdt.internal.core.model.EngineRequestException;
import com.ibm.debug.pdt.internal.core.model.ErrorOccurredEvent;
import com.ibm.debug.pdt.internal.core.model.LineBreakpoint;
import com.ibm.debug.pdt.internal.core.model.Location;
import com.ibm.debug.pdt.internal.core.model.MessageReceivedEvent;
import com.ibm.debug.pdt.internal.core.model.ModelStateReadyEvent;
import com.ibm.debug.pdt.internal.core.model.Part;
import com.ibm.debug.pdt.internal.core.model.ProcessAddedEvent;
import com.ibm.debug.pdt.internal.core.model.ProcessListColumnDetails;
import com.ibm.debug.pdt.internal.core.model.ProcessStoppedEvent;
import com.ibm.debug.pdt.internal.core.model.SystemProcess;
import com.ibm.debug.pdt.internal.core.model.ThreadStoppedEvent;
import com.ibm.debug.pdt.internal.core.model.ViewFile;
import com.ibm.debug.pdt.internal.core.model.ViewInformation;
import com.ibm.debug.pdt.internal.core.util.PDTCoreUtils;
import com.ibm.debug.pdt.internal.epdc.EPDC_EngineSession;
import com.ibm.debug.pdt.internal.epdc.ProcessStopInfo;
import com.ibm.debug.pdt.internal.ui.PICLDebugPlugin;
import com.ibm.debug.pdt.internal.ui.PICLUtils;
import com.ibm.debug.pdt.internal.ui.dialogs.AuthenticateDialog;
import com.ibm.debug.pdt.internal.ui.dialogs.EventDialog;
import com.ibm.debug.pdt.internal.ui.dialogs.ExceptionDialog;
import com.ibm.debug.pdt.internal.ui.dialogs.ForkDialog;
import com.ibm.debug.pdt.internal.ui.dialogs.NewProcessDialog;
import com.ibm.debug.pdt.internal.ui.dialogs.SourceLineBPInfoDialog;
import com.ibm.debug.pdt.internal.ui.memory.PICLExtendedMemoryBlockRetrieval;
import com.ibm.debug.pdt.internal.ui.memory.PICLMemoryBlock;
import com.ibm.debug.pdt.internal.ui.preferences.PreferenceUI;
import com.ibm.debug.pdt.internal.ui.preferences.PreferenceUIChangeListener;
import com.ibm.debug.pdt.internal.ui.team.ITeamDebugSupport;
import com.ibm.debug.pdt.internal.ui.team.TeamDebugSupportProxy;
import com.ibm.debug.pdt.internal.ui.util.DebugConsoleUtils;
import com.ibm.debug.pdt.internal.ui.util.DisconnectUIUtils;
import com.ibm.debug.pdt.internal.ui.views.DebugConsoleSession;
import com.ibm.debug.pdt.ui.IDebugHelp;
import java.net.Socket;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IMemoryBlock;
import org.eclipse.debug.core.model.IMemoryBlockRetrieval;
import org.eclipse.debug.core.model.IThread;
import org.eclipse.equinox.security.storage.ISecurePreferences;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.preferences.ScopedPreferenceStore;
import org.eclipse.ui.texteditor.MarkerUtilities;

public class PICLDebugTarget
extends PDTDebugTarget
implements IProcessListSupplier,
IDaemonDebugTarget2 {
    private final PICLExtendedMemoryBlockRetrieval fMemorySupport = new PICLExtendedMemoryBlockRetrieval(this);
    private int fNewProcessDialogAnswer = -1;
    private String[] fSourceLineBPDialogAnswer = null;
    private IDebugHelp fHelpClass = null;
    private boolean fVariableViewVisible = true;
    private boolean fRegisterViewVisible = true;
    private boolean fHandledVariableViewHidden = true;
    private boolean fHandledRegisterViewHidden = true;
    private DebugConsoleSession fDebugConsoleSession = null;
    private IPropertyChangeListener fPreferenceChangeListener;
    private boolean fPreferencesLoaded = false;
    private ScopedPreferenceStore fScopedPreferenceStore;
    private static final String REMOTE_FILE_NAME_KEY = "remote_file_name_key";

    public PICLDebugTarget() {
    }

    public PICLDebugTarget(ILaunch launch, PICLAbstractStartupInfo startupInfo, Socket socket) {
        super(launch, startupInfo, socket);
        if (launch != null) {
            this.initTeamDebugEnv(launch, startupInfo);
        }
    }

    public PICLDebugTarget(ILaunch launch, PICLAbstractStartupInfo startupInfo, Socket socket, int key) {
        super(launch, startupInfo, socket, key);
        if (launch != null) {
            this.initTeamDebugEnv(launch, startupInfo);
        }
    }

    public void setLaunch(ILaunch launch) {
        super.setLaunch(launch);
        this.initTeamDebugEnv(launch, this.fStartupInfo);
    }

    protected void showExceptionDialog(final DebuggeeThread thread, final ProcessStopInfo stopInfo) {
        final PICLDebugTarget thisTarget = this;
        String message = stopInfo.getExceptionMsg();
        message = message != null ? message : PICLMessages.InternalError;
        this.traceException(thread, message);
        final Display display = PlatformUI.getWorkbench().getDisplay();
        if (display.isDisposed()) {
            return;
        }
        display.asyncExec(new Runnable(){

            @Override
            public void run() {
                PICLDebugTarget.this.setHandlingException(true);
                Shell shell = display.getActiveShell();
                ExceptionDialog dialog = new ExceptionDialog(shell, thisTarget, stopInfo, thread);
                dialog.open();
                PICLDebugTarget.this.setHandlingException(false);
            }
        });
    }

    protected void showForkDialog(final DebuggeeThread thread) {
        final PICLDebugTarget thisTarget = this;
        CommonUtils.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                int result = PICLDebugTarget.this.getForkDialogAnswer();
                if (result == -1 || result == 1 || result == 0 || result == 2) {
                    ForkDialog dialog = new ForkDialog(CommonUtils.getShell(), thisTarget);
                    dialog.open();
                    result = PICLDebugTarget.this.getForkDialogAnswer();
                }
                final int dialogResult = result;
                Job executeForkJob = new Job("Execute Fork"){

                    protected IStatus run(IProgressMonitor monitor) {
                        try {
                            if (dialogResult == 0 || dialogResult == 3) {
                                thread.executeForkAndFollowParent();
                            } else if (dialogResult == 1 || dialogResult == 4) {
                                thread.executeForkAndFollowChild();
                            } else if (dialogResult == 2 || dialogResult == 5) {
                                thread.executeForkAndFollowBoth();
                            }
                        }
                        catch (EngineRequestException e) {
                            PICLUtils.logError((Exception)((Object)e));
                            return new Status(4, PICLDebugPlugin.getPluginID(), 0, e.getMessage(), (Throwable)e);
                        }
                        return Status.OK_STATUS;
                    }
                };
                executeForkJob.setSystem(true);
                executeForkJob.schedule();
            }
        });
    }

    protected void showExecDialog(final DebuggeeProcess process) {
        final PICLDebugTarget thisTarget = this;
        CommonUtils.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                NewProcessDialog dialog = new NewProcessDialog(CommonUtils.getShell(), thisTarget);
                dialog.open();
                int result = PICLDebugTarget.this.getNewProcessDialogAnswer();
                String message = null;
                if (process.getProcessStopInfo() != null) {
                    message = process.getProcessStopInfo().getExceptionMsg();
                }
                if (message == null) {
                    message = PICLLabels.debug_element_unknown;
                }
                PICLDebugTarget.this.traceExec(process.getStoppingThread(), message, result == 1);
                if (result == 1) {
                    Job runToMainEntryPointJob = new Job("Run To Main Entry Point"){

                        protected IStatus run(IProgressMonitor monitor) {
                            process.resetRunToMainEntryPoint();
                            try {
                                process.runToMainEntryPoint();
                            }
                            catch (EngineRequestException e) {
                                return new Status(4, PICLDebugPlugin.getPluginID(), 0, e.getMessage(), (Throwable)e);
                            }
                            return Status.OK_STATUS;
                        }
                    };
                    runToMainEntryPointJob.setSystem(true);
                    runToMainEntryPointJob.schedule();
                }
            }
        });
    }

    public DebugConsoleSession getDebugConsoleSession() {
        return this.fDebugConsoleSession;
    }

    protected void loadWorkbenchBreakpoints() {
        int i;
        IMarker[] bpMarkers2;
        IBreakpoint[] breakpoints = this.getBreakpointManager().getBreakpoints();
        int i2 = 0;
        while (i2 < breakpoints.length) {
            if (breakpoints[i2] instanceof PICLBreakpoint && ((PICLBreakpoint)breakpoints[i2]).isImported()) {
                this.breakpointAdded(breakpoints[i2]);
            }
            ++i2;
        }
        try {
            bpMarkers2 = ResourcesPlugin.getWorkspace().getRoot().findMarkers("com.ibm.debug.pdt.common.GenericLineBreakpointMarker", true, 2);
            i = 0;
            while (i < bpMarkers2.length) {
                this.setSourceLineBreakpoint(bpMarkers2[i]);
                ++i;
            }
        }
        catch (CoreException bpMarkers2) {
            // empty catch block
        }
        try {
            bpMarkers2 = ResourcesPlugin.getWorkspace().getRoot().findMarkers("com.ibm.debug.pdt.core.PICLSourceEntryBreakpoint", true, 0);
            i = 0;
            while (i < bpMarkers2.length) {
                this.setSourceEntryBreakpoint(bpMarkers2[i]);
                ++i;
            }
        }
        catch (CoreException bpMarkers3) {
            // empty catch block
        }
        try {
            IConfigurationElement[] sourceBPAdapters = PDTCorePlugin.getSourceBreakpointAdapters();
            if (sourceBPAdapters == null) {
                return;
            }
            i = 0;
            while (i < sourceBPAdapters.length) {
                IMarker[] bpMarkers4;
                Object adapterClass = sourceBPAdapters[i].createExecutableExtension("class");
                if (adapterClass instanceof ISourceBreakpointAdapter && (bpMarkers4 = ((ISourceBreakpointAdapter)adapterClass).getSourceLineBreakpointMarkers()) != null) {
                    int j = 0;
                    while (j < bpMarkers4.length) {
                        this.setSourceLineBreakpoint(bpMarkers4[j]);
                        ++j;
                    }
                }
                ++i;
            }
        }
        catch (CoreException ce) {
            PICLUtils.logError((Exception)((Object)ce));
        }
    }

    public void setForkDialogAnswer(int value) {
        PICLDebugPlugin.setPrefRememberFork(value);
    }

    public int getForkDialogAnswer() {
        int choice = PICLDebugPlugin.getPrefRememberFork();
        if (!this.supportsRememberForkChoice()) {
            switch (choice) {
                case 5: {
                    choice = 2;
                    break;
                }
                case 4: {
                    choice = 1;
                    break;
                }
                case 3: {
                    choice = 0;
                    break;
                }
            }
        }
        return choice;
    }

    public void setNewProcessDialogAnswer(int value) {
        this.fNewProcessDialogAnswer = value;
    }

    public int getNewProcessDialogAnswer() {
        return this.fNewProcessDialogAnswer;
    }

    public void setSourceLineBPInfoDialogAnswer(String[] exeObj) {
        this.fSourceLineBPDialogAnswer = Arrays.copyOf(exeObj, exeObj.length);
    }

    public String[] getSourceLineBPInfoDialogAnswer() {
        return Arrays.copyOf(this.fSourceLineBPDialogAnswer, this.fSourceLineBPDialogAnswer.length);
    }

    protected boolean connectAndInit(byte language) {
        boolean result;
        if (this.fDebugConsoleSession == null) {
            this.fDebugConsoleSession = new DebugConsoleSession(this);
        }
        if (!(result = super.connectAndInit(language)) && this.getEngineSession().isAuthenticateConnection()) {
            String hostIP = this.getSocket().getInetAddress().getHostAddress();
            PICLUtils.removeCredentialFromSecureStorage(PICLDebugPlugin.getInstance().getSecurePreferences(), hostIP);
        }
        this.loadHelpClass();
        return result;
    }

    private String[] querySourceLineBreakpointProviders(IResource resource) {
        return null;
    }

    private String[] searchResourceForSavedBreakpointInfo(IResource resource) {
        block3: {
            String objectName;
            String moduleName;
            block4: {
                IMarker[] resourceMarkers = resource.findMarkers("com.ibm.debug.pdt.breakpointResourceInfoMarkerID", false, 0);
                if (resourceMarkers == null || resourceMarkers.length <= 0) break block3;
                IMarker breakpointResourceMarker = resourceMarkers[0];
                moduleName = breakpointResourceMarker.getAttribute("moduleName", "not_defined");
                objectName = breakpointResourceMarker.getAttribute("objectName", "not_defined");
                if (!"not_defined".equals(moduleName) && !"".equals(moduleName) && !"not_defined".equals(objectName) && !"".equals(objectName)) break block4;
                return null;
            }
            try {
                return new String[]{moduleName, objectName};
            }
            catch (CoreException ce) {
                PICLUtils.logError((Exception)((Object)ce));
            }
        }
        return null;
    }

    private String[] askUserForBreakpointInfo(final IMarker marker) {
        final PICLDebugTarget thisTarget = this;
        CommonUtils.getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                SourceLineBPInfoDialog dialog = new SourceLineBPInfoDialog(CommonUtils.getShell(), thisTarget, marker);
                dialog.open();
            }
        });
        return this.getSourceLineBPInfoDialogAnswer();
    }

    private boolean loadHelpClass() {
        String id = this.getEngineSession().getEngineExtensionID();
        if (id == null) {
            return false;
        }
        this.fHelpClass = PICLDebugPlugin.getHelpClass(id);
        return this.fHelpClass != null;
    }

    public IDebugHelp getHelpClass() {
        return this.fHelpClass;
    }

    public void saveToProfile() {
        IBreakpoint[] brkpts;
        DebuggeeProcess proc;
        boolean chkPnding;
        boolean bl = chkPnding = this.fBkptPendingActions != null && !this.fBkptPendingActions.isEmpty();
        if (chkPnding && (proc = this.getDebugEngine().getProcess()) != null) {
            Collection actions = this.fBkptPendingActions.values();
            for (PDTDebugTarget.BkpRequest req : actions) {
                IBreakpoint bkp = req.fBkp;
                byte action = req.fAction;
                if (action != 1) continue;
                if (bkp instanceof PICLBreakpoint) {
                    proc.removeBreakpoint(((PICLBreakpoint)bkp).getModelBreakpoint());
                    if (!(bkp instanceof PICLZeroAddressBreakpoint)) continue;
                    this.getDebugEngine().fZeroAddressBreakpointEnabled = false;
                    this.getDebugEngine().setZeroAddressBreakpointInstalled(false);
                    continue;
                }
                if (!(bkp instanceof PICLStopAtAllFunctionEntryBreakpoint)) continue;
                this.getDebugEngine().fAllEntryBreakpointsEnabled = false;
            }
        }
        if ((brkpts = this.getBreakpointManager().getBreakpoints(this.getModelIdentifier())) != null && brkpts.length > 0) {
            int i = 0;
            while (i < brkpts.length) {
                if (!(brkpts[i] instanceof PICLZeroAddressBreakpoint) && ((PICLBaseBreakpoint)brkpts[i]).getDebugTarget() == this) {
                    PICLBaseBreakpoint bp = (PICLBaseBreakpoint)brkpts[i];
                    if (bp instanceof PICLBreakpoint) {
                        ((PICLBreakpoint)bp).setWorkingSetName(PICLUtils.getWorkingSetName((IBreakpoint)bp));
                    }
                    bp.prepareToSave();
                }
                ++i;
            }
        }
        if (this.fProcess != null) {
            this.fProcess.savePgmObjects2();
        }
        if (this.getDebugEngine() != null) {
            this.getDebugEngine().saveDebugObjects();
        }
    }

    public void restoreFromProfile() {
        if (!this.getDebugEngine().getDebuggeeStartupOptions().restoreSavedObjects()) {
            return;
        }
        int flags = 0x1E00000;
        this.getDebugEngine().restoreDebugObjects(flags);
        flags = 849346560;
        if (PreferenceUI.isSaveExceptionsByProfile()) {
            flags |= 0x1000000;
        }
        this.fProcess.restorePgmObjects2(flags);
        this.initSpecialEngineOpts();
    }

    public void restoreFromConfig(ILaunchConfiguration config) {
        if (!this.getDebugEngine().getDebuggeeStartupOptions().restoreSavedObjects()) {
            return;
        }
        if (this.supportsCommandLog()) {
            String configStartupCommandList = "";
            try {
                configStartupCommandList = this.getLaunch().getLaunchConfiguration().getAttribute("StartupCommandList", "");
            }
            catch (CoreException ce) {
                PICLUtils.logError((Exception)((Object)ce));
            }
            String[] cmds = DebugConsoleUtils.toArray(configStartupCommandList);
            if (cmds == null || cmds.length == 0) {
                return;
            }
            int i = 0;
            while (i < cmds.length) {
                try {
                    this.getDebugEngine().commandLog(cmds[i], false, false);
                }
                catch (EngineRequestException ere) {
                    PICLUtils.logError((Exception)((Object)ere));
                    break;
                }
                ++i;
            }
        }
    }

    protected void addListeners() {
        super.addListeners();
        this.fPreferenceChangeListener = new PreferenceUIChangeListener(this);
        this.fScopedPreferenceStore = new ScopedPreferenceStore(InstanceScope.INSTANCE, "com.ibm.debug.pdt.ui");
        this.fScopedPreferenceStore.addPropertyChangeListener(this.fPreferenceChangeListener);
    }

    protected void removeListeners() {
        super.removeListeners();
        if (this.fScopedPreferenceStore != null) {
            this.fScopedPreferenceStore.removePropertyChangeListener(this.fPreferenceChangeListener);
        }
    }

    public IMemoryBlockRetrieval getMemorySupport() {
        return this.fMemorySupport;
    }

    public boolean supportsStorageRetrieval() {
        return this.fMemorySupport.supportsStorageRetrieval();
    }

    public IMemoryBlock getMemoryBlock(long startAddress, long length) throws DebugException {
        return this.fMemorySupport.getMemoryBlock(startAddress, length);
    }

    public void markMemBlksChanged(boolean fireEvent) {
        this.fMemorySupport.markMemBlksChanged(fireEvent);
    }

    public PICLMemoryBlock addMemoryBlock(PICLMemoryBlock memBlk) {
        return this.fMemorySupport.addMemoryBlock(memBlk);
    }

    public IThread[] getThreads() throws DebugException {
        if (PreferenceUI.isHideRunningThreads()) {
            IThread[] threads = super.getThreads();
            ArrayList<IThread> suspendedThreads = new ArrayList<IThread>();
            IThread[] iThreadArray = threads;
            int n = threads.length;
            int n2 = 0;
            while (n2 < n) {
                IThread thread = iThreadArray[n2];
                if (thread.isSuspended()) {
                    suspendedThreads.add(thread);
                }
                ++n2;
            }
            return suspendedThreads.toArray(new IThread[suspendedThreads.size()]);
        }
        return super.getThreads();
    }

    public void setVariableViewVisible(boolean visible) {
        this.fVariableViewVisible = visible;
        this.fHandledVariableViewHidden = visible;
    }

    public void setRegisterViewVisible(boolean visible) {
        this.fRegisterViewVisible = visible;
        this.fHandledRegisterViewHidden = visible;
    }

    protected void doCleanupDetails() {
        super.doCleanupDetails();
        this.fMemorySupport.cleanup();
    }

    public void modelStateChanged(ModelStateReadyEvent event) {
        DebuggeeThread currentThread;
        super.modelStateChanged(event);
        if (!this.supportsAsync() && this.fProcess != null) {
            this.processStopEvents(this.fProcess.getProcessStopInfo(), this.getStoppingThread());
        }
        if (event.getEventCode() != 0) {
            this.showEventDialog(event.getEventCode(), this.getStoppingThread().getId());
        }
        if ((currentThread = this.getCurrentThread()) != null) {
            currentThread.handleLocalsChanged();
        }
    }

    private void showEventDialog(final short eventType, final int threadId) {
        try {
            final String XML = this.getEventXML(eventType, threadId);
            final PICLDebugTarget thisTarget = this;
            CommonUtils.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    EventDialog dialog = new EventDialog(CommonUtils.getShell(), thisTarget, eventType, XML, threadId);
                    dialog.open();
                }
            });
        }
        catch (EngineRequestException e) {
            CommonUtils.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    MessageDialog.openWarning((Shell)CommonUtils.getShell(), (String)PICLLabels.MessageDialog_title_Warning, (String)e.getMessage());
                }
            });
        }
    }

    public void messageReceived(MessageReceivedEvent event) {
        super.messageReceived(event);
        final String msg = event.getMessage();
        if (msg == null || msg.isEmpty()) {
            return;
        }
        final Display display = PlatformUI.getWorkbench().getDisplay();
        display.asyncExec(new Runnable(){

            @Override
            public void run() {
                Shell shell = display.getActiveShell() != null ? display.getActiveShell() : CommonUtils.getWorkbenchShell();
                PICLDebugPlugin.showMessageDialog(shell, 2, PICLLabels.picl_debug_target_label_engine_message_title, msg, false);
            }
        });
    }

    public void errorOccurred(ErrorOccurredEvent event) {
        super.errorOccurred(event);
        this.fireChangeEvent(256);
    }

    public void preResume(boolean resumeAllThreads) {
        this.handleHiddenViews();
        super.preResume(resumeAllThreads);
    }

    private void handleHiddenViews() {
        if (!this.fVariableViewVisible && !this.fHandledVariableViewHidden) {
            this.stopMonitoringLocals();
            this.fHandledVariableViewHidden = true;
        }
        if (!this.fRegisterViewVisible && !this.fHandledRegisterViewHidden) {
            this.stopMonitoringRegisters();
            this.fHandledRegisterViewHidden = true;
        }
    }

    public void preStepping(boolean stepAllThreads) {
        this.handleHiddenViews();
        super.preStepping(stepAllThreads);
    }

    protected void setSourceLineBreakpoint(IMarker marker) {
        OptionalBreakpointData optBpData;
        IResource resource = marker.getResource();
        Object fileName = null;
        String fileExtension = null;
        if (resource instanceof IFile) {
            QualifiedName nameRemoteFileName = new QualifiedName("", REMOTE_FILE_NAME_KEY);
            String remoteFileName = null;
            try {
                remoteFileName = resource.getPersistentProperty(nameRemoteFileName);
            }
            catch (CoreException e) {
                remoteFileName = null;
            }
            if (remoteFileName != null && remoteFileName.trim().length() > 0 && (fileExtension = resource.getFileExtension()) != null && fileExtension.trim().length() > 0 && !remoteFileName.toUpperCase().endsWith("." + fileExtension.toUpperCase())) {
                fileName = remoteFileName + "." + fileExtension;
            }
            if (fileName == null) {
                fileName = resource.getName();
            }
            try {
                marker.setAttribute("fileName", fileName);
            }
            catch (CoreException e) {
                PICLUtils.logError((Exception)((Object)e));
            }
        } else {
            try {
                fileName = (String)marker.getAttribute("fileName");
                int index = ((String)fileName).lastIndexOf(46);
                if (index == ((String)fileName).length() - 1) {
                    fileExtension = "";
                }
                fileExtension = ((String)fileName).substring(index + 1);
            }
            catch (CoreException e) {
                PICLUtils.logError((Exception)((Object)e));
            }
        }
        if (fileExtension == null) {
            fileExtension = "";
        }
        String objectName = null;
        String moduleName = null;
        int lineNumber = 0;
        try {
            lineNumber = MarkerUtilities.getLineNumber((IMarker)marker);
            objectName = (String)marker.getAttribute("objectName");
            moduleName = (String)marker.getAttribute("moduleName");
            optBpData = new OptionalBreakpointData(marker);
        }
        catch (CoreException e) {
            PICLUtils.logError((Exception)((Object)e));
            optBpData = new OptionalBreakpointData();
        }
        Enumeration loadedBreakpoints = this.fBreakpoints.elements();
        Object currentBP = null;
        int currentLineNumber = 0;
        String currentFileName = "";
        Location location = null;
        ViewInformation viewInfo = this.getDebugEngine().getSourceViewInformation();
        while (loadedBreakpoints.hasMoreElements()) {
            currentBP = loadedBreakpoints.nextElement();
            if (!(currentBP instanceof LineBreakpoint) || !(currentFileName = ((LineBreakpoint)currentBP).getFileName()).equals(fileName) || (location = ((LineBreakpoint)currentBP).getLocationWithinView(viewInfo)) == null || (currentLineNumber = location.getLineNumber()) != lineNumber) continue;
            return;
        }
        boolean enable = true;
        enable = marker.getAttribute("org.eclipse.debug.core.enabled", true);
        enable = enable && this.getBreakpointManager().isEnabled();
        boolean searchThroughCurrentlyLoadedModules = false;
        boolean engineSupportsSourceLineBPs = this.supportsAmbiguousBreakpoints();
        boolean engineSupportsDeferredLineBPs = this.supportsDeferredBreakpoints();
        if ((moduleName == null || objectName == null) && (engineSupportsDeferredLineBPs || engineSupportsSourceLineBPs)) {
            if (engineSupportsSourceLineBPs) {
                if (moduleName == null) {
                    moduleName = "*";
                }
                if (objectName == null) {
                    objectName = "*";
                }
            } else if (engineSupportsDeferredLineBPs) {
                String[] exeObj = null;
                exeObj = this.querySourceLineBreakpointProviders(resource);
                if (exeObj == null) {
                    exeObj = this.searchResourceForSavedBreakpointInfo(resource);
                }
                if (exeObj == null) {
                    exeObj = this.askUserForBreakpointInfo(marker);
                }
                if (exeObj == null) {
                    return;
                }
                if (exeObj.length == 2) {
                    moduleName = exeObj[0];
                    objectName = exeObj[1];
                    PICLUtils.updateSourceLineBreakpoint(marker, moduleName, objectName);
                } else if (exeObj.length == 0) {
                    searchThroughCurrentlyLoadedModules = true;
                }
            } else {
                searchThroughCurrentlyLoadedModules = true;
            }
        } else {
            searchThroughCurrentlyLoadedModules = true;
        }
        if (moduleName != null && objectName != null && engineSupportsDeferredLineBPs) {
            try {
                this.createDeferredLineBreakpoint(enable, lineNumber, null, moduleName, objectName, (String)fileName, optBpData, PICLBreakpoint.getMarkerAsProperty((IMarker)marker));
            }
            catch (EngineRequestException e1) {
                PICLUtils.logError((Exception)((Object)e1));
            }
        } else if (searchThroughCurrentlyLoadedModules) {
            ViewFile searchViewFile = this.getViewFile((String)fileName, this.getDebugEngine().getSourceViewInformation());
            if (searchViewFile == null) {
                return;
            }
            Location bpLocation = new Location(searchViewFile, lineNumber);
            if (!bpLocation.isComplete()) {
                PICLUtils.logString((Object)this, PICLMessages.picl_engine_request_cannot_use_incomplete_location, 4);
                return;
            }
            moduleName = bpLocation.getPart().getModule().getName();
            objectName = bpLocation.getPart().getName();
            PICLUtils.updateSourceLineBreakpoint(marker, moduleName, objectName);
            PICLUtils.updateResourceSourceLineBPInfoMarker(marker.getResource(), moduleName, objectName);
            String stmtNumber = null;
            if (this.supportsStatementBreakpoints()) {
                stmtNumber = PDTCoreUtils.getStatementNumberFromLine((ViewFile)searchViewFile, (int)lineNumber);
            }
            try {
                this.createLineBreakpoint(enable, bpLocation, stmtNumber, optBpData, PICLBreakpoint.getMarkerAsProperty((IMarker)marker), null);
            }
            catch (EngineRequestException e1) {
                PICLUtils.logError((Exception)((Object)e1));
            }
        }
    }

    protected void setSourceEntryBreakpoint(IMarker marker) {
        OptionalBreakpointData optBpData;
        if (!this.supportsSourceEntryBreakpoint() || !this.supportsDeferredBreakpoints()) {
            return;
        }
        String entryName = null;
        try {
            entryName = (String)marker.getAttribute("entryName");
        }
        catch (CoreException e) {
            PICLUtils.logError((Exception)((Object)e));
        }
        String objectName = null;
        String moduleName = null;
        try {
            objectName = (String)marker.getAttribute("objectName");
            moduleName = (String)marker.getAttribute("moduleName");
            optBpData = new OptionalBreakpointData(marker);
        }
        catch (CoreException e) {
            PICLUtils.logError((Exception)((Object)e));
            optBpData = new OptionalBreakpointData();
        }
        boolean enable = true;
        enable = marker.getAttribute("org.eclipse.debug.core.enabled", true);
        boolean bl = enable = enable && this.getBreakpointManager().isEnabled();
        if (moduleName != null && objectName != null) {
            try {
                this.createDeferredEntryBreakpoint(enable, moduleName, objectName, entryName, false, optBpData, PICLBreakpoint.getMarkerAsProperty((IMarker)marker));
            }
            catch (EngineRequestException e1) {
                PICLUtils.logError((Exception)((Object)e1));
            }
        }
    }

    private void initSpecialEngineOpts() {
        if (this.supportsEntryAutoSet() && this.getDebugEngine().isAllEntryBreakpointsInstalled()) {
            IWorkspaceRoot resource = ResourcesPlugin.getWorkspace().getRoot();
            try {
                new PICLStopAtAllFunctionEntryBreakpoint((IResource)resource, (PDTDebugTarget)this, this.getDebugEngine().isAllEntryBreakpointsEnabled());
            }
            catch (CoreException coreException) {
                // empty catch block
            }
        }
        if (this.getDebugEngine().getDefaultMemoryRep() == -1) {
            if (this.is390OS() || this.isiSeriesOS()) {
                this.getDebugEngine().setDefaultMemoryRep(1);
            } else {
                this.getDebugEngine().setDefaultMemoryRep(0);
            }
        }
    }

    public void processAdded(ProcessAddedEvent event) {
        super.processAdded(event);
        if (this.fTeamDebugSession && this.fProcess != null) {
            this.initSpecialEngineOpts();
        }
        if (this.getLaunch() == null || this.isReconnect()) {
            return;
        }
        this.notifyIfNoDebugInfo();
        this.restoreFromProfile();
        this.restoreFromConfig(this.getLaunch().getLaunchConfiguration());
        this.loadWorkbenchBreakpoints();
        this.fSuppressInfoErrorsDuringStartup = false;
        this.handleRunToBreakpoint();
    }

    private void notifyIfNoDebugInfo() {
        if (this.is390()) {
            return;
        }
        try {
            DebuggeeThread stoppingThread;
            Location location;
            Part part;
            DebuggeeStartupOptions startupOptions = this.getDebugEngine().getDebuggeeStartupOptions();
            if (startupOptions instanceof DebuggeePrepareOptions && ((DebuggeePrepareOptions)startupOptions).runToMainEntryPoint() && !startupOptions.executeAfterStartup() && (part = (location = (stoppingThread = this.getStoppingThread()).getLocation()).getPart()) != null && !part.getModule().hasDebugInfo()) {
                PICLDebugPlugin.showMessageDialog(null, 2, NLS.bind((String)PICLMessages.picl_debug_target_no_debug_info, (Object)startupOptions.getDebuggeeName()), false);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void handleRunToBreakpoint() {
        if (this.fStartupInfo.getStartupBehaviour() == 2) {
            try {
                this.resume();
            }
            catch (DebugException e) {
                PICLUtils.logString((Object)this, "Failed to 'run debuggee to breakpoint' per its defined StartupBehaviour", 2, (Exception)((Object)e));
            }
        }
    }

    protected void logException(EngineRequestException e) {
        PICLDebugPlugin.showMessageDialog(null, this, e, false);
    }

    public void processStopped(ProcessStoppedEvent event) {
        super.processStopped(event);
        this.fMemorySupport.markMemBlksChanged(false);
    }

    public void threadStopped(ThreadStoppedEvent event) {
        super.threadStopped(event);
        if (this.supportsAsync()) {
            this.fMemorySupport.markMemBlksChanged(false);
            ProcessStopInfo stopInfo = event.getStopInfo();
            DebuggeeThread stoppingThread = event.getThread();
            if (this.supportsAsync()) {
                this.processStopEvents(stopInfo, stoppingThread);
            }
        }
    }

    private void processStopEvents(ProcessStopInfo stopInfo, DebuggeeThread stoppingThread) {
        if (stopInfo == null || stopInfo.isEventProcessed()) {
            return;
        }
        stopInfo.setEventProcessed();
        if (stopInfo.isStoppedByFork()) {
            this.showForkDialog(stoppingThread);
        } else if (stopInfo.isStoppedByException()) {
            this.showExceptionDialog(stoppingThread, stopInfo);
        } else if (stopInfo.isStoppedByExec()) {
            this.showExecDialog(this.fProcess);
        } else if (stopInfo.getReason() >= 200 && stopInfo.getReason() <= 299) {
            this.showEventDialog(stopInfo.getReason(), stoppingThread.getId());
        }
    }

    public DebuggeeThread getCurrentThread() {
        return PICLDebugPlugin.getCurrentThread();
    }

    public void engineIsWaiting(Socket socket, boolean socketReuse) {
        EngineParameters engineParms = this.fStartupInfo.getEngineParms();
        this.initTeamDebugAttribute(engineParms);
        String hostIP = socket.getInetAddress().getHostAddress();
        if (this.fStartupInfo.isAuthenticateSession()) {
            ISecurePreferences securePreferences = PICLDebugPlugin.getInstance().getSecurePreferences();
            if (securePreferences.nodeExists(hostIP)) {
                securePreferences = securePreferences.node(hostIP);
                String userID = PICLUtils.getUserIDFromSecureStorage(securePreferences);
                char[] password = PICLUtils.getPasswordFromSecureStorage(securePreferences);
                if (userID != null && userID.trim().length() > 0 && password != null && password.length > 0) {
                    this.fStartupInfo.setUserId(Base64.getEncoder().encodeToString(userID.getBytes(StandardCharsets.ISO_8859_1)));
                    this.fStartupInfo.setPassword(Base64.getEncoder().encodeToString(String.valueOf(password).getBytes(StandardCharsets.ISO_8859_1)).toCharArray());
                } else {
                    this.displayAuthenticateDialog(hostIP);
                }
            } else {
                this.displayAuthenticateDialog(hostIP);
            }
        }
        super.engineIsWaiting(socket);
        if (this.supportsTeamDebug()) {
            this.initTeamDebugLaunch(this.getLaunch(), engineParms);
        } else {
            this.fTeamDebugSession = false;
        }
    }

    public EPDC_EngineSession getEngineSession() {
        EPDC_EngineSession engineSession = super.getEngineSession();
        if (!this.fPreferencesLoaded && engineSession != null) {
            this.fPreferencesLoaded = true;
            if (PreferenceUI.isSocketTimeoutEnabled()) {
                engineSession.setConnectionTimeout(PreferenceUI.getSocketTimeout());
            } else {
                engineSession.setConnectionTimeout(0);
            }
            engineSession.setTerminateType(PreferenceUI.getTerminateType());
            engineSession.setGlobalEnginePath(PreferenceUI.getGlobalEnginePath());
            engineSession.setBrkptSuspendAllThreads(PreferenceUI.isBrkptSuspendAllThreads());
        }
        return engineSession;
    }

    private void initTeamDebugAttribute(EngineParameters engineParms) {
        if (engineParms == null) {
            return;
        }
        String teamAttribute = engineParms.getAttribute("qteamuser");
        this.fTeamDebugSession = teamAttribute != null && !teamAttribute.equals("PROMPT") && (this.getEngineSession() == null || this.supportsTeamDebug());
    }

    private void initTeamDebugLaunch(ILaunch launch, EngineParameters engineParms) {
        if (engineParms == null) {
            return;
        }
        if (this.fTeamDebugSession && launch != null) {
            Set keys = engineParms.getAttributeKeys();
            for (String key : keys) {
                launch.setAttribute(key, engineParms.getAttribute(key));
            }
            ITeamDebugSupport teamSupport = TeamDebugSupportProxy.getTeamDebugSupport();
            if (teamSupport != null) {
                teamSupport.teamDebugTargetCreated((IDebugTarget)this);
            }
        }
    }

    private void initTeamDebugEnv(ILaunch launch, PICLAbstractStartupInfo startupInfo) {
        EngineParameters engineParms = startupInfo.getEngineParms();
        this.initTeamDebugAttribute(engineParms);
        this.initTeamDebugLaunch(launch, engineParms);
    }

    public boolean isTeamDebugSession() {
        return this.fTeamDebugSession;
    }

    public boolean continueWaiting() {
        return PICLDebugPlugin.showQuestionDialog(PICLLabels.EngineNoResponseDialog_title, PICLMessages.EngineNoResponseDialog_confirmationWaiting);
    }

    public ProcessList getProcessDetailList() {
        if (PDTCorePlugin.fModel) {
            PDTCoreUtils.logString((Object)((Object)this), (String)".getProcessDetailList()");
        }
        if (!this.launchLocalEngine()) {
            return null;
        }
        int processIDCol = 0;
        int executableNameCol = 1;
        if (this.getEngineSession().getEngineOS() == 6) {
            processIDCol = 1;
            executableNameCol = 2;
        }
        ProcessListColumnDetails[] colDetails = this.getDebugEngine().getProcessListColumnDetails();
        SystemProcess[] processList = this.getDebugEngine().getSystemProcessList();
        try {
            this.terminate();
        }
        catch (DebugException debugException) {
            // empty catch block
        }
        String processIDColName = colDetails[processIDCol].getColumnName();
        String executableColName = colDetails[executableNameCol].getColumnName();
        ProcessDetail[] procDetails = new ProcessDetail[processList.length];
        int i = 0;
        while (i < processList.length) {
            ProcessDetail processDetail = new ProcessDetail();
            processDetail.setProcessID(processList[i].getProcessDetails()[processIDCol]);
            processDetail.setExecutableName(processList[i].getProcessDetails()[executableNameCol]);
            procDetails[i] = processDetail;
            ++i;
        }
        ProcessList pl = new ProcessList(procDetails, processIDColName, executableColName);
        return pl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean launchLocalEngine() {
        if (PDTCorePlugin.fModel) {
            PDTCoreUtils.logString((Object)((Object)this), (String)".launchEngine()");
        }
        if (this.getDebugEngine() != null) {
            if (!PDTCorePlugin.fModel) return true;
            PDTCoreUtils.logString((Object)((Object)this), (String)"An engine is already launched.");
            return true;
        }
        if (!CoreDaemon.startListening()) {
            if (!PDTCorePlugin.fModel) return false;
            PDTCoreUtils.logError((Exception)new Exception("CoreDaemon failed to start listening."));
            return false;
        }
        ILaunchConfigurationType type = DebugPlugin.getDefault().getLaunchManager().getLaunchConfigurationType("com.ibm.debug.attachPICLApplication");
        if (type == null) {
            if (!PDTCorePlugin.fModel) return false;
            PDTCoreUtils.logError((Exception)new Exception("Could not get the launch configuration type."));
            return false;
        }
        ILaunchConfigurationWorkingCopy config = null;
        try {
            config = type.newInstance(null, "temp");
        }
        catch (CoreException e) {
            if (!PDTCorePlugin.fModel) return false;
            PDTCoreUtils.logError((Exception)new Exception("Could not create a temporary launch configuration.", e));
            return false;
        }
        PDTDebugTarget.PICLNoTargetStartupInfo info = new PDTDebugTarget.PICLNoTargetStartupInfo();
        info.setLaunchConfig((ILaunchConfiguration)config);
        info.setLanguage((byte)2);
        this.fStartupInfo = info;
        int key = CoreDaemon.generateKey();
        CoreDaemon.storeDebugTarget((IDebugTarget)this, (int)key);
        if (!this.launchEngine(key)) {
            if (!PDTCorePlugin.fModel) return false;
            PDTCoreUtils.logError((Exception)new Exception("The engine launch failed."));
            return false;
        }
        PICLAbstractStartupInfo pICLAbstractStartupInfo = this.fStartupInfo;
        synchronized (pICLAbstractStartupInfo) {
            try {
                try {
                    this.fStartupInfo.wait(10000L);
                }
                catch (InterruptedException interruptedException) {
                    if (this.fCurrentState == 4) return true;
                    if (!PDTCorePlugin.fModel) return false;
                    PDTCoreUtils.logError((Exception)new Exception("The engine failed to connect and initialize."));
                    return false;
                }
            }
            catch (Throwable throwable) {
                if (this.fCurrentState == 4) throw throwable;
                if (!PDTCorePlugin.fModel) return false;
                PDTCoreUtils.logError((Exception)new Exception("The engine failed to connect and initialize."));
                return false;
            }
            if (this.fCurrentState == 4) return true;
            if (!PDTCorePlugin.fModel) return false;
            PDTCoreUtils.logError((Exception)new Exception("The engine failed to connect and initialize."));
            return false;
        }
    }

    private void displayAuthenticateDialog(String hostIPAddress) {
        final PICLAbstractStartupInfo startInfo = this.fStartupInfo;
        final String hostIP = hostIPAddress;
        Display display = PlatformUI.getWorkbench().getDisplay();
        display.syncExec(new Runnable(){

            @Override
            public void run() {
                Shell shell = PICLUtils.getShell();
                AuthenticateDialog dialog = new AuthenticateDialog(shell, startInfo, hostIP);
                dialog.open();
            }
        });
    }

    public void disconnect() throws DebugException {
        if (DisconnectUIUtils.supportsPrompt(this.getEngineSession())) {
            int disconnectType = PreferenceUI.getDisconnectType();
            if (disconnectType == Integer.MAX_VALUE && (disconnectType = DisconnectUIUtils.promptForDisconnectAction(this.getEngineSession())) == -1) {
                return;
            }
            super.disconnect(disconnectType);
        } else {
            super.disconnect();
        }
    }
}

