/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.internal.ui;

import com.ibm.debug.pdt.core.PDTDebugUtils;
import com.ibm.debug.pdt.core.breakpoints.PICLAddressBreakpoint;
import com.ibm.debug.pdt.core.breakpoints.PICLBaseBreakpoint;
import com.ibm.debug.pdt.core.breakpoints.PICLBreakpoint;
import com.ibm.debug.pdt.core.breakpoints.PICLEntryBreakpoint;
import com.ibm.debug.pdt.core.breakpoints.PICLLocationBreakpoint;
import com.ibm.debug.pdt.core.breakpoints.PICLStopAtAllFunctionEntryBreakpoint;
import com.ibm.debug.pdt.core.breakpoints.PICLZeroAddressBreakpoint;
import com.ibm.debug.pdt.internal.core.AbstractEditorFile;
import com.ibm.debug.pdt.internal.core.PDTDebugElement;
import com.ibm.debug.pdt.internal.core.PICLEmptyVariable;
import com.ibm.debug.pdt.internal.core.PICLLabels;
import com.ibm.debug.pdt.internal.core.PICLModule;
import com.ibm.debug.pdt.internal.core.PICLRegisterGroup;
import com.ibm.debug.pdt.internal.core.model.DebuggeeException;
import com.ibm.debug.pdt.internal.core.model.DebuggeeThread;
import com.ibm.debug.pdt.internal.core.model.Function;
import com.ibm.debug.pdt.internal.core.model.Language;
import com.ibm.debug.pdt.internal.core.model.Location;
import com.ibm.debug.pdt.internal.core.model.Part;
import com.ibm.debug.pdt.internal.core.model.StackFrame;
import com.ibm.debug.pdt.internal.core.model.View;
import com.ibm.debug.pdt.internal.core.model.ViewFile;
import com.ibm.debug.pdt.internal.core.sourcelocator.PDTLookupResult;
import com.ibm.debug.pdt.internal.core.util.PDTCoreUtils;
import com.ibm.debug.pdt.internal.ui.EditorMapping;
import com.ibm.debug.pdt.internal.ui.EngineSuppliedViewEditorInput;
import com.ibm.debug.pdt.internal.ui.PICLDebugPlugin;
import com.ibm.debug.pdt.internal.ui.PICLUtils;
import com.ibm.debug.pdt.internal.ui.breakpoints.BreakpointAnnotationProvider;
import com.ibm.debug.pdt.internal.ui.editor.DebuggerEditor;
import com.ibm.debug.pdt.internal.ui.preferences.PreferenceUI;
import com.ibm.debug.pdt.internal.ui.sourcelocator.PDTPartNotDebuggableEditorInput;
import com.ibm.debug.pdt.internal.ui.sourcelocator.PDTSourceNotFoundEditorInput;
import com.ibm.debug.pdt.internal.ui.views.PDTVariableLabelProvider;
import com.ibm.debug.pdt.ui.DebuggerMarkerAnnotationModel;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IBreakpointManager;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.model.ISourceLocator;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.core.model.IThread;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.debug.core.model.LineBreakpoint;
import org.eclipse.debug.core.sourcelookup.ISourceLookupDirector;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.IDebugEditorPresentation;
import org.eclipse.debug.ui.IDebugModelPresentation;
import org.eclipse.debug.ui.IValueDetailListener;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IPersistableElement;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.part.FileEditorInput;

public class PDTModelPresentation
extends LabelProvider
implements IDebugModelPresentation,
IDebugEditorPresentation {
    private final PDTVariableLabelProvider fVariableLabelProvider = new PDTVariableLabelProvider();

    public String getText(Object item) {
        if (PICLDebugPlugin.fPDT) {
            PICLUtils.logString((Object)this, ".getText(item.getClass().getName())");
        }
        if (item instanceof PICLEmptyVariable) {
            return PICLLabels.picl_variable_not_supported;
        }
        if (item instanceof IVariable) {
            return this.fVariableLabelProvider.getText(item);
        }
        if (item instanceof PICLBaseBreakpoint) {
            return ((PICLBaseBreakpoint)item).getLabel();
        }
        if (item instanceof PDTLookupResult) {
            return ((PDTLookupResult)item).getSourceFile().toString();
        }
        if (item instanceof String) {
            return (String)item;
        }
        if (item instanceof DebuggeeException) {
            String name = ((DebuggeeException)item).getName();
            if (name != null && name.length() != 0) {
                return name;
            }
            return PICLLabels.picl_stack_frame_label_unknown;
        }
        if (item instanceof PDTDebugElement) {
            String label = ((PDTDebugElement)item).getLabel();
            if (label != null) {
                return label;
            }
            return PICLLabels.debug_element_unknown;
        }
        return PICLLabels.debug_element_unknown;
    }

    public Image getImage(Object item) {
        if (item instanceof IMarker) {
            IBreakpointManager bpManager = DebugPlugin.getDefault().getBreakpointManager();
            IBreakpoint ibp = bpManager.getBreakpoint((IMarker)item);
            item = ibp;
        }
        if (item instanceof IBreakpoint) {
            IBreakpoint breakpoint = (IBreakpoint)item;
            int status = 0;
            try {
                status |= breakpoint.isEnabled() ? 2 : 0;
            }
            catch (CoreException e) {
                PICLUtils.logError((Exception)((Object)e));
            }
            Image bpImage = null;
            if (breakpoint instanceof PICLStopAtAllFunctionEntryBreakpoint) {
                bpImage = (status & 2) != 0 ? PICLUtils.getImage("PICL_ICON_BREAKPOINT_EI") : PICLUtils.getImage("PICL_ICON_BREAKPOINT_DI");
            } else if (breakpoint instanceof PICLBreakpoint) {
                status |= ((PICLBreakpoint)breakpoint).hasConditionalExpression() ? 4 : 0;
                status |= breakpoint instanceof PICLAddressBreakpoint || breakpoint instanceof PICLZeroAddressBreakpoint ? 32 : 0;
                bpImage = BreakpointAnnotationProvider.getBreakpointImage(status |= breakpoint instanceof PICLEntryBreakpoint ? 8 : 0);
            }
            return bpImage;
        }
        if (item instanceof IVariable) {
            return this.fVariableLabelProvider.getImage(item);
        }
        if (item instanceof PICLRegisterGroup) {
            return PICLUtils.getImage("PICL_ICON_REGISTER_GROUP");
        }
        if (item instanceof PICLModule) {
            if (((PICLModule)item).getModule() != null && ((PICLModule)item).getModule().hasSideFileDataSet()) {
                return PICLUtils.getImage("PICL_ICON_MODULE_WITH_SIDEFILE");
            }
            return PICLUtils.getImage("PICL_ICON_MODULE");
        }
        if (item instanceof Part) {
            return PICLUtils.getImage("PICL_ICON_PART");
        }
        if (item instanceof View) {
            return PICLUtils.getImage("PICL_ICON_PART");
        }
        if (item instanceof ViewFile) {
            if (((ViewFile)item).isSourceView()) {
                return PICLUtils.getImage("PICL_ICON_FILE");
            }
            return PICLUtils.getImage("PICL_ICON_NO_FILE");
        }
        if (item instanceof Function) {
            return PICLUtils.getImage("PICL_ICON_FUNCTION");
        }
        if (item instanceof DebuggeeThread) {
            if (((DebuggeeThread)item).isDisabled()) {
                return PICLUtils.getImage("PICL_ICON_THREAD_SUSPENDED_DISABLED");
            }
            return null;
        }
        if (item instanceof IProcess) {
            if (((IProcess)item).isTerminated()) {
                return DebugUITools.getImage((String)"IMG_OBJS_OS_PROCESS_TERMINATED");
            }
            return DebugUITools.getImage((String)"IMG_OBJS_OS_PROCESS");
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IEditorInput getEditorInput(Object item) {
        if (PICLDebugPlugin.fPDT) {
            PICLUtils.logString((Object)this, ".getEditorInput(" + String.valueOf(item) + ")");
        }
        if (!(item instanceof PDTLookupResult)) {
            item = this.lookupSourceElement(item);
        }
        if (!(item instanceof PDTLookupResult)) {
            return null;
        }
        PDTLookupResult locatedFile = (PDTLookupResult)item;
        ViewFile viewFile = locatedFile.getViewFile();
        Object sourceFile = locatedFile.getSourceFile();
        Object context = locatedFile.getContext();
        IDebugTarget dbgTgt = locatedFile.getDebugTarget();
        if (sourceFile == null) {
            if (context instanceof StackFrame) {
                StackFrame stackFrame = (StackFrame)context;
                if (!stackFrame.isDebuggable()) {
                    return new PDTPartNotDebuggableEditorInput(null, dbgTgt, context);
                }
                try {
                    if (!stackFrame.getLocation().getPart().isDebuggable()) {
                        return new PDTSourceNotFoundEditorInput(viewFile, dbgTgt, context);
                    }
                }
                catch (NullPointerException e) {
                    return new PDTSourceNotFoundEditorInput(viewFile, dbgTgt, context);
                }
            }
            return new PDTSourceNotFoundEditorInput(viewFile, dbgTgt, context);
        }
        boolean useDefaultEditor = this.useDefaultEditor(viewFile);
        boolean useCopy = false;
        if (useDefaultEditor) {
            useCopy = PDTModelPresentation.useCopyOfLocalFile(viewFile);
        }
        ViewFile viewFile2 = viewFile;
        synchronized (viewFile2) {
            try {
                AbstractEditorFile engineFile = AbstractEditorFile.createEngineFile((ViewFile)viewFile, (Object)sourceFile, (boolean)useCopy);
                engineFile = viewFile.setEditorFile(engineFile);
                if (engineFile.getErrorMessage() != null) {
                    PICLDebugPlugin.showMessageDialog(null, engineFile.getErrorMessage(), true);
                    engineFile.clearErrorMessage();
                }
                if (context instanceof IStackFrame) {
                    viewFile.setContext(context);
                }
                if (useDefaultEditor || this.useISeriesEditor(locatedFile)) {
                    engineFile.setMarkers(true);
                    IFile file = engineFile.getFile();
                    if (file != null) {
                        NonPersistentFileEditorInput input = null;
                        input = engineFile.isTempCopy() ? new NonPersistentFileEditorInput(file) : new FileEditorInput(file);
                        PICLUtils.resetViewFile((IEditorInput)input, viewFile);
                        return input;
                    }
                }
                EngineSuppliedViewEditorInput esei = new EngineSuppliedViewEditorInput(engineFile, viewFile);
                int lineNumber = 0;
                try {
                    if (context instanceof StackFrame) {
                        lineNumber = ((StackFrame)context).getLineNumber();
                    } else if (context instanceof LineBreakpoint) {
                        lineNumber = ((LineBreakpoint)context).getLineNumber();
                    } else if (context instanceof PICLLocationBreakpoint) {
                        lineNumber = ((PICLLocationBreakpoint)context).getLocation(viewFile.getView().getViewInformation()).getLineNumber();
                    }
                }
                catch (Exception e) {
                    PDTCoreUtils.logError((Exception)e);
                }
                esei.setInitialLine(lineNumber);
                return esei;
            }
            catch (Exception e) {
                PDTCoreUtils.logError((Exception)e);
            }
        }
        return null;
    }

    private boolean useDefaultEditor(ViewFile viewFile) {
        if (viewFile.isDynamic()) {
            return false;
        }
        if (PreferenceUI.isUseDefaultEditor() && EditorMapping.isEnabled() && !PDTDebugUtils.isiSeriesEngine((IDebugTarget)viewFile.getDebugTarget())) {
            boolean iszEngine;
            boolean bl = iszEngine = PDTDebugUtils.iszPICLEngine((IDebugTarget)viewFile.getDebugTarget()) || PDTDebugUtils.isDebugToolEngine((IDebugTarget)viewFile.getDebugTarget());
            if (!((viewFile.isSourceView() || viewFile.isListingView() && iszEngine) && viewFile.getFileName() != null)) {
                return false;
            }
            if (PreferenceUI.isUseDebuggerEditorWhenLargeFile()) {
                int lineNumberLimit = PreferenceUI.getSourceFileLineNumberLimit();
                if (viewFile.getNumberOfLines() > lineNumberLimit) {
                    return false;
                }
            }
            try {
                return EditorMapping.isMapped(PDTModelPresentation.getDefaultEditorID(viewFile), viewFile.getDebugEngine());
            }
            catch (PartInitException e) {
                return false;
            }
        }
        return false;
    }

    public static boolean useCopyOfLocalFile(ViewFile viewFile) {
        String defaultEditorId;
        try {
            defaultEditorId = PDTModelPresentation.getDefaultEditorID(viewFile);
        }
        catch (PartInitException e) {
            return true;
        }
        return EditorMapping.isCopyLocalRequired(defaultEditorId, viewFile.getDebugEngine());
    }

    private static String getDefaultEditorID(ViewFile viewFile) throws PartInitException {
        Language lang = viewFile.getPart().getLanguage();
        if (lang == null) {
            throw new PartInitException("Unknown language");
        }
        String baseName = viewFile.isIncludeFile() ? lang.appendIncludeFileExtension(viewFile.getBaseFileName()) : lang.appendFileExtension(viewFile.getBaseFileName());
        return IDE.getEditorDescriptor((String)baseName, (boolean)true, (boolean)false).getId();
    }

    private boolean useISeriesEditor(PDTLookupResult locatedFile) {
        if (!locatedFile.getViewFile().isDynamic() && PreferenceUI.isUseDefaultEditor()) {
            return PDTDebugUtils.isiSeriesEngine((IDebugTarget)locatedFile.getViewFile().getDebugTarget()) && locatedFile.getSourceFile() instanceof IFile && IDE.getDefaultEditor((IFile)((IFile)locatedFile.getSourceFile())) != null;
        }
        return false;
    }

    public String getEditorId(IEditorInput ei, Object inputObject) {
        String editorId = null;
        if (ei instanceof PDTPartNotDebuggableEditorInput) {
            editorId = "com.ibm.debug.pdt.ui.PDTPartNotDebuggableEditor";
        } else if (ei instanceof PDTSourceNotFoundEditorInput) {
            editorId = "com.ibm.debug.pdt.ui.PDTSourceNotFoundEditor";
        } else if (ei instanceof EngineSuppliedViewEditorInput) {
            editorId = "com.ibm.debug.pdt.ui.editor.DebuggerEditor";
        } else if (ei instanceof IFileEditorInput) {
            IEditorDescriptor desc;
            ViewFile viewFile = PICLUtils.getViewFile(ei);
            boolean useDefaultEditor = this.useDefaultEditor(viewFile);
            boolean useISeriesEditor = false;
            if (!useDefaultEditor) {
                if (!(inputObject instanceof PDTLookupResult)) {
                    inputObject = this.lookupSourceElement(inputObject);
                }
                if (inputObject != null && inputObject instanceof PDTLookupResult) {
                    useISeriesEditor = this.useISeriesEditor((PDTLookupResult)inputObject);
                }
            }
            if ((useDefaultEditor || useISeriesEditor) && (desc = IDE.getDefaultEditor((IFile)((IFileEditorInput)ei).getFile())) != null) {
                editorId = EditorMapping.getMappedEditorId(desc.getId(), viewFile.getDebugEngine());
            }
        }
        if (editorId == null) {
            editorId = "com.ibm.debug.pdt.ui.editor.DebuggerEditor";
        }
        return editorId;
    }

    public void setAttribute(String id, Object value) {
        this.fVariableLabelProvider.setAttribute(id, value);
    }

    public void computeDetail(IValue value, IValueDetailListener listener) {
        this.fVariableLabelProvider.computeDetail(value, listener);
    }

    public boolean addAnnotations(IEditorPart editorPart, IStackFrame frame) {
        if (!(frame instanceof StackFrame)) {
            return false;
        }
        if (editorPart instanceof DebuggerEditor) {
            try {
                int lineNumber = frame.getLineNumber();
                DebuggerEditor editor = (DebuggerEditor)editorPart;
                editor.gotoLine(lineNumber, true);
                editor.setCurrentExecutionPointLineNumber(lineNumber);
                IAnnotationModel annoModel = editor.getDocumentProvider().getAnnotationModel((Object)editorPart.getEditorInput());
                if (annoModel instanceof DebuggerMarkerAnnotationModel) {
                    ((DebuggerMarkerAnnotationModel)annoModel).addInstructionPointerAnnotation((StackFrame)frame);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return true;
        }
        return false;
    }

    public void removeAnnotations(IEditorPart editorPart, IThread thread) {
        if (!(thread instanceof DebuggeeThread)) {
            return;
        }
        if (editorPart instanceof DebuggerEditor) {
            try {
                DebuggerEditor editor = (DebuggerEditor)editorPart;
                editor.clearCurrentExecutionPointHighlighting();
                IAnnotationModel annoModel = editor.getDocumentProvider().getAnnotationModel((Object)editorPart.getEditorInput());
                if (annoModel instanceof DebuggerMarkerAnnotationModel) {
                    ((DebuggerMarkerAnnotationModel)annoModel).removeInstructionPointerAnnotations((DebuggeeThread)thread);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private Object lookupSourceElement(Object item) {
        if (PICLDebugPlugin.fPDT) {
            PICLUtils.logString((Object)this, ".lookupSourceElement(" + item.toString() + ")");
        }
        IDebugTarget debugTarget = null;
        if (item instanceof IMarker) {
            IBreakpointManager bpManager = DebugPlugin.getDefault().getBreakpointManager();
            IBreakpoint ibp = bpManager.getBreakpoint((IMarker)item);
            item = ibp;
        }
        if (item instanceof PICLLocationBreakpoint) {
            if (((PICLLocationBreakpoint)item).isDeferred()) {
                return null;
            }
            debugTarget = ((PICLLocationBreakpoint)item).getDebugTarget();
            return this.lookupSourceElementIgnoringDuplicates(item, debugTarget);
        }
        if (item instanceof PDTDebugElement) {
            debugTarget = ((PDTDebugElement)item).getDebugTarget();
        } else if (item instanceof Location) {
            debugTarget = ((Location)item).getViewFile().getDebugTarget();
        }
        if (debugTarget == null || debugTarget.isTerminated()) {
            return null;
        }
        ISourceLocator sourceLocator = debugTarget.getLaunch().getSourceLocator();
        if (sourceLocator != null && sourceLocator instanceof ISourceLookupDirector) {
            ISourceLookupDirector lookup = (ISourceLookupDirector)sourceLocator;
            return lookup.getSourceElement(item);
        }
        return null;
    }

    private Object lookupSourceElementIgnoringDuplicates(Object item, IDebugTarget debugTarget) {
        if (debugTarget == null || debugTarget.isTerminated() || debugTarget.getLaunch() == null) {
            return null;
        }
        ISourceLocator sourceLocator = debugTarget.getLaunch().getSourceLocator();
        if (sourceLocator != null && sourceLocator instanceof ISourceLookupDirector) {
            Object[] results;
            block5: {
                ISourceLookupDirector lookup = (ISourceLookupDirector)sourceLocator;
                results = lookup.findSourceElements(item);
                if (results.length != 0) break block5;
                return null;
            }
            try {
                return results[0];
            }
            catch (CoreException coreException) {
                // empty catch block
            }
        }
        return null;
    }

    private static class NonPersistentFileEditorInput
    extends FileEditorInput {
        public NonPersistentFileEditorInput(IFile file) {
            super(file);
        }

        public IPersistableElement getPersistable() {
            return null;
        }
    }
}

