/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.internal.ui;

import com.ibm.debug.pdt.internal.core.engine.EngineIdentifier;
import com.ibm.debug.pdt.internal.core.model.DebugEngine;
import com.ibm.debug.pdt.internal.epdc.IEPDCConstants;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;

public class EditorMapping {
    private static boolean fgEditorMappingsRead = false;
    private static List<EditorMap> fgEditorMappings = new LinkedList<EditorMap>();
    private static EditorMap fgLastEditorMapMatch = null;

    private static void initialize() {
        IConfigurationElement[] configElements;
        fgEditorMappingsRead = true;
        IConfigurationElement[] iConfigurationElementArray = configElements = Platform.getExtensionRegistry().getConfigurationElementsFor("com.ibm.debug.pdt.ui.defaulteditor");
        int n = configElements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement configurationElement = iConfigurationElementArray[n2];
            fgEditorMappings.add(new EditorMap(configurationElement));
            ++n2;
        }
        Collections.sort(fgEditorMappings);
    }

    private static EditorMap getMatchingMap(String editorId, String engineKey) {
        if (!fgEditorMappingsRead) {
            EditorMapping.initialize();
        }
        if (fgLastEditorMapMatch != null && EditorMapping.fgLastEditorMapMatch.fDefaultEditorId.equals(editorId) && EditorMapping.fgLastEditorMapMatch.fDebugEngineId.equals(engineKey)) {
            return fgLastEditorMapMatch;
        }
        EditorMap finalMatch = null;
        EditorMap editorQuery = new EditorMap(editorId, engineKey);
        int firstResult = fgEditorMappings.indexOf(editorQuery);
        if (firstResult >= 0) {
            int lastResult = fgEditorMappings.lastIndexOf(editorQuery);
            for (EditorMap matched : fgEditorMappings.subList(firstResult, lastResult + 1)) {
                if (!matched.isApplicableToEngine(editorQuery.fEngineAffinities[0]) || finalMatch != null && (!matched.isSpecialized() || finalMatch.isSpecialized())) continue;
                finalMatch = matched;
            }
            if (finalMatch != null) {
                EditorMapping.setLastEditorMapMatch(finalMatch, engineKey);
            }
        }
        return finalMatch;
    }

    private static void setLastEditorMapMatch(EditorMap match, String engineKey) {
        if (fgLastEditorMapMatch != null) {
            EditorMapping.fgLastEditorMapMatch.fDebugEngineId = null;
        }
        match.fDebugEngineId = engineKey;
        fgLastEditorMapMatch = match;
    }

    public static synchronized boolean isEnabled() {
        if (!fgEditorMappingsRead) {
            EditorMapping.initialize();
        }
        return !fgEditorMappings.isEmpty();
    }

    public static synchronized String getMappedEditorId(String editorId, DebugEngine activeEngine) {
        return EditorMapping.getMappedEditorId(editorId, activeEngine.getUniqueEngineKey());
    }

    public static synchronized String getMappedEditorId(String editorId, String engineKey) {
        EditorMap match = EditorMapping.getMatchingMap(editorId, engineKey);
        return match != null ? match.fWrappedEditorId : editorId;
    }

    public static synchronized boolean isCopyLocalRequired(String editorId, DebugEngine activeEngine) {
        EditorMap match = EditorMapping.getMatchingMap(editorId, activeEngine.getUniqueEngineKey());
        return match != null ? match.fCreateLocalCopy : true;
    }

    public static synchronized boolean isMapped(String editorId, DebugEngine activeEngine) {
        return EditorMapping.isMapped(editorId, activeEngine.getUniqueEngineKey());
    }

    public static synchronized boolean isMapped(String editorId, String engineKey) {
        EditorMap match = EditorMapping.getMatchingMap(editorId, engineKey);
        return match != null;
    }

    private static class EditorMap
    implements Comparable<EditorMap> {
        private static final EngineIdentifier[] NO_SPECIFICATION = new EngineIdentifier[0];
        String fDefaultEditorId;
        String fWrappedEditorId;
        boolean fCreateLocalCopy = true;
        EngineIdentifier[] fEngineAffinities = NO_SPECIFICATION;
        String fDebugEngineId = null;

        EditorMap(IConfigurationElement mappedEditorConfig) {
            IConfigurationElement[] platformSpecializations;
            this.fDefaultEditorId = mappedEditorConfig.getAttribute("defaultEditorId");
            this.fWrappedEditorId = mappedEditorConfig.getAttribute("wrapperEditorId");
            String copyLocal = mappedEditorConfig.getAttribute("createLocalCopy");
            if (copyLocal != null && copyLocal.equalsIgnoreCase("false")) {
                this.fCreateLocalCopy = false;
            }
            if ((platformSpecializations = mappedEditorConfig.getChildren("platformSpecialization")).length > 0) {
                this.fEngineAffinities = new EngineIdentifier[platformSpecializations.length];
                int i = 0;
                while (i < platformSpecializations.length) {
                    short type = Short.parseShort(platformSpecializations[i].getAttribute("type"));
                    short os = Short.parseShort(platformSpecializations[i].getAttribute("os"));
                    short hardware = Short.parseShort(platformSpecializations[i].getAttribute("hw"));
                    this.fEngineAffinities[i] = new EngineIdentifier(type, os, hardware);
                    ++i;
                }
            }
        }

        EditorMap(String engineId, String engineKey) {
            this.fDefaultEditorId = engineId;
            if (engineKey != null) {
                this.fEngineAffinities = new EngineIdentifier[1];
                this.fEngineAffinities[0] = this.getEngineIdentifier(engineKey);
                this.fDebugEngineId = engineKey;
            }
        }

        private EngineIdentifier getEngineIdentifier(String engineKey) {
            char[] c = engineKey.toCharArray();
            assert (c.length == 3);
            int engineType = 0;
            int platformOS = 0;
            int platformHW = 0;
            int i = 0;
            while (i < IEPDCConstants.PLATFORM_OS_CHAR.length) {
                if (IEPDCConstants.PLATFORM_OS_CHAR[i] == c[0]) {
                    platformOS = i;
                    break;
                }
                i = (short)(i + 1);
            }
            i = 0;
            while (i < IEPDCConstants.ENGINE_TYPE_CHAR.length) {
                if (IEPDCConstants.ENGINE_TYPE_CHAR[i] == c[1]) {
                    engineType = i;
                    break;
                }
                i = (short)(i + 1);
            }
            i = 0;
            while (i < IEPDCConstants.PLATFORM_HDW_CHAR.length) {
                if (IEPDCConstants.PLATFORM_HDW_CHAR[i] == c[2]) {
                    platformHW = i;
                    break;
                }
                i = (short)(i + 1);
            }
            return new EngineIdentifier((short)engineType, (short)platformOS, (short)platformHW);
        }

        boolean isSpecialized() {
            return this.fEngineAffinities != NO_SPECIFICATION;
        }

        boolean isApplicableToEngine(EngineIdentifier activeEngineIdentifier) {
            if (!this.isSpecialized()) {
                return true;
            }
            EngineIdentifier[] engineIdentifierArray = this.fEngineAffinities;
            int n = this.fEngineAffinities.length;
            int n2 = 0;
            while (n2 < n) {
                EngineIdentifier specialization = engineIdentifierArray[n2];
                if (specialization.equals((Object)activeEngineIdentifier)) {
                    return true;
                }
                ++n2;
            }
            return false;
        }

        @Override
        public int compareTo(EditorMap other) {
            return this.fDefaultEditorId.compareTo(other.fDefaultEditorId);
        }

        public boolean equals(Object obj) {
            return obj instanceof EditorMap ? this.compareTo((EditorMap)obj) == 0 : false;
        }

        public int hashCode() {
            return this.fDefaultEditorId.hashCode();
        }
    }
}

