/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.internal.ui;

import com.ibm.debug.pdt.core.IPDTDebugTarget;
import com.ibm.debug.pdt.internal.core.PDTCorePlugin;
import com.ibm.debug.pdt.internal.ui.PICLDebugPlugin;
import com.ibm.debug.pdt.internal.ui.PICLDebugTarget;
import com.ibm.debug.pdt.internal.ui.actions.BreakpointsViewMenuListener;
import com.ibm.debug.pdt.internal.ui.actions.VariablesViewMenuListener;
import java.util.List;
import org.eclipse.debug.ui.AbstractDebugView;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.contexts.IDebugContextListener;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.IStartup;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWindowListener;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class EarlyStartup
implements IStartup,
IWindowListener,
IPartListener2 {
    private static VariablesViewMenuListener fVariablesViewMenuListener = new VariablesViewMenuListener();
    private static BreakpointsViewMenuListener fBreakpointsViewMenuListener = new BreakpointsViewMenuListener();

    public void earlyStartup() {
        IWorkbench workBench = PlatformUI.getWorkbench();
        workBench.addWindowListener((IWindowListener)this);
        IWorkbenchWindow[] windows = workBench.getWorkbenchWindows();
        int i = 0;
        while (i < windows.length) {
            windows[i].getPartService().addPartListener((IPartListener2)this);
            ++i;
        }
        i = 0;
        while (i < windows.length) {
            final IWorkbenchPage[] pages = windows[i].getPages();
            workBench.getDisplay().syncExec(new Runnable(){

                @Override
                public void run() {
                    int j = 0;
                    while (j < pages.length) {
                        IViewPart part = pages[j].findView("org.eclipse.debug.ui.VariableView");
                        if (part != null) {
                            EarlyStartup.this.addViewMenuListener((AbstractDebugView)part, fVariablesViewMenuListener);
                        }
                        if ((part = pages[j].findView("org.eclipse.debug.ui.BreakpointView")) != null) {
                            EarlyStartup.this.addViewMenuListener((AbstractDebugView)part, fBreakpointsViewMenuListener);
                        }
                        ++j;
                    }
                }
            });
            ++i;
        }
        DebugUITools.getDebugContextManager().addDebugContextListener((IDebugContextListener)PICLDebugPlugin.getInstance());
    }

    public void windowActivated(IWorkbenchWindow window) {
    }

    public void windowClosed(IWorkbenchWindow window) {
        window.getPartService().removePartListener((IPartListener2)this);
    }

    public void windowDeactivated(IWorkbenchWindow window) {
    }

    public void windowOpened(IWorkbenchWindow window) {
        window.getPartService().addPartListener((IPartListener2)this);
    }

    public void partActivated(IWorkbenchPartReference partRef) {
    }

    public void partBroughtToTop(IWorkbenchPartReference partRef) {
    }

    public void partClosed(IWorkbenchPartReference partRef) {
        String viewId = partRef.getId();
        if (viewId.equals("org.eclipse.debug.ui.VariableView")) {
            IWorkbenchPart part = partRef.getPart(false);
            AbstractDebugView view = (AbstractDebugView)part;
            this.removeViewMenuListeners(view);
            this.variableViewVisible(false);
        } else if (viewId.equals("org.eclipse.debug.ui.BreakpointView")) {
            IWorkbenchPart part = partRef.getPart(false);
            AbstractDebugView view = (AbstractDebugView)part;
            this.removeViewMenuListeners(view);
        } else if (viewId.equals("org.eclipse.debug.ui.RegisterView")) {
            this.registerViewVisible(false);
        }
    }

    public void partDeactivated(IWorkbenchPartReference partRef) {
    }

    public void partHidden(IWorkbenchPartReference partRef) {
        String viewId = partRef.getId();
        if (viewId.equals("org.eclipse.debug.ui.VariableView")) {
            this.variableViewVisible(false);
        } else if (viewId.equals("org.eclipse.debug.ui.RegisterView")) {
            this.registerViewVisible(false);
        }
    }

    public void partInputChanged(IWorkbenchPartReference partRef) {
    }

    public void partOpened(IWorkbenchPartReference partRef) {
        String viewId = partRef.getId();
        if (viewId.equals("org.eclipse.debug.ui.VariableView")) {
            IWorkbenchPart part = partRef.getPart(false);
            AbstractDebugView view = (AbstractDebugView)part;
            this.addViewMenuListener(view, fVariablesViewMenuListener);
            this.variableViewVisible(true);
        } else if (viewId.equals("org.eclipse.debug.ui.BreakpointView")) {
            IWorkbenchPart part = partRef.getPart(false);
            AbstractDebugView view = (AbstractDebugView)part;
            this.addViewMenuListener(view, fBreakpointsViewMenuListener);
        } else if (viewId.equals("org.eclipse.debug.ui.RegisterView")) {
            this.registerViewVisible(true);
        }
    }

    public void partVisible(IWorkbenchPartReference partRef) {
        String viewId = partRef.getId();
        if (viewId.equals("org.eclipse.debug.ui.VariableView")) {
            this.variableViewVisible(true);
        } else if (viewId.equals("org.eclipse.debug.ui.RegisterView")) {
            this.registerViewVisible(true);
        }
    }

    private void variableViewVisible(boolean visible) {
        IPDTDebugTarget[] iPDTDebugTargetArray = PDTCorePlugin.getDebugTargets();
        int n = iPDTDebugTargetArray.length;
        int n2 = 0;
        while (n2 < n) {
            IPDTDebugTarget debugTarget = iPDTDebugTargetArray[n2];
            if (debugTarget instanceof PICLDebugTarget) {
                ((PICLDebugTarget)debugTarget).setVariableViewVisible(visible);
            }
            ++n2;
        }
    }

    private void registerViewVisible(boolean visible) {
        IPDTDebugTarget[] iPDTDebugTargetArray = PDTCorePlugin.getDebugTargets();
        int n = iPDTDebugTargetArray.length;
        int n2 = 0;
        while (n2 < n) {
            IPDTDebugTarget debugTarget = iPDTDebugTargetArray[n2];
            if (debugTarget instanceof PICLDebugTarget) {
                ((PICLDebugTarget)debugTarget).setRegisterViewVisible(visible);
            }
            ++n2;
        }
    }

    private void addViewMenuListener(AbstractDebugView view, IMenuListener menuListener) {
        if (view == null) {
            return;
        }
        List menuMgrs = view.getContextMenuManagers();
        for (IMenuManager menuMgr : menuMgrs) {
            menuMgr.addMenuListener(menuListener);
        }
    }

    private void removeViewMenuListeners(AbstractDebugView view) {
        if (view == null) {
            return;
        }
        List menuMgrs = view.getContextMenuManagers();
        for (IMenuManager menuMgr : menuMgrs) {
            menuMgr.removeMenuListener((IMenuListener)fVariablesViewMenuListener);
            menuMgr.removeMenuListener((IMenuListener)fBreakpointsViewMenuListener);
        }
    }
}

