/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.frameworks.internal.enablement;

import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.wst.common.frameworks.internal.WTPResourceHandler;
import org.eclipse.wst.common.frameworks.internal.enablement.FunctionGroupPatternBinding;
import org.eclipse.wst.common.frameworks.internal.enablement.IGroupInitializer;
import org.eclipse.wst.common.frameworks.internal.enablement.Util;
import org.eclipse.wst.common.frameworks.internal.plugin.WTPCommonPlugin;

public class FunctionGroup
implements Comparable {
    public static final String GROUP_NAME_ATTR = "name";
    public static final String GROUP_DESC_ATTR = "description";
    public static final String GROUP_ENABLED_BY_DEFAULT_ATTR = "enabledByDefault";
    public static final String GROUP_PRIORITY_ATTR = "priority";
    public static final String GROUP_INTIALIZER_CLASS_ATTR = "initializerClassName";
    private static final int NEGATIVE_PRIORITY = -1;
    private String groupID;
    private String name;
    private String description;
    private String intializerClassName;
    private String declaringExtension;
    private int priority = -1;
    private IConfigurationElement element;
    private IGroupInitializer groupInterface;
    private Set functionGroupPatternBindings;
    private boolean errorReported = false;

    public FunctionGroup(String groupID, IConfigurationElement element) {
        this.groupID = groupID;
        this.element = element;
    }

    public String getDescription() {
        if (this.description == null) {
            this.description = this.element.getAttribute(GROUP_DESC_ATTR);
        }
        return this.description;
    }

    String getInitalizerClassName() {
        if (this.intializerClassName == null) {
            this.intializerClassName = this.element.getAttribute(GROUP_INTIALIZER_CLASS_ATTR);
        }
        return this.intializerClassName;
    }

    public String getName() {
        if (this.name == null) {
            this.name = this.element.getAttribute(GROUP_NAME_ATTR);
        }
        return this.name;
    }

    private String getDeclaringExtensionName() {
        if (this.declaringExtension == null) {
            if (this.element.getDeclaringExtension() == null) {
                return "";
            }
            this.declaringExtension = this.element.getDeclaringExtension().toString();
        }
        return this.declaringExtension;
    }

    public String getGroupID() {
        return this.groupID;
    }

    IGroupInitializer getInitializerClass() {
        if (this.groupInterface == null) {
            try {
                this.groupInterface = (IGroupInitializer)this.element.createExecutableExtension(GROUP_INTIALIZER_CLASS_ATTR);
            }
            catch (CoreException e) {
                WTPCommonPlugin.logError(WTPResourceHandler.getString("29", new Object[]{GROUP_INTIALIZER_CLASS_ATTR, this.getInitalizerClassName(), this.getDeclaringExtensionName()}) + "\r\n");
                WTPCommonPlugin.logError(e);
            }
        }
        return this.groupInterface;
    }

    public String toString() {
        return "\"" + this.getName() + "\" (" + this.getGroupID() + ")";
    }

    public int getPriority() {
        if (this.priority == -1) {
            this.priority = Integer.parseInt(this.element.getAttribute(GROUP_PRIORITY_ATTR));
        }
        return this.priority;
    }

    public boolean isEnabled(IProject project) {
        if (this.getInitializerClass() != null) {
            return this.getInitializerClass().isGroupEnabled(project);
        }
        return false;
    }

    public int compareTo(Object o) {
        if (this.equals(o)) {
            return 0;
        }
        if (!(o instanceof FunctionGroup)) {
            return 1;
        }
        FunctionGroup group = (FunctionGroup)o;
        if (this.getPriority() == group.getPriority()) {
            return this.getGroupID().compareTo(group.getGroupID());
        }
        if (this.getPriority() < group.getPriority()) {
            return -1;
        }
        return 1;
    }

    public boolean isMatch(String string) {
        if (this.functionGroupPatternBindings == null) {
            if (!this.errorReported) {
                WTPCommonPlugin.logError(WTPResourceHandler.getString("30", new Object[]{this.getGroupID()}));
                this.errorReported = true;
            }
            return false;
        }
        for (FunctionGroupPatternBinding functionGroupPatternBinding : this.functionGroupPatternBindings) {
            if (!functionGroupPatternBinding.getPattern().matcher(string).matches()) continue;
            return true;
        }
        return false;
    }

    boolean setFunctionGroupPatternBindings(Set functionGroupPatternBindings) {
        Set safeFunctionGroupPatternBindings = Util.safeCopy(functionGroupPatternBindings, FunctionGroupPatternBinding.class);
        if (!Util.equals(safeFunctionGroupPatternBindings, this.functionGroupPatternBindings)) {
            this.functionGroupPatternBindings = safeFunctionGroupPatternBindings;
            return true;
        }
        return false;
    }
}

