/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.codecoverage.ui.internal.launch;

import com.ibm.debug.daemon.CoreDaemon;
import com.ibm.debug.pdt.codecoverage.core.results.ICCConstants;
import com.ibm.debug.pdt.codecoverage.internal.core.CCData;
import com.ibm.debug.pdt.codecoverage.internal.core.CCDebugTarget;
import com.ibm.debug.pdt.codecoverage.internal.core.CCParams;
import com.ibm.debug.pdt.codecoverage.internal.core.CCUtilities;
import com.ibm.debug.pdt.codecoverage.internal.core.Labels;
import com.ibm.debug.pdt.codecoverage.internal.core.Messages;
import com.ibm.debug.pdt.codecoverage.internal.core.utilities.CCCoreUtilities;
import com.ibm.debug.pdt.codecoverage.ui.internal.launch.CCUIData;
import com.ibm.debug.pdt.codecoverage.ui.internal.launch.ICCLicenseCheck;
import com.ibm.debug.pdt.core.IPDTDebugTarget;
import com.ibm.debug.pdt.internal.core.EngineParameters;
import com.ibm.debug.pdt.internal.core.IDebugSessionStartupInfo;
import com.ibm.debug.pdt.internal.core.ISpecializedDebugTargetProvider;
import com.ibm.debug.pdt.internal.core.OldEngineParameters;
import com.ibm.debug.pdt.internal.core.launch.IPICLAttachInfo;
import com.ibm.debug.pdt.internal.core.launch.IPICLLoadInfo;
import com.ibm.debug.pdt.internal.core.launch.PICLAbstractStartupInfo;
import com.ibm.debug.pdt.internal.ui.PICLDebugPlugin;
import java.util.ArrayList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.model.IDebugTarget;

public class CodeCoverageDebugTargetProvider
implements ISpecializedDebugTargetProvider {
    private static final Object fLicenseCheckLock = new Object();
    private static ICCLicenseCheck[] fLicensecheckProviders = null;

    public IPDTDebugTarget createDebugTarget(ILaunch launch, IDebugSessionStartupInfo startupInfo, ILaunchConfiguration launchConfig, int key) {
        if (!this.checkLicense()) {
            return null;
        }
        boolean createDebugTarget = false;
        CCParams properties = new CCParams(startupInfo.getProperties());
        if (launch != null) {
            if (launch.getLaunchMode().equals("compiled_coverage")) {
                createDebugTarget = true;
            }
        } else if (startupInfo instanceof PICLAbstractStartupInfo) {
            createDebugTarget = ((PICLAbstractStartupInfo)startupInfo).isCodeCoverage();
            EngineParameters engineParameters = ((PICLAbstractStartupInfo)startupInfo).getEngineParms();
            if (engineParameters instanceof OldEngineParameters && ((OldEngineParameters)engineParameters).getUser() != null) {
                properties.setProperty("creator", ((OldEngineParameters)engineParameters).getUser());
            }
        }
        if (createDebugTarget) {
            block30: {
                if (launchConfig != null) {
                    try {
                        properties.setProperty("Istartupcommandlist_nofile", launchConfig.getAttribute("StartupCommandList", ""));
                        properties.setProperty("cclevel", launchConfig.getAttribute("CODE_COVERAGE_LEVEL", ICCConstants.COVERAGE_LEVEL.LINE.toString()));
                        if (launchConfig.getAttribute("ccFilterList", false)) {
                            if (launchConfig.hasAttribute("ccFilterListPath") && !launchConfig.getAttribute("ccFilterListPath", "").isEmpty()) {
                                properties.setProperty("Imodulefilter", launchConfig.getAttribute("ccFilterListPath", ""));
                            } else if (launchConfig.hasAttribute("ccFilterListPathV2")) {
                                properties.setProperty("filterlist", launchConfig.getAttribute("ccFilterListPathV2", ""));
                            }
                        }
                        properties.setProperty("ignoreerrors", launchConfig.getAttribute("ignoreerrors", false));
                        if (launchConfig.hasAttribute("testid")) {
                            properties.setProperty("testid", launchConfig.getAttribute("testid", ""));
                        }
                        if (launchConfig.hasAttribute("tag")) {
                            properties.setProperty("tag", launchConfig.getAttribute("tag", ""));
                        }
                        properties.setProperty("ccGenerateHtml", launchConfig.getAttribute("ccGenerateHtml", false));
                        properties.setProperty("ccGeneratePDF", launchConfig.getAttribute("ccGeneratePDF", false));
                        if (launchConfig.hasAttribute("root") && !launchConfig.getAttribute("root", "").isEmpty()) {
                            properties.setProperty("root", launchConfig.getAttribute("root", ""));
                        }
                    }
                    catch (CoreException e) {
                        CCUtilities.log((Throwable)e);
                    }
                }
                if (startupInfo instanceof PICLAbstractStartupInfo) {
                    properties.setProperty("attach", Boolean.toString(((PICLAbstractStartupInfo)startupInfo).isAttach()));
                    if (startupInfo instanceof IPICLLoadInfo) {
                        properties.setProperty("programName", ((IPICLLoadInfo)startupInfo).getProgramName());
                        properties.setProperty("programParms", ((IPICLLoadInfo)startupInfo).getProgramParms());
                    } else if (startupInfo instanceof IPICLAttachInfo) {
                        properties.setPgmNameOverride(true);
                        properties.setProperty("processId", ((IPICLAttachInfo)startupInfo).getProcessID());
                    }
                    if (((PICLAbstractStartupInfo)startupInfo).getEngineParms() != null) {
                        properties.setAllowOuputParam(false);
                        String startupKey = ((PICLAbstractStartupInfo)startupInfo).getEngineParms().getStartupKey();
                        CCCoreUtilities.processStartupkey((String)startupKey, (CCParams)properties);
                        try {
                            properties.validateOutputParameter();
                        }
                        catch (CCParams.CCParseException e) {
                            PICLDebugPlugin.showMessageDialog(null, (int)4, (String)Labels.CCMessageTitle, (String)Messages.CRRDG7149, (boolean)true);
                        }
                        String programName = properties.getProperty("programName", null);
                        if (programName != null && !programName.isEmpty()) {
                            try {
                                int targetId = Integer.parseInt(programName);
                                IDebugTarget target = CoreDaemon.retrieveDebugTarget((int)targetId);
                                if (target instanceof CCDebugTarget) {
                                    return (CCDebugTarget)target;
                                }
                                break block30;
                            }
                            catch (NumberFormatException e) {
                                if (key == -1) {
                                    return null;
                                }
                                break block30;
                            }
                        }
                        if (key == -1) {
                            return null;
                        }
                    }
                }
            }
            CCUIData data = new CCUIData(properties);
            return new CCDebugTarget(null, launch, (CCData)data, key);
        }
        return null;
    }

    private boolean checkLicense() {
        ICCLicenseCheck[] providers = CodeCoverageDebugTargetProvider.getLicenseCheckProviders();
        if (providers.length == 0) {
            return true;
        }
        ICCLicenseCheck[] iCCLicenseCheckArray = providers;
        int n = providers.length;
        int n2 = 0;
        while (n2 < n) {
            ICCLicenseCheck provider = iCCLicenseCheckArray[n2];
            if (provider.checkLicense(true)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ICCLicenseCheck[] getLicenseCheckProviders() {
        Object object = fLicenseCheckLock;
        synchronized (object) {
            if (fLicensecheckProviders == null) {
                ArrayList<ICCLicenseCheck> providers = new ArrayList<ICCLicenseCheck>();
                IExtensionPoint ep = Platform.getExtensionRegistry().getExtensionPoint("com.ibm.debug.pdt.codecoverage.ui.launch.ccLicense");
                if (ep != null) {
                    IConfigurationElement[] elements;
                    IConfigurationElement[] iConfigurationElementArray = elements = ep.getConfigurationElements();
                    int n = elements.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IConfigurationElement config = iConfigurationElementArray[n2];
                        try {
                            providers.add((ICCLicenseCheck)config.createExecutableExtension("class"));
                        }
                        catch (CoreException e) {
                            CCUtilities.log((Throwable)e);
                        }
                        catch (ClassCastException e) {
                            CCUtilities.log((Throwable)e);
                        }
                        ++n2;
                    }
                }
                fLicensecheckProviders = providers.toArray(new ICCLicenseCheck[providers.size()]);
            }
            return fLicensecheckProviders;
        }
    }
}

