/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.codecoverage.ui.internal.launch;

import com.ibm.debug.pdt.codecoverage.internal.core.CCUtilities;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.eclipse.rse.core.SystemResourceManager;
import org.osgi.framework.Bundle;

public class CCResultsViewUtils {
    private static final String CC_UI_FOLDER = "codecoverage";
    private static final IProject fProject = SystemResourceManager.getRemoteSystemsTempFilesProject();

    public static IPath getDefaultResultsPath(String resultName) {
        Bundle bundle = Platform.getBundle((String)"com.ibm.debug.pdt.codecoverage.core");
        return Platform.getStateLocation((Bundle)bundle).append(resultName);
    }

    public static IFolder getProjectLinkedFolder(String resultName) throws CoreException {
        IPath results = CCResultsViewUtils.getDefaultResultsPath(resultName);
        if (!results.toFile().exists() && !results.toFile().mkdir()) {
            CCUtilities.log((String)("Failed to create result directory " + String.valueOf(results)));
        }
        return CCResultsViewUtils.getProjectLinkedFolder(resultName, results);
    }

    private static IFolder getProjectLinkedFolder(String linkFolder, IPath pathToFolder) throws CoreException {
        IFolder folder = CCResultsViewUtils.getProjectFolder();
        if (!(folder = folder.getFolder(linkFolder)).exists()) {
            folder.create(true, true, null);
        }
        if (pathToFolder != null) {
            folder.createLink(pathToFolder, 256, null);
        }
        return folder;
    }

    private static IFolder getProjectFolder() throws CoreException {
        IFolder folder;
        IProject project = fProject;
        if (!project.exists()) {
            project.create(null);
        }
        if (!project.isOpen()) {
            project.open(null);
        }
        if (!(folder = project.getFolder(CC_UI_FOLDER)).exists()) {
            folder.create(true, true, null);
        }
        return folder;
    }
}

