/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ut.help.parser.json;

import com.ibm.ut.help.parser.json.IJSONHandler;
import com.ibm.ut.help.parser.json.JSONElement;
import com.ibm.ut.help.parser.json.StateJSONElement;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Stack;

public class JSONParser {
    private IJSONHandler handler;
    private Stack elementStack;
    private boolean stop = false;
    private String name = "";
    private String val = "";
    private JSONElement root = null;
    private String charset = null;
    public static int NONE = 0;
    public static int IN_NAME = 1;
    public static int IN_QNAME = 2;
    public static int IN_VAL = 3;
    public static int IN_QVAL = 4;
    public static int LIST = 5;

    public JSONParser() {
    }

    public JSONParser(String charset) {
        this.charset = charset;
    }

    public JSONElement parse(InputStream in) throws IOException {
        return this.parse(in, null);
    }

    public JSONElement parse(InputStream in, IJSONHandler handler) throws IOException {
        int read;
        if (in == null) {
            return null;
        }
        StringBuffer string = new StringBuffer();
        InputStreamReader reader = this.charset == null ? new InputStreamReader(in) : new InputStreamReader(in, this.charset);
        char[] buffer = new char[8224];
        while ((read = reader.read(buffer)) > -1) {
            string.append(buffer, 0, read);
        }
        this.parse(string.toString(), handler);
        reader.close();
        return this.getRoot();
    }

    public JSONElement parse(String in) {
        return this.parse(in, null);
    }

    public JSONElement parse(String in, IJSONHandler handler) {
        if (in == null) {
            return null;
        }
        this.handler = handler;
        this.elementStack = new Stack();
        int state = NONE;
        int prev = 32;
        int i = 0;
        while (i < in.length()) {
            char c = in.charAt(i);
            switch (c) {
                case '{': {
                    this.start();
                    this.name = "";
                    this.val = "";
                    state = IN_NAME;
                    break;
                }
                case '}': {
                    this.addProp();
                    this.end();
                    state = NONE;
                    break;
                }
                case '[': {
                    state = LIST;
                    break;
                }
                case ']': {
                    if (state == LIST) {
                        this.emptyList();
                    }
                    state = IN_NAME;
                    break;
                }
                case ':': {
                    if (state == IN_QVAL) {
                        this.val = String.valueOf(this.val) + c;
                        break;
                    }
                    ((StateJSONElement)this.getCurrentElement()).lastName = this.name.trim();
                    state = IN_VAL;
                    break;
                }
                case ',': {
                    if (state == IN_VAL) {
                        state = IN_NAME;
                        this.addProp();
                        break;
                    }
                    if (state != IN_QVAL) break;
                    this.val = String.valueOf(this.val) + c;
                    break;
                }
                case '\"': 
                case '\'': {
                    if (prev != 92) {
                        if (state == NONE || state == IN_NAME) {
                            state = IN_QNAME;
                            break;
                        }
                        if (state == IN_QNAME) {
                            state = IN_NAME;
                            break;
                        }
                        if (state != IN_QVAL) {
                            state = IN_QVAL;
                            break;
                        }
                        state = IN_VAL;
                        break;
                    }
                }
                default: {
                    if (state == IN_NAME || state == IN_QNAME) {
                        this.name = String.valueOf(this.name) + c;
                        break;
                    }
                    if (state != IN_VAL && state != IN_QVAL) break;
                    this.val = String.valueOf(this.val) + c;
                }
            }
            prev = c;
            if (this.stop) {
                return this.getRoot();
            }
            ++i;
        }
        return this.getRoot();
    }

    public JSONElement getRoot() {
        return this.root;
    }

    private void start() {
        StateJSONElement element = new StateJSONElement();
        if (!this.elementStack.isEmpty()) {
            StateJSONElement e = (StateJSONElement)this.elementStack.peek();
            ArrayList<StateJSONElement> list = (ArrayList<StateJSONElement>)e.get(e.lastName);
            if (list == null) {
                list = new ArrayList<StateJSONElement>();
                e.put(e.lastName, list);
            }
            list.add(element);
        } else {
            this.root = element;
        }
        this.elementStack.push(element);
    }

    private void end() {
        JSONElement element = (JSONElement)this.elementStack.pop();
        if (this.handler != null) {
            this.handler.endElement(element);
        }
    }

    private void emptyList() {
        StateJSONElement e = (StateJSONElement)this.elementStack.peek();
        e.put(e.lastName, new ArrayList());
    }

    private void addProp() {
        this.name = this.name.trim();
        this.val = this.val.trim();
        if (!this.name.equals("") && ((JSONElement)this.elementStack.peek()).get(this.name) == null) {
            try {
                int v = Integer.parseInt(this.val);
                ((JSONElement)this.elementStack.peek()).put(this.name, new Integer(v));
            }
            catch (Exception exception) {
                try {
                    long v = Long.parseLong(this.val);
                    ((JSONElement)this.elementStack.peek()).put(this.name, new Long(v));
                }
                catch (Exception exception2) {
                    this.val = this.val.replaceAll("\\\\'", "'");
                    ((JSONElement)this.elementStack.peek()).setProperty(this.name, this.val);
                }
            }
            if (this.handler != null) {
                this.handler.property((JSONElement)this.elementStack.peek(), this.name, this.val);
            }
        }
        this.name = "";
        this.val = "";
    }

    public void forceStop() {
        this.stop = true;
    }

    public Stack getElementStack() {
        return this.elementStack;
    }

    public JSONElement getCurrentElement() {
        return (JSONElement)this.elementStack.peek();
    }

    public JSONElement getParentElement() {
        if (this.elementStack.size() >= 2) {
            return (JSONElement)this.elementStack.get(this.elementStack.size() - 2);
        }
        return null;
    }
}

