/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ut.help.parser;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;

public class TagOutputStreamWriter
extends Writer {
    private final String TAB = "  ";
    private Writer writer;
    private StringBuffer buffer = new StringBuffer();
    private int offset = 0;
    private StringBuffer text = new StringBuffer();

    public TagOutputStreamWriter() {
        this(new OutputStreamWriter(new ByteArrayOutputStream()));
    }

    public TagOutputStreamWriter(Writer writer) {
        this.writer = writer;
    }

    @Override
    public void close() throws IOException {
        this.writer.close();
    }

    @Override
    public void flush() throws IOException {
        this.writer.flush();
    }

    public void setOffset(int offset) {
        this.offset = offset;
    }

    @Override
    public void write(char[] arg0, int arg1, int arg2) throws IOException {
        int g;
        int l;
        String chunk = "";
        this.buffer.append(arg0, arg1, arg2);
        if (this.buffer.toString().startsWith("\n")) {
            this.buffer = new StringBuffer(this.buffer.substring(1));
        }
        while ((l = this.buffer.indexOf("<")) > -1 && (g = this.buffer.indexOf(">")) > -1) {
            if (l == 0) {
                chunk = this.buffer.substring(l, g + 1);
                this.buffer = new StringBuffer(this.buffer.substring(g + 1));
            } else if (l < g) {
                chunk = this.buffer.substring(0, l);
                this.buffer = new StringBuffer(this.buffer.substring(l));
            } else {
                chunk = this.buffer.substring(0, g + 1);
                this.buffer = new StringBuffer(this.buffer.substring(g + 1));
            }
            if (this.isEndChunk(chunk)) {
                --this.offset;
            }
            this.writer.append(this.offset() + chunk + "\n");
            this.text.append(this.offset() + chunk + "\n");
            if (!this.isStartChunk(chunk)) continue;
            ++this.offset;
        }
    }

    private String offset() {
        StringBuffer tmp = new StringBuffer();
        int i = 0;
        while (i < this.offset) {
            tmp.append("  ");
            ++i;
        }
        return tmp.toString();
    }

    private boolean isEndChunk(String chunk) {
        if (chunk.length() < 2) {
            return false;
        }
        return chunk.charAt(1) == '/';
    }

    private boolean isStartChunk(String chunk) {
        if (!chunk.contains("<")) {
            return false;
        }
        return !chunk.contains("</") && !chunk.contains("/>");
    }

    public String toString() {
        return this.text.toString();
    }
}

