/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ut.help.parser;

import com.ibm.ut.help.parser.Element;
import com.ibm.ut.help.parser.TextElement;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;

public class TagElement
extends Element {
    protected StringBuffer codeBuffer = new StringBuffer();
    protected Properties props;
    protected String tag;
    protected TagElement parent = null;
    protected List children = new ArrayList();
    protected boolean isEndTag = false;
    private boolean isSpecialTag;
    private boolean isInline;
    private boolean modified = false;

    public TagElement(String tag) {
        this(tag, null);
    }

    public TagElement(String tag, Properties props) {
        this.tag = tag;
        this.props = props;
    }

    public Properties getProps() {
        return this.props;
    }

    public String getTag() {
        return this.tag;
    }

    public boolean isSpecialTag() {
        return this.isSpecialTag;
    }

    public boolean isInline() {
        return this.isInline;
    }

    public void setInline(boolean inline) {
        this.isInline = inline;
    }

    public String getProperty(String name) {
        if (this.props != null) {
            Enumeration<Object> keys = this.props.keys();
            while (keys.hasMoreElements()) {
                String key = (String)keys.nextElement();
                if (!key.equalsIgnoreCase(name)) continue;
                return this.props.getProperty(key);
            }
        }
        return "";
    }

    public boolean equals(TagElement element) {
        if (!this.getTag().equals(element.getTag())) {
            return false;
        }
        return this.getProps().equals(element.getProps());
    }

    public void addChild(Object child) {
        StackTraceElement[] trace = new Exception().getStackTrace();
        if (!trace[1].toString().startsWith("com.ibm.ut.help.parser.TagParser")) {
            this.setModified(true);
        }
        if (child instanceof TagElement) {
            ((TagElement)child).parent = this;
        }
        this.children.add(child);
    }

    public void prependChild(Object child) {
        StackTraceElement[] trace = new Exception().getStackTrace();
        if (!trace[1].toString().startsWith("com.ibm.ut.help.parser.TagParser")) {
            this.setModified(true);
        }
        if (child instanceof TagElement) {
            ((TagElement)child).parent = this;
        }
        ArrayList<Object> newKids = new ArrayList<Object>();
        newKids.add(child);
        int c = 0;
        while (c < this.children.size()) {
            newKids.add(this.children.get(c));
            ++c;
        }
        this.children = newKids;
    }

    public void replaceChild(int index, Object child) {
        StackTraceElement[] trace = new Exception().getStackTrace();
        if (!trace[1].toString().startsWith("com.ibm.ut.help.parser.TagParser")) {
            this.setModified(true);
        }
        if (child instanceof TagElement) {
            ((TagElement)child).parent = this;
        }
        this.children.set(index, child);
    }

    public List getChildren() {
        return this.children;
    }

    public void setModified(boolean modified) {
        this.modified = modified;
        TagElement current = this;
        if (modified) {
            while ((current = current.parent) != null) {
                current.modified = true;
            }
        }
    }

    public void setChildren(List children) {
        this.children = children;
        StackTraceElement[] trace = new Exception().getStackTrace();
        if (!trace[1].toString().startsWith("com.ibm.ut.help.parser.TagParser")) {
            this.setModified(true);
        }
    }

    public void setEndTag(boolean val) {
        this.isEndTag = val;
    }

    public void setSpecialTag(boolean val) {
        this.isSpecialTag = val;
    }

    public boolean isEndTag() {
        return this.isEndTag;
    }

    public void setProperty(String name, String val) {
        this.props.setProperty(name, val);
        this.setModified(true);
    }

    public void removeProperty(String name) {
        this.props.remove(name);
    }

    public void appendCode(String code) {
        this.codeBuffer.append(code);
    }

    public String toString() {
        if (this.modified) {
            return this.serialize(0);
        }
        if (this.codeBuffer.toString().equals("")) {
            return this.serialize(0);
        }
        return this.codeBuffer.toString();
    }

    public String toFormattedString() {
        return this.serialize(0);
    }

    @Override
    public String serialize(int indent) {
        if (!this.modified && !this.codeBuffer.toString().equals("")) {
            return this.codeBuffer.toString();
        }
        StringBuffer buffer = new StringBuffer();
        String offset = this.indent(indent);
        if (this.tag != null) {
            buffer.append(offset + "<" + this.getTag());
            if (this.getProps() != null) {
                Enumeration<Object> keys = this.getProps().keys();
                while (keys.hasMoreElements()) {
                    String key = (String)keys.nextElement();
                    if (key.equals("")) continue;
                    String val = this.getProps().getProperty(key);
                    if (val.contains("\"")) {
                        buffer.append(" " + key + "='" + val + "'");
                        continue;
                    }
                    buffer.append(" " + key + "=\"" + val + "\"");
                }
            }
            if (this.getChildren().isEmpty()) {
                if (this.isSpecialTag) {
                    buffer.append("?>\n");
                } else {
                    buffer.append("/>\n");
                }
                return buffer.toString();
            }
            buffer.append(">");
        } else {
            --indent;
        }
        boolean inline = false;
        StringBuffer kidBuffer = new StringBuffer();
        int c = 0;
        while (c < this.getChildren().size()) {
            Object kid = this.getChildren().get(c);
            if (kid instanceof TextElement) {
                if (((TextElement)kid).isInline()) {
                    inline = true;
                    kidBuffer.append(((TextElement)kid).serializeInline(indent + 1));
                } else {
                    kidBuffer.append(((TextElement)kid).serialize(indent + 1));
                }
            } else if (kid instanceof TagElement) {
                if (inline) {
                    kidBuffer.append(((TagElement)kid).serializeInline(indent + 1));
                } else {
                    kidBuffer.append(((TagElement)kid).serialize(indent + 1));
                }
            } else {
                inline = true;
                kidBuffer.append(kid.toString());
            }
            if (c == 0 && !inline && this.tag != null) {
                buffer.append('\n');
            }
            ++c;
        }
        buffer.append(kidBuffer);
        if (this.tag != null) {
            if (!inline) {
                buffer.append(offset);
            }
            buffer.append("</" + this.getTag() + ">");
        }
        buffer.append('\n');
        return buffer.toString();
    }

    @Override
    public String serializeInline(int indent) {
        if (!this.modified && !this.codeBuffer.toString().equals("")) {
            return this.codeBuffer.toString();
        }
        StringBuffer buffer = new StringBuffer();
        if (!this.isInline) {
            this.indent(indent);
        }
        if (this.tag != null) {
            buffer.append("<" + this.getTag());
            if (this.getProps() != null) {
                Enumeration<Object> keys = this.getProps().keys();
                while (keys.hasMoreElements()) {
                    String key = (String)keys.nextElement();
                    if (key.equals("")) continue;
                    String val = this.getProps().getProperty(key);
                    if (val.contains("\"")) {
                        buffer.append(" " + key + "='" + val + "'");
                        continue;
                    }
                    buffer.append(" " + key + "=\"" + val + "\"");
                }
            }
            if (this.getChildren().isEmpty()) {
                if (this.isSpecialTag) {
                    buffer.append("?>");
                } else {
                    buffer.append("/>");
                }
                return buffer.toString();
            }
            buffer.append('>');
        } else {
            --indent;
        }
        int c = 0;
        while (c < this.getChildren().size()) {
            Object kid = this.getChildren().get(c);
            if (kid instanceof Element) {
                buffer.append(((Element)kid).serializeInline(indent + 1));
            } else {
                buffer.append(kid.toString());
            }
            ++c;
        }
        if (this.tag != null) {
            buffer.append("</" + this.getTag() + ">");
        }
        return buffer.toString();
    }

    public String printInnerHTML() {
        StringBuffer innerHTML = new StringBuffer();
        int k = 0;
        while (k < this.getChildren().size()) {
            Object kid = this.getChildren().get(k);
            if (kid instanceof Element) {
                innerHTML.append(((Element)kid).serializeInline(0));
            } else {
                innerHTML.append(kid.toString());
            }
            ++k;
        }
        return innerHTML.toString();
    }
}

